/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public enum LanguageContributor {
    INSTANCE;

    private static final String DVT_VIEW_EXTENSION_POINT_ID = "ro.amiq.dvt.specador";
    private static final String DVT_VIEW_CONTRIBUTOR_ELEMENT = "contributor";
    private static final Map<LanguageKind, ISpecadorContributor> contributors;

    static {
        contributors = new EnumMap<LanguageKind, ISpecadorContributor>(LanguageKind.class);
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(DVT_VIEW_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (!DVT_VIEW_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + " for extension point: " + DVT_VIEW_EXTENSION_POINT_ID));
                }
                try {
                    Object executableExtension = configurationElement.createExecutableExtension("class");
                    contributors.put(((ISpecadorContributor)executableExtension).getLanguageKind(), (ISpecadorContributor)executableExtension);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void init(SpecadorModel model) {
        contributors.forEach((kind, contributor) -> contributor.setModel(model));
    }

    public static ISpecadorContributor get(LanguageKind languageKind) {
        return contributors.get((Object)languageKind);
    }
}

