/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import ro.amiq.dvt.IDVTProgressMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.specador.SpecadorExitCode;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public class SpecadorProgressMonitor
implements IProgressMonitor,
IDVTProgressMonitor {
    private String beginTaskName;
    private int beginTaskTotalWork;
    private long beginTaskTime;
    private long beginSphinxTime;
    private long overwrittenDuration = -1L;
    private long time = -1L;
    private int workDone = -1;
    private SpecadorExitCode exitCode = SpecadorExitCode.SUCCESS;
    private SpecadorModel model;
    private IProject project;
    private IProgressMonitor eclipseMonitor;
    private String currentTask;
    private SubMonitor subMonitor;
    private SubMonitor specadorMonitor;
    private SubMonitor sphinxMonitor;
    private boolean useMakefile;
    public static final int NO_PROGRESS = -1;
    private static final int SPHINX_PERCENTAGE = 50;

    public SpecadorProgressMonitor(SpecadorModel model, IProgressMonitor monitor) {
        this.project = model.getProject();
        this.model = model;
        this.eclipseMonitor = monitor;
    }

    public void beginLanguage(SpecadorLanguageKind kind) {
        kind.beginLanguage();
    }

    public void endLanguage(SpecadorLanguageKind kind) {
        kind.endLanguage();
    }

    public long getLanguageElapsedTime(SpecadorLanguageKind kind) {
        return kind.getLanguageElapsedTime();
    }

    public void beginSphinx() {
        this.beginSphinxTime = System.currentTimeMillis();
    }

    public void beginTask(String name, int totalWork) {
        this.subMonitor = SubMonitor.convert((IProgressMonitor)this.eclipseMonitor, (String)name, (int)100);
        this.specadorMonitor = this.subMonitor.split(50).setWorkRemaining(totalWork);
        this.beginTaskName = name;
        this.beginTaskTotalWork = totalWork;
        this.beginTaskTime = System.currentTimeMillis();
        this.workDone = 0;
        ProgressPrinter.INSTANCE.printProgressRaw(this.project, String.valueOf(this.beginTaskName) + "... ");
    }

    public void subTask(String name) {
        this.currentTask = this.startTask(name);
        this.subMonitor.subTask(name);
    }

    public void worked(int work) {
        if (this.beginTaskTotalWork != 0) {
            this.workDone += work;
        }
        ProgressPrinter.INSTANCE.printProgressRaw(this.project, String.valueOf(this.currentTask) + this.endTask());
        this.specadorMonitor.worked(work);
    }

    public void workedSphinx() {
        if (this.sphinxMonitor == null) {
            this.sphinxMonitor = this.subMonitor.split(50).setWorkRemaining(2);
        }
        this.sphinxMonitor.worked(1);
        this.useMakefile = true;
    }

    public boolean hasFinishedSuccesfully() {
        return !this.isCanceled() && this.exitCode == SpecadorExitCode.SUCCESS;
    }

    public void done() {
        this.beginTaskTotalWork = 0;
        if (this.hasFinishedSuccesfully()) {
            long elapsedSphinxTime = System.currentTimeMillis() - this.beginSphinxTime;
            long elapsedTime = System.currentTimeMillis() - this.beginTaskTime;
            if (this.model.hasVlogNature()) {
                ProgressPrinter.INSTANCE.printProgressRaw(this.project, SpecadorConstants.getMessage(SpecadorConstants.generationTime, SpecadorLanguageKind.VLOG.getName(), StopWatch.formatTime(this.getLanguageElapsedTime(SpecadorLanguageKind.VLOG))));
            }
            if (this.model.hasVhdlNature()) {
                ProgressPrinter.INSTANCE.printProgressRaw(this.project, SpecadorConstants.getMessage(SpecadorConstants.generationTime, SpecadorLanguageKind.VHDL.getName(), StopWatch.formatTime(this.getLanguageElapsedTime(SpecadorLanguageKind.VHDL))));
            }
            if (this.model.hasEdtNature()) {
                ProgressPrinter.INSTANCE.printProgressRaw(this.project, SpecadorConstants.getMessage(SpecadorConstants.generationTime, SpecadorLanguageKind.E.getName(), StopWatch.formatTime(this.getLanguageElapsedTime(SpecadorLanguageKind.E))));
            }
            if (this.useMakefile) {
                ProgressPrinter.INSTANCE.printProgressRaw(this.project, SpecadorConstants.getMessage(SpecadorConstants.generationTime, "Sphinx", StopWatch.formatTime(elapsedSphinxTime)));
            }
            ProgressPrinter.INSTANCE.printProgressRaw(this.project, "*** Total generation time [" + StopWatch.formatTime(elapsedTime) + "] ***");
        }
        this.eclipseMonitor.done();
    }

    public void setTaskName(String name) {
        this.eclipseMonitor.setTaskName(name);
    }

    public void setCanceled(boolean value) {
        this.eclipseMonitor.setCanceled(value);
    }

    public boolean isCanceled() {
        return this.eclipseMonitor.isCanceled() || MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState());
    }

    public void internalWorked(double work) {
        this.eclipseMonitor.internalWorked(work);
    }

    private String startTask(String name) {
        this.time = System.nanoTime();
        return String.valueOf(name) + "...";
    }

    public void overwriteDuration(long duration) {
        this.overwrittenDuration = duration;
    }

    private String endTask() {
        if (this.time == -1L) {
            return "";
        }
        long duration = (this.overwrittenDuration > 0L ? this.overwrittenDuration : System.nanoTime() - this.time) / 1000000L;
        this.time = -1L;
        this.overwrittenDuration = -1L;
        return this.createDurationMessage(duration);
    }

    private String createDurationMessage(long duration) {
        StringBuilder sb = new StringBuilder();
        if (this.beginTaskTotalWork != 0) {
            int percent = this.workDone * 100 / this.beginTaskTotalWork;
            percent = percent > 100 ? 100 : percent;
            sb.append('[').append(duration).append(" ms]").append("[").append(percent).append("%]");
        } else {
            sb.append('[').append(duration).append(" ms]");
        }
        return sb.toString();
    }

    public void setExitCodeValue(SpecadorExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public SpecadorExitCode getExitCodeValue() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.setExitCodeValue(SpecadorExitCode.fromId(exitCode));
    }

    @Override
    public int getExitCode() {
        return this.exitCode.getId();
    }

    public static enum SpecadorLanguageKind {
        VLOG("Verilog"),
        VHDL("VHDL"),
        E("eLanguage"),
        MISC("Misc");

        private String name;
        private long beginLanguageTime;
        private long endLanguageTime;

        private SpecadorLanguageKind(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void beginLanguage() {
            this.beginLanguageTime = System.currentTimeMillis();
        }

        private void endLanguage() {
            this.endLanguageTime = System.currentTimeMillis();
        }

        private long getLanguageElapsedTime() {
            return this.endLanguageTime - this.beginLanguageTime;
        }
    }
}

