/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.api.annotations;

import de.cau.cs.kieler.kiml.options.Direction;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.specador.api.annotations.PreferenceKind;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum PreferenceTag {
    DUMMY_GENERAL_OPTIONS("", "", PreferenceKind.BOTH, "GENERAL OPTIONS"),
    DUMMY_LINK_PRE_GENERATED("", "", PreferenceKind.BOTH, "CROSS-LINK WITH PRE-GENERATED DOCUMENTATION"),
    OUTPUT_FORMAT("output-format", "HTML", PreferenceKind.BOTH, "Generated output format (html, pdf). Default value: html."),
    LOCATION("location", "", PreferenceKind.BOTH, "Location where documentation will be generated. Relative paths are solved as relative to project directory."),
    OUTPUT_FOLDER_NAME("output-folder-name", "specador_docs", PreferenceKind.BOTH, "Set the output folder name. Default name is specador_docs."),
    TITLE("title", "API Specification", PreferenceKind.BOTH, "Set the documentation title."),
    AUTHOR("author", "", PreferenceKind.BOTH, "Set the author."),
    COPYRIGHT("copyright", "", PreferenceKind.BOTH, "Set the copyright message."),
    VERSION("version", "", PreferenceKind.BATCH, "Set the version of the documentation."),
    OVERVIEW_FILE("overview-file", "README.txt", PreferenceKind.BOTH, "The content of the overview file will be embedded in the first page. Relative paths are solved as relative to the current directory.", true),
    CUSTOM_INDEX_FILE("custom-toc", "", PreferenceKind.BOTH, "Provide the path to a reStructuredText or Markdown file, containing the description for a custom Table of Contents menu."),
    ATTACH_PATH("attach-path", "", PreferenceKind.BOTH, "You can specify one or more directory paths to be included in the exported documentation."),
    FILTER_PATH("filter-path", "", PreferenceKind.BOTH, "You can specify one or more file or directory paths."),
    INCLUDE_PATH("include-path", "", PreferenceKind.BOTH, "Only API defined under the specified paths will be included."),
    ENHANCE_COMMENTS("enhance-comments", "true", PreferenceKind.BOTH, "Beautify comments: start sentences with capital letter, append dot after sentences, bfm -> BFM, dut -> DUT etc.", true),
    CLEAN_LOCATION("clean-location", "true", PreferenceKind.BOTH, "Delete all files in the destination directory before generating documentation."),
    OPEN_IN_BROWSER("open-in-browser", "true", PreferenceKind.BOTH, "When running in GUI mode, choose whether to open or not the generated documentation in browser."),
    JUST_PROJECT_FILES("just-project-files", "false", PreferenceKind.GUI, "Generate documentation only for files physically located under project root. Relevant for GUI mode only.", true),
    SHOW_EXTERAL_DOC_REFS("show-external-doc-refs-in-navbar", "true", PreferenceKind.BOTH, "Add entries in the main menu with links to the external documentation.", true),
    PUBLIC_ONLY("public-only", "true", PreferenceKind.BOTH, "Generate documentation only for public API."),
    CREATED_BY_USER_WATERMARK("created-by-user-watermark", "true", PreferenceKind.BOTH, "Add \"Created by <username> ...\" watermark.", true),
    FILTER_STRING("filter-string", " ", PreferenceKind.BOTH, "API matching the below filters will not be included in the generated documentation. Default: none. You can specify a comma-separated list of name patterns. Patterns may contain: * = any string, ? = any character."),
    FILTER_COMMENTS("filter-comments", "", PreferenceKind.BOTH, "Inline or above comments containing one of the keywords from this list (comma separated list) will not be included. Change the strategy attribute to 'line' to skip only the lines that contain one of the keywords."),
    FILTER_COMMENTS_START_TAG("filter-comments-start-tag", "", PreferenceKind.BOTH, "Collect comments content after the specified tag."),
    FILTER_COMMENTS_END_TAG("filter-comments-end-tag", "", PreferenceKind.BOTH, "Collect comments content until the specified tag."),
    DOC_FORMATTING_TYPE("doc-formatting-type", DVTComment.CommentFormat.OLD_VERBATIM.getSpecadorXMLPreferenceName(), PreferenceKind.BOTH, "Syntax for comments formatting: reStructuredText, markdown, javadoc, naturaldocs, auto or noformat."),
    USER_DEFINED_HTML("user-defined-html", " ", PreferenceKind.BOTH, "The user defined navigation menu (HTML or XML format) will be embedded in the main menu. Relative paths are solved as relative to the current directory. Default: none.", true),
    CUSTOM_CSS_FILE("custom-css-file", " ", PreferenceKind.BOTH, "Add a custom CSS file to the documentation."),
    CUSTOM_JS_FILE("custom-js-file", " ", PreferenceKind.BOTH, "Add a custom JavaScript file to the documentation."),
    EXTERNAL_DOC_PATH("external-doc-path", "", PreferenceKind.BOTH, "Link to the elements for which documentation is already generated in the directories specified below, instead of re-generating their HTML pages.", true),
    PROJECT_NATURE("project-nature", "", PreferenceKind.BOTH, "", true),
    UML_CLASS_INHERITANCE_DIAGRAM("export-uml-inheritance-diagram", "false", PreferenceKind.BOTH, "Generate UML inheritance diagram for each class."),
    UVM_TEST_DIAGRAM("export-uvm-test-diagram", "true", PreferenceKind.BOTH, "Generate UVM Component diagrams for each test."),
    UVM_COMPONENTS_DIAGRAM_DEPTH("uvm-components-diagram-depth", "25", PreferenceKind.BOTH, "Set the UVM Components diagram depth."),
    UML_PACKAGE_INHERITANCE_DIAGRAM("export-uml-package-inheritance-diagram", "false", PreferenceKind.BOTH, "Generate UML inheritance diagram for each package.", true),
    UML_COLLABORATION_DIAGRAM("export-uml-collaboration-diagram", "false", PreferenceKind.BOTH, "Generate UML collaboration diagram for each class, struct, or unit."),
    UML_DIRECT_ASSOCIATIONS_DIAGRAM("export-uml-direct-associations-diagram", "false", PreferenceKind.BOTH, "Generate UML direct associations diagram for each class, struct, or unit.", true),
    ORTHOGONAL_CLASS_DIAGRAMS("orthogonal-class-diagrams", "false", PreferenceKind.BOTH, "Use orthogonal edge routing for class diagrams."),
    BLOCK_DIAGRAM("export-design-block-diagram", "false", PreferenceKind.BOTH, "Generate design block diagram for each module, entity."),
    SCHEMATIC_DIAGRAM("export-design-schematic-diagram", "false", PreferenceKind.BOTH, "Generate design schematic diagram for each module, entity."),
    DESIGN_DIAGRAM_FILTERS("design-diagram-filters", "", PreferenceKind.BOTH, "\n\t\tHighlight/filter ports, signals or blocks of design diagrams, using regular expressions and colors. A filter is defined using filter rules (one per line).\n\t\tThe general form of a filter rule is:\n\t\t\tcommand element_kinds matching regex [using color_name_or_code]\n\n\t\t- command: hide, show, or color\n\t\t- element_kinds is a comma-separated list of kinds (instances, types, ports, port types and transaction types)\n\t\t- regex is a regular expression that matches the relevant diagram element labels\n\t\t- color_name_or_code is a color specified by name, 6-or-3-digit hexadecimal code, comma-separated decimal RGB code or the keyword random\n\t"),
    SUBINSTANCES_DIAGRAM("export-design-subinstances-diagram", "false", PreferenceKind.BOTH, "Generate design schematic diagram without logic gates for each module/architecture."),
    BITFIELD_DIAGRAM("export-bitfield-diagram", "false", PreferenceKind.BOTH, "Generate bitfield diagram for each UVM register."),
    FSM_DIAGRAM("export-fsm-diagrams", "false", PreferenceKind.BOTH, "Generate finite-state machine diagrams for all state variables found in the module, entity."),
    FSM_DIAGRAM_DIRECTION("fsm-diagram-direction", DVTStringUtil.toNiceTitleCase(Direction.DOWN.toString()), PreferenceKind.BOTH, "Direction for the FSM Diagrams: Up, Down, Left or Right"),
    FSM_PLACEMENT_STRATEGY("fsm-placement-strategy", PrefConst.FSM_NODE_PLACEMENT_STRATEGY_VALUES[0][0], PreferenceKind.BOTH, "Placement strategy for FSM Diagrams: Brandes-Koepf or Network Simplex"),
    FSM_ENFORCE_EDGE_PORT_SIDE("fsm-enforce-edge-port-side", DVTStringUtil.toNiceTitleCase(FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES_EXCEPT_INITIAL.toString()), PreferenceKind.BOTH, "Enforce the in/out connections between states: None, All States or All States Except Initial"),
    FSM_INITIAL_STATE_POSITION("fsm-initial-state-position", PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_VALUES[1][0], PreferenceKind.BOTH, "Position for initial state in FSM Diagram: Free, First or Last"),
    FSM_SHOW_DEFAULT_STATE("fsm-show-default-state", "true", PreferenceKind.BOTH, "Show default state in FSM Diagrams"),
    FSM_SHOW_LOOPBACK_EDGES("fsm-show-loopback-edges", "false", PreferenceKind.BOTH, "Show loopback edges in FSM Diagrams"),
    FSM_FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS("fsm-filter-common-expressions-in-conditions", "false", PreferenceKind.BOTH, "Filter condition fragments occurring in every transition "),
    FLOW_DIAGRAM("export-design-flow-diagram", "false", PreferenceKind.BOTH, "Generate design flow diagram for each module, entity."),
    MAX_NOF_ELABORATED_INSTANCES("max-nof-elaborated-instances", "50", PreferenceKind.BOTH, ""),
    INSTANCE_PARAMETERS("include-design-parameters", "true", PreferenceKind.BOTH, "Include design parameters in the instances and submodules hierarchies."),
    EXPORT_UNNAMED_ALWAYS_BLOCKS("export-unnamed-always-blocks", "true", PreferenceKind.BOTH, "Generate documentation for unnamed always blocks/processes. Default: true."),
    EXPORT_SOURCE_CODE("export-source-code", "false", PreferenceKind.BOTH, "Export source code for documented elements."),
    ORDER_PORTS("order-ports", "false", PreferenceKind.BOTH, "Order ports alphabetically.", true),
    ORDER_VARIABLES("order-variables", "false", PreferenceKind.BOTH, "Order variables alphabetically.", true),
    DUMMY_SV_SPECIFIC("", "", PreferenceKind.BOTH, "SYSTEMVERILOG SPECIFIC"),
    EXPORT_VLOG_LIBRARIES("export-vlog-libraries", "true", PreferenceKind.BOTH, "Generate libraries documentation. You can select the specific libraries you want to document using export-vlog-library tag. For all libraries set export-vlog-libraries to true."),
    VLOG_LIBRARY("export-vlog-library", "", PreferenceKind.BOTH, "Generate specific library documentation."),
    VLOG_PACKAGE("export-vlog-package", "", PreferenceKind.BOTH, "Generate specific package documentation."),
    EXPORT_VLOG_PACKAGES("export-vlog-packages", "true", PreferenceKind.BOTH, "Generate packages documentation. You can choose only specific packages using export-vlog-package tag."),
    EXPORT_VLOG_PACKAGES_VARIABLES("export-vlog-packages-variables", "false", PreferenceKind.BOTH, "Export variables declared inside packages."),
    EXPORT_VLOG_GLOBAL_SCOPE("export-vlog-global-scope", "true", PreferenceKind.BOTH, "Generate elements in the global scope (typedefs, classes, functions, tasks etc.).", true),
    EXPORT_VLOG_MODULES("export-vlog-modules", "true", PreferenceKind.BOTH, "Generate modules documentation."),
    EXPORT_VLOG_MODULES_VARIABLES("export-vlog-modules-variables", "false", PreferenceKind.BOTH, "Export variables declared inside modules."),
    EXPORT_VLOG_INTERFACES("export-vlog-interfaces", "true", PreferenceKind.BOTH, "Generate interfaces documentation."),
    EXPORT_VLOG_PROGRAMS("export-vlog-programs", "true", PreferenceKind.BOTH, "Generate programs documentation.", true),
    EXPORT_VLOG_MACROS("export-vlog-macros", "true", PreferenceKind.BOTH, "Generate macros documentation."),
    EXPORT_VLOG_IFNDEF_GUARDS("export-vlog-ifndef-guards", "false", PreferenceKind.BOTH, "Generate ifndef guards documentation. Default: false."),
    EXPORT_VLOG_CONTROL_DEFINES("export-vlog-control-defines", "true", PreferenceKind.BOTH, "Generate control defines documentation. Default: true."),
    EXPORT_VLOG_ASSERTIONS("export-vlog-assertions", "true", PreferenceKind.BOTH, "Generate assertions documentation."),
    EXPORT_VLOG_COVERGROUPS("export-vlog-covergroups", "true", PreferenceKind.BOTH, "Generate covergroups documentation."),
    EXPORT_VLOG_INNER_CLASSES("export-vlog-inner-classes", "true", PreferenceKind.BOTH, "Generate inner classes documentation."),
    EXPORT_VLOG_LOCALPARAMS("export-vlog-localparams", "true", PreferenceKind.BOTH, "Generate local parameters documentation."),
    HIDE_VLOG_INTERFACE_SIGNALS("hide-vlog-interface-signals", "false", PreferenceKind.BOTH, "Generate interface signals documentation.", true),
    DUMMY_VLOG_FILTER_CLASS_DIAGRAMS("", "", PreferenceKind.BOTH, "Filter UVM classes from UML diagrams. Can be used multiple times with one of the strings below per invocation.", true),
    VLOG_FILTER_CLASS_DIAGRAMS("vlog-filter-class-diagrams", "", PreferenceKind.BOTH, "The value \"__UVM\" excludes all UVM classes, while the values \"__KEEP_FIRST_PARENT\", \"__KEEP_FIRST_ASSOCIATION\", \"__KEEP_REGS\" and \"__COLLABORATION_ONLY_COMPONENTS\" allow you to add some of them back."),
    VLOG_BRIEF_COMMENTS("vlog-brief-comments", "false", PreferenceKind.BOTH, "", true),
    VLOG_FILTER_INDEX("vlog-filter-index", "", PreferenceKind.BOTH, "", true),
    EXPAND_INCLUDE_DIRECTIVES("expand-include-directives", "false", PreferenceKind.BOTH, "Expand `include directives in the body of a module.", true),
    EXPORT_VLOG_CLASS_INHERITED_MEMBERS("export-vlog-class-inherited-members", "false", PreferenceKind.BATCH, "Generate class inherited variables, functions and tasks documentation."),
    DUMMY_VHDL_SPECIFIC("", "", PreferenceKind.BOTH, "VHDL SPECIFIC"),
    VHDL_LIBRARY("export-vhdl-library", "", PreferenceKind.BOTH, "Generate specific library documentation."),
    EXPORT_VHDL_LIBRARIES("export-vhdl-libraries", "true", PreferenceKind.BOTH, "Generate libraries documentation. You can select the specific libraries you want to document using export-vhdl-library tag. For all libraries set export-vhdl-libraries to true."),
    EXPORT_VHDL_ENTITIES("export-vhdl-entities", "true", PreferenceKind.BOTH, "Generate entities documentation."),
    EXPORT_VHDL_PACKAGES("export-vhdl-packages", "true", PreferenceKind.BOTH, "Generate packages documentation."),
    VHDL_PACKAGE("export-vhdl-package", "", PreferenceKind.BOTH, "Generate specific package documentation."),
    DUMMY_EDT_SPECIFIC("", "", PreferenceKind.BOTH, "E LANGUAGE SPECIFIC"),
    EDT_PACKAGE("export-e-package", "", PreferenceKind.BOTH, "Generate specific package documentation."),
    EXPORT_EDT_PACKAGES("export-e-packages", "true", PreferenceKind.BOTH, "Generate packages documentation. You can select the specific packages you want to document using export-e-package tag. For all packages set export-e-packages to true."),
    EXPORT_EDT_MACROS("export-e-macro", "true", PreferenceKind.BOTH, "Generate macro documentation."),
    EXPORT_EDT_COVERGROUPS("export-e-covergroups", "true", PreferenceKind.BOTH, "Generate covergroups documentation."),
    EXPORT_EDT_CHECKS("export-e-checks", "true", PreferenceKind.BOTH, "Generate checks documentation."),
    EXPORT_EDT_TESTS("export-e-tests", "true", PreferenceKind.BOTH, "Generate tests documentation.");

    private final String tag;
    private final String defaultValue;
    private final PreferenceKind prefKind;
    private final String description;
    private boolean isDeprecated;
    private boolean isReadOnly;

    private PreferenceTag(String tag, String defaultValue, PreferenceKind prefKind, String description) {
        this.tag = tag;
        this.defaultValue = defaultValue;
        this.prefKind = prefKind;
        this.description = description;
    }

    private PreferenceTag(String tag, String defaultValue, PreferenceKind prefKind, String description, boolean isDeprecated) {
        this(tag, defaultValue, prefKind, description);
        this.isDeprecated = isDeprecated;
    }

    public String getTagName() {
        return this.tag;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public PreferenceKind getPrefKind() {
        return this.prefKind;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEmpty() {
        return this.tag.isEmpty();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

