/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerAdapter;
import ro.amiq.dvt.specador.templates.SpecadorCancelException;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.specador.templates.SpecadorGenerator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public enum FreeMarkerFileGenerator {
    INSTANCE;

    private static final Configuration FREEMARKER_CONFIGURATION;

    static {
        FREEMARKER_CONFIGURATION = new Configuration(Configuration.VERSION_2_3_26);
        FREEMARKER_CONFIGURATION.setObjectWrapper((ObjectWrapper)new FreeMarkerAdapter(Configuration.VERSION_2_3_26));
        FREEMARKER_CONFIGURATION.setClassForTemplateLoading(SpecadorGenerator.class, "");
    }

    public static void generateFile(SpecadorModel model, String templateName, File outputFile, SimpleHash dataModel, String languageKind, IProgressMonitor progressMonitor) throws SpecadorCancelException {
        FreeMarkerFileGenerator.generateFile(model, templateName, outputFile, dataModel, languageKind, progressMonitor, 0);
    }

    public static void generateFile(SpecadorModel model, String templateName, File outputFile, SimpleHash dataModel, String languageKind, IProgressMonitor progressMonitor, int work) throws SpecadorCancelException {
        if (progressMonitor.isCanceled()) {
            throw new SpecadorCancelException("Documentation generation cancelled!");
        }
        if (!SpecadorManager.checkLicense(model)) {
            throw new SpecadorCancelException("Documentation generation cancelled!");
        }
        if (work != -1) {
            progressMonitor.subTask(SpecadorConstants.getMessage(SpecadorConstants.generateFileMessage, languageKind, outputFile.getName()));
        }
        StringWriter writer = new StringWriter();
        try {
            Template template = FREEMARKER_CONFIGURATION.getTemplate(templateName);
            template.process((Object)dataModel, (Writer)writer);
            FreeMarkerFileGenerator.writeFileContent(model, outputFile, writer.toString(), progressMonitor, work);
        }
        catch (TemplateException | IOException e) {
            DVTLogger.INSTANCE.logError("Error while generating file " + outputFile.getName());
            SpecadorManager.INSTANCE.logError(model.getProject(), (Exception)e);
        }
    }

    public static SimpleHash createDataModel() {
        return new SimpleHash(FREEMARKER_CONFIGURATION.getObjectWrapper());
    }

    public static boolean writeFileContent(SpecadorModel model, File file, String content, IProgressMonitor progressMonitor, int work) {
        try {
            if (!FreeMarkerFileGenerator.readOriginalFileContent(model, file).equals(content)) {
                FileUtils.write((File)file, (CharSequence)content);
            }
            return true;
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
            return false;
        }
        finally {
            if (progressMonitor != null && work != -1) {
                ((SpecadorProgressMonitor)progressMonitor).worked(work);
            }
        }
    }

    private static String readOriginalFileContent(SpecadorModel model, File file) {
        try {
            if (file.exists()) {
                return FileUtils.readFileToString((File)file);
            }
            return "";
        }
        catch (Exception e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
            return "";
        }
    }
}

