/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface IDesignElementWrapper
extends IFreeMarkerWrapper {
    public static final Pattern GENERATE_BLOCK_NAME_PATTERN = Pattern.compile("[\\[\\(].*[\\]\\)]");

    public List<ELInstance> getInstancesFromMemory();

    public Map<String, List<IDesignInstanceWrapper>> getInstances(List<IRfDesignElement> var1);

    default public boolean isValidInstance(IRfNamedElement namedElement) {
        return namedElement instanceof IRfDesignElement && !DesignUtils.isBlock(namedElement) && !(namedElement instanceof ErrorDesignElement);
    }

    public IRfDesignElement getDesignElement();

    default public boolean hasSubInstances() {
        List<ELInstance> instancesFromMemory = this.getInstancesFromMemory();
        if (instancesFromMemory == null || instancesFromMemory.isEmpty()) {
            ArrayList<IRfInstanceElement> instances = new ArrayList<IRfInstanceElement>();
            DesignUtils.getInstancesIncludingGenerate(instances, this.getDesignElement(), false);
            return !instances.isEmpty();
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        IELMemory memory = elManager.getMemory();
        for (ELInstance instance : instancesFromMemory) {
            ElementPath hierarchyPath = instance.getHierarchyPath();
            Map<ElementPath, ELInstance> subInstances = memory.subtreeOf(hierarchyPath, false);
            if (subInstances == null || subInstances.isEmpty()) continue;
            for (Map.Entry<ElementPath, ELInstance> subInstanceEntry : subInstances.entrySet()) {
                ELInstance subInstance = subInstanceEntry.getValue();
                IRfNamedElement subInstanceBinding = subInstance.getBinding(false);
                if (DesignUtils.isBlock(subInstanceBinding)) continue;
                return true;
            }
        }
        return false;
    }

    default public Map<String, List<IDesignInstanceWrapper>> getSubInstances() {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.getModel().getProject());
        IELMemory memory = elManager.getMemory();
        LinkedHashMap<String, List<IDesignInstanceWrapper>> subModules = new LinkedHashMap<String, List<IDesignInstanceWrapper>>();
        for (ELInstance instance : this.getInstancesFromMemory()) {
            IDesignInstanceWrapper wrapper;
            String key;
            IRfNamedElement instanceModule;
            ElementPath hierarchyPath = instance.getHierarchyPath();
            Map<ElementPath, ELInstance> subInstances = memory.subtreeOf(hierarchyPath, false);
            if (subInstances == null || subInstances.isEmpty() || !((instanceModule = memory.bindingFor(hierarchyPath, false)) instanceof IRfDesignElement) || subModules.containsKey(key = String.valueOf((wrapper = LanguageContributor.get(instanceModule.getLanguageKind()).getInstance((IRfDesignElement)instanceModule, hierarchyPath, hierarchyPath.getName())).getName()) + wrapper.getInstanceParams())) continue;
            if (!subModules.containsKey("instance")) {
                subModules.put("instance", new LinkedList());
            }
            ((List)subModules.get("instance")).add(wrapper);
            List subModulesPerInstance = subModules.computeIfAbsent(key, k -> new LinkedList());
            int topHierarchyPathLength = hierarchyPath.length();
            for (Map.Entry<ElementPath, ELInstance> subInstanceEntry : subInstances.entrySet()) {
                if (subModulesPerInstance.size() >= this.getModel().getNoElaboratedInstances()) break;
                ELInstance subInstance = subInstanceEntry.getValue();
                ElementPath subInstanceHierarchyPath = subInstanceEntry.getKey();
                IRfNamedElement subInstanceBinding = subInstance.getBinding(false);
                if (!this.isValidInstance(subInstanceBinding)) continue;
                boolean hasEnclosingGenerate = DesignUtils.isBlock(subInstance.getDescription().getEnclosingScope());
                ISpecadorContributor contributor = LanguageContributor.get(subInstanceBinding.getLanguageKind());
                if (hasEnclosingGenerate) {
                    ElementPath upperPath = ELUtils.upperPathOfIgnoreGenerates(subInstanceHierarchyPath, memory);
                    if (upperPath.length() != topHierarchyPathLength) continue;
                    String subInstanceName = subInstanceHierarchyPath.toString().substring(hierarchyPath.toString().length() + 1);
                    String subInstanceNameProcessed = DVTStringUtil.replaceAll(GENERATE_BLOCK_NAME_PATTERN, subInstanceName, "");
                    if (((List)subModules.get(key)).stream().anyMatch(ins -> ins.getInstanceName().equals(subInstanceNameProcessed))) continue;
                    subModulesPerInstance.add(contributor.getInstance((IRfDesignElement)subInstanceBinding, subInstanceHierarchyPath, subInstanceNameProcessed));
                    continue;
                }
                if (subInstanceHierarchyPath.length() != topHierarchyPathLength + 1) continue;
                subModulesPerInstance.add(contributor.getInstance((IRfDesignElement)subInstanceBinding, subInstanceHierarchyPath, subInstanceHierarchyPath.getName()));
            }
            if (!subModulesPerInstance.isEmpty()) continue;
            subModules.remove(key);
            ((List)subModules.get("instance")).remove(wrapper);
        }
        if (subModules.get("instance") != null && ((List)subModules.get("instance")).isEmpty()) {
            subModules.remove("instance");
        }
        return subModules;
    }
}

