/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.comment.formatter.CommentWrapper;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public interface IFreeMarkerWrapper {
    public static final Pattern WAVEDROM_FORMAT_PATTERN = Pattern.compile("(?m)^\\s*([/]{2,}|[-]{2,}|[*]*)");
    public static final Pattern MULTI_LINE_COMMENT_STAR = Pattern.compile("(?m)^\\s*\\*");
    public static final Pattern UNDERSCORE_PATTERN = Pattern.compile("(?<!\\W|_|^)_(?!\\W|_|$)");
    public static final Pattern COMA_PATTERN = Pattern.compile("(?<!\\W),(?!\\W)");
    public static final Pattern ASIGN_PATTERN = Pattern.compile("(?<!\\W)=(?!\\W)");
    public static final Pattern REMOVE_UNPRINTABLE_CHARACTERS = Pattern.compile("[\\uFFF0-\\uFFFF]");
    public static final Pattern CODE_BLOCK_FOR_HTML = Pattern.compile("(?s)(<pre><code>)((?:(?!<\\/code><\\/pre>).)*)(<\\/code><\\/pre>)((?:(?!<pre><code>).)*)");
    public static final Pattern CODE_BLOCK_FOR_PDF = Pattern.compile("(?s)(```)((?:(?!```).)*)(```)((?:(?!```).)*)");
    public static final Pattern TITLE_PATTERN = Pattern.compile("(<h1>(.*)</h1>|^# (.*))");
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$comment$formatter$CommentWrapper$CommentElement;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$comment$formatter$CommentWrapper$CommentElement = IFreeMarkerWrapper.$SWITCH_TABLE$ro$amiq$dvt$comment$formatter$CommentWrapper$CommentElement();
    }

    public SpecadorModel getModel();

    public IRfNamedElement getNamedElement();

    default public String getName() {
        return this.getNamedElement().getName();
    }

    default public String getFormatedName() {
        return this.formatSpecialCharacters(this.getName());
    }

    default public int getOffset() {
        return this.getNamedElement().getOffset();
    }

    default public String getDeclarationLine() {
        if (this.getNamedElement() == null || this.getNamedElement().getDeclaration() == null) {
            return "-1";
        }
        return String.valueOf(this.getNamedElement().getDeclaration().getStartLine()).replace(",", "");
    }

    default public String getCommentLine() {
        return String.valueOf(Integer.parseInt(this.getDeclarationLine()) - 1);
    }

    default public String getDeclarationLocation() {
        if (this.getNamedElement().getDeclaration() == null || this.getNamedElement().getDeclaration().getDefFile() == null) {
            return "";
        }
        return ((IRfScopeElement)((Object)this.getNamedElement().getDeclaration().getDefFile())).getName();
    }

    default public String getLibraryName() {
        return "";
    }

    public String getKind();

    default public String getFullName() {
        return LanguageContributor.get(this.getNamedElement().getLanguageKind()).getFullNameLabel(this.getNamedElement());
    }

    default public String getID() {
        return SpecadorConstants.getMessage(SpecadorConstants.elementID, this.getKind(), this.getFullName());
    }

    default public String getInitialValue() {
        return "";
    }

    public CommentBlock getCommentBlock();

    public ICommentLinkResolver getLinker();

    default public List<SpecadorCommentWrapper> getComment() {
        return this.getComment(this.getCommentBlock());
    }

    default public String getClearedAboveComment() {
        CommentBlock commentBlock = this.getCommentBlock();
        if (commentBlock == null) {
            return null;
        }
        if (commentBlock.getRawUntrimmedAboveComment() == null) {
            return null;
        }
        return this.clearComment(commentBlock.getRawUntrimmedAboveComment(), commentBlock.getAboveCommentStyle());
    }

    default public String getClearedInlineComment() {
        CommentBlock commentBlock = this.getCommentBlock();
        if (commentBlock == null) {
            return null;
        }
        if (commentBlock.getRawUntrimmedInlineComment() == null) {
            return null;
        }
        return this.clearComment(commentBlock.getRawUntrimmedInlineComment(), commentBlock.getInlineCommentStyle());
    }

    default public List<SpecadorCommentWrapper> getComment(CommentBlock commentBlock) {
        if (commentBlock == null) {
            return Collections.emptyList();
        }
        StringBuilder comment = new StringBuilder();
        String inlineComment = commentBlock.getRawUntrimmedInlineComment();
        if (inlineComment != null && !inlineComment.isBlank()) {
            comment.append(this.clearComment(inlineComment, commentBlock.getInlineCommentStyle()));
            return this.splitComment(comment).stream().filter(cw -> !cw.getContent().trim().isEmpty()).collect(Collectors.toList());
        }
        String aboveComment = commentBlock.getRawUntrimmedAboveComment();
        if (aboveComment != null && !aboveComment.isBlank()) {
            comment.append(this.clearComment(aboveComment, commentBlock.getAboveCommentStyle()));
            return this.splitComment(comment, String.valueOf(commentBlock.getAboveCommentStartLine())).stream().filter(cw -> !cw.getContent().trim().isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    default public String clearComment(String comment, Comment.CommentStyle commentStyle) {
        String commentFiltersEndTag;
        String commentFiltersStartTag;
        if (commentStyle == Comment.CommentStyle.ML_KIND || commentStyle == Comment.CommentStyle.ML2_KIND) {
            comment = DVTStringUtil.replaceAll(MULTI_LINE_COMMENT_STAR, comment, "");
        }
        if (!(commentFiltersStartTag = this.getModel().getCommentFiltersStartTag()).isEmpty() && comment.contains(commentFiltersStartTag)) {
            comment = comment.substring(comment.indexOf(commentFiltersStartTag) + commentFiltersStartTag.length());
        }
        if (!(commentFiltersEndTag = this.getModel().getCommentFiltersEndTag()).isEmpty() && comment.contains(commentFiltersEndTag)) {
            comment = comment.substring(0, comment.indexOf(commentFiltersEndTag));
        }
        return this.filterComment(comment);
    }

    default public String filterComment(String comment) {
        if (comment.isEmpty()) {
            return comment;
        }
        SpecadorModel model = this.getModel();
        if (model.getCommentFilters().isEmpty()) {
            return comment;
        }
        if (SpecadorModel.CommentFilterStrategy.LINE.equals((Object)model.getFilterStrategy())) {
            ArrayList<String> splitComment = new ArrayList<String>(Arrays.asList(DVTStringUtil.NEW_LINE.split(comment)));
            Iterator<String> iterator = splitComment.iterator();
            block0: while (iterator.hasNext()) {
                String line = iterator.next().toLowerCase();
                if (line.isEmpty()) continue;
                for (String keyword : model.getCommentFilters()) {
                    if (!line.contains(keyword)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            return String.join((CharSequence)"\n", splitComment);
        }
        String commentLowerCase = comment.toLowerCase();
        for (String keyword : model.getCommentFilters()) {
            if (!commentLowerCase.contains(keyword)) continue;
            return "";
        }
        return comment;
    }

    default public List<SpecadorCommentWrapper> splitComment(StringBuilder comment) {
        return this.splitComment(comment, this.getDeclarationLine());
    }

    default public List<SpecadorCommentWrapper> splitComment(StringBuilder comment, String startLine) {
        SpecadorModel model = this.getModel();
        DVTComment.CommentFormat format = this.contentFormatter(comment.toString(), model);
        List<CommentWrapper> segments = CommentFormatter.INSTANCE.format(comment.toString(), this.getNamedElement(), this.getLinker(), format == null || DVTComment.CommentFormat.RST.equals((Object)format) ? DVTComment.CommentFormat.OLD_VERBATIM : format, !model.isForPDF(), this.getFunctionArguments());
        int counter = 1;
        LinkedList<SpecadorCommentWrapper> result = new LinkedList<SpecadorCommentWrapper>();
        for (CommentWrapper segment : segments) {
            switch (segment.getType()) {
                case WAVEDROM: {
                    File wavedromFile = this.generateWavedrom(segment.getContent(), counter);
                    Path relativePath = Paths.get(this.getFullPath(), new String[0]).relativize(Paths.get(wavedromFile.getAbsolutePath(), new String[0]));
                    result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.WAVEDROM, relativePath.toString().replace("\\", "\\\\"), startLine));
                    ++counter;
                    break;
                }
                case CUSTOM_DIAGRAM: {
                    result.add(this.generateCustomDiagram(segment.getContent()));
                    break;
                }
                case TEXT: {
                    if (format == null || format.equals((Object)DVTComment.CommentFormat.OLD_VERBATIM)) {
                        result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.NONE, this.removeInvalidCharacters(segment.getContent()), DVTComment.CommentFormat.OLD_VERBATIM, segment.getRawContent(), startLine));
                        break;
                    }
                    if (segments.indexOf(segment) == 0 && format.equals((Object)DVTComment.CommentFormat.MARKDOWN) && model.isForPDF()) {
                        result.addAll(this.getCommentTitle(segment.getContent()));
                        break;
                    }
                    if (format.equals((Object)DVTComment.CommentFormat.RST)) {
                        String content = DVTStringUtil.unindentLinesToLevel(segment.getContent(), System.lineSeparator());
                        result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.RST, content, DVTComment.CommentFormat.RST, segment.getRawContent(), startLine));
                        break;
                    }
                    if (format.equals((Object)DVTComment.CommentFormat.NATURAL_DOCS)) {
                        result.addAll(this.codeBlocksComment(segment.getContent(), model.isForPDF()));
                        break;
                    }
                    result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, model.isForPDF() ? this.beautifyPdfComment(segment.getContent()) : segment.getContent(), format, segment.getRawContent(), startLine));
                }
            }
        }
        return result;
    }

    default public File generateWavedrom(String svg, int counter) {
        File location = new File(this.getModel().getLocation(), "source/diagrams");
        location.mkdirs();
        File wavedromFile = new File(location, SpecadorConstants.getMessage(SpecadorConstants.diagramFileName, "wavedrom" + counter, this.getName()));
        try {
            FileUtils.write((File)wavedromFile, (CharSequence)svg);
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(this.getModel().getProject(), e);
        }
        return wavedromFile;
    }

    default public SpecadorCommentWrapper generateCustomDiagram(String diagramPath) {
        File diagramLocation = new File(diagramPath);
        if (!diagramLocation.exists()) {
            return new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, diagramPath, DVTComment.CommentFormat.OLD_VERBATIM, this.getDeclarationLine());
        }
        Path relativePath = Paths.get(this.getFullPath(), new String[0]).relativize(Paths.get(diagramLocation.getAbsolutePath(), new String[0]));
        return new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.CUSTOM_DIAGRAM, relativePath.toString().replace("\\", "\\\\"), this.getCommentLine());
    }

    default public List<String> getFunctionArguments() {
        return Collections.emptyList();
    }

    default public DVTComment.CommentFormat contentFormatter(String comment, SpecadorModel model) {
        DVTComment.CommentFormat name = model.getDocFormattingType();
        if (name.equals((Object)DVTComment.CommentFormat.OLD_VERBATIM)) {
            return null;
        }
        if (!name.equals((Object)DVTComment.CommentFormat.AUTO)) {
            return name;
        }
        return CommentUtils.getInstance().autodetectContentFormatter(comment);
    }

    default public List<SpecadorCommentWrapper> getCommentTitle(String comment) {
        LinkedList<SpecadorCommentWrapper> result = new LinkedList<SpecadorCommentWrapper>();
        Matcher match = TITLE_PATTERN.matcher(comment.trim());
        if (match.find()) {
            result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TITLE, match.group(2) == null ? match.group(3) : match.group(2), DVTComment.CommentFormat.MARKDOWN, this.getDeclarationLine()));
            comment = match.replaceFirst("");
        }
        result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, this.beautifyPdfComment(comment), DVTComment.CommentFormat.MARKDOWN, this.getDeclarationLine()));
        return result;
    }

    default public List<SpecadorCommentWrapper> codeBlocksComment(String comment, boolean isForPDF) {
        Pattern codeBlockPattern = isForPDF ? CODE_BLOCK_FOR_PDF : CODE_BLOCK_FOR_HTML;
        Matcher matcher = codeBlockPattern.matcher(comment);
        LinkedList<SpecadorCommentWrapper> result = new LinkedList<SpecadorCommentWrapper>();
        int lastMatchIndex = 0;
        while (matcher.find()) {
            String code = matcher.group(2);
            String next = matcher.group(4);
            if (code == null || code.isEmpty()) continue;
            String prefix = comment.substring(lastMatchIndex, matcher.start(1));
            result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, isForPDF ? this.beautifyPdfComment(prefix) : prefix, DVTComment.CommentFormat.NATURAL_DOCS, this.getDeclarationLine()));
            result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.CODE_BLOCK, code, this.getDeclarationLine()));
            lastMatchIndex = matcher.end();
            if ((next == null || next.trim().isEmpty()) && lastMatchIndex != comment.length()) continue;
            result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, isForPDF ? this.beautifyPdfComment(next) : next, DVTComment.CommentFormat.NATURAL_DOCS, this.getDeclarationLine()));
        }
        result.add(new SpecadorCommentWrapper(SpecadorCommentWrapper.CommentOutputType.TEXT, isForPDF ? this.beautifyPdfComment(comment.substring(lastMatchIndex)) : comment.substring(lastMatchIndex), DVTComment.CommentFormat.NATURAL_DOCS, this.getDeclarationLine()));
        return result;
    }

    default public String removeInvalidCharacters(String comment) {
        return DVTStringUtil.replaceAll(REMOVE_UNPRINTABLE_CHARACTERS, comment, "");
    }

    default public String beautifyPdfComment(String comment) {
        comment = DVTStringUtil.replaceAll(UNDERSCORE_PATTERN, comment, "\\\\_");
        comment = DVTStringUtil.replaceAll(COMA_PATTERN, comment, ", ");
        comment = DVTStringUtil.replaceAll(ASIGN_PATTERN, comment, " = ");
        comment = comment.replace("&lt;", "<").replace("&gt;", ">").replace("#", "");
        comment = this.removeInvalidCharacters(comment);
        return comment;
    }

    public String createFileReferenceContent(File var1);

    default public String readSourceCodeFileForExporting(File file) {
        StringBuilder result = new StringBuilder();
        if (!file.exists()) {
            return result.toString();
        }
        BufferedReader reader = null;
        try {
            try {
                int c;
                reader = new BufferedReader(new FileReader(file));
                while ((c = reader.read()) != -1) {
                    result.append((char)c);
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DVTUtilsCommon.INSTANCE.closeClosable(reader);
                return "";
            }
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(reader);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(reader);
        return result.toString();
    }

    default public String getDocumentationName() {
        return this.getName();
    }

    default public String getDocumentationLocation(File codeLocation) {
        String documentationPath = SpecadorConstants.getMessage(SpecadorConstants.documentationLocation, this.getFullPath(), this.getDocumentationName());
        return codeLocation.toPath().relativize(Paths.get(documentationPath, new String[0])).toString();
    }

    default public void addLinks(List<String> segments, List<String> insertions, File codeLocation) {
        this.addLinks(segments, insertions, codeLocation, null);
    }

    default public void addLinks(List<String> segments, List<String> insertions, File codeLocation, IRfFileDef file) {
    }

    default public void addLinksToPage(List<String> segments, List<String> insertions, List<? extends IFreeMarkerWrapper> elements, File codeLocation) {
        this.addLinksToPage(segments, insertions, elements, codeLocation, null);
    }

    default public void addLinksToPage(List<String> segments, List<String> insertions, List<? extends IFreeMarkerWrapper> elements, File codeLocation, IRfFileDef file) {
        for (IFreeMarkerWrapper iFreeMarkerWrapper : elements) {
            if (LanguageContributor.get(iFreeMarkerWrapper.getNamedElement().getLanguageKind()).shouldFilter(iFreeMarkerWrapper.getNamedElement())) continue;
            int currentLength = 0;
            int startOffset = iFreeMarkerWrapper.getOffset();
            for (String segment : segments) {
                if (startOffset - currentLength > segment.length()) {
                    currentLength += segment.length();
                    continue;
                }
                int index = segments.indexOf(segment);
                segments.remove(index);
                segments.add(index, segment.substring(0, startOffset - currentLength));
                segments.add(index + 1, segment.substring(startOffset - currentLength));
                insertions.add(index, SpecadorConstants.getMessage(SpecadorConstants.linkToCode, iFreeMarkerWrapper.getDocumentationLocation(codeLocation)));
                break;
            }
            if (file == null) {
                iFreeMarkerWrapper.addLinks(segments, insertions, codeLocation);
                continue;
            }
            iFreeMarkerWrapper.addLinks(segments, insertions, codeLocation, file);
        }
    }

    default public IRfFileDef getFileDef() {
        if (this.getNamedElement() == null) {
            return null;
        }
        if (this.getNamedElement().getDeclaration() == null) {
            return null;
        }
        return this.getNamedElement().getDeclaration().getDefFile();
    }

    default public void addLinksToAPI(List<String> segments, List<String> insertions, List<? extends IFreeMarkerWrapper> elements, File codeLocation) {
        this.addLinksToAPI(segments, insertions, elements, codeLocation, null);
    }

    default public void addLinksToAPI(List<String> segments, List<String> insertions, List<? extends IFreeMarkerWrapper> elements, File codeLocation, IRfFileDef file) {
        block0: for (IFreeMarkerWrapper iFreeMarkerWrapper : elements) {
            if (file != null && !file.equals(iFreeMarkerWrapper.getFileDef()) || LanguageContributor.get(iFreeMarkerWrapper.getNamedElement().getLanguageKind()).shouldFilter(iFreeMarkerWrapper.getNamedElement())) continue;
            int currentLength = 0;
            int startOffset = iFreeMarkerWrapper.getOffset();
            if (startOffset < 0) continue;
            for (String segment : segments) {
                if (startOffset - currentLength > segment.length()) {
                    currentLength += segment.length();
                    continue;
                }
                int index = segments.indexOf(segment);
                segments.remove(index);
                segments.add(index, segment.substring(0, startOffset - currentLength));
                segments.add(index + 1, segment.substring(startOffset - currentLength));
                insertions.add(index, SpecadorConstants.getMessage(SpecadorConstants.linkToCodeWithAnchor, this.getDocumentationLocation(codeLocation), iFreeMarkerWrapper.getID()));
                continue block0;
            }
        }
    }

    default public String formatSpecialCharacters(String str) {
        if (!this.getModel().isForPDF()) {
            return str.replace("_", "\\_").replace("*", "\\*");
        }
        return str.replace("\\", "\\\\").replace("_", "\\_").replace("*", "\\*").replace("`", "\\`").replace("^", "\\^").replace("$", "\\$").replace("&", "\\&").replace("%", "\\%").replace("#", "\\#").replace("{", "\\{").replace("}", "\\}").replace("~", "\\~");
    }

    default public boolean hasCode() {
        return this.getModel().getExportSourceCode() && !this.getNamedElement().hasNoDefs(false);
    }

    public String getLanguageKind();

    default public String getFullPath() {
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source" + File.separator;
    }
}

