/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.specador.templates.IAssertWrapper;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.specador.templates.ITestWrapper;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public interface ISpecadorContributor {
    public static final Pattern ML_COMMENT = Pattern.compile("(?m)^\\s*[*]*");

    default public List<IRfNamedElement> getVerificationTops(SpecadorModel model) {
        return Collections.emptyList();
    }

    public LanguageKind getLanguageKind();

    public SpecadorModel getModel();

    public void setModel(SpecadorModel var1);

    default public String getOutputLocation() {
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source";
    }

    default public List<String> getPackages(IProject project) {
        return Collections.emptyList();
    }

    default public List<String> getPackages(RfMixedLangProject rfMixedLangProject) {
        return Collections.emptyList();
    }

    default public List<IPackageWrapper> getPackages(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getDefinedControlDefines(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getUndefinedControlDefines(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getDefines(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getIfndefGuards(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public Map<String, List<IFreeMarkerWrapper>> getMacros(SpecadorModel model) {
        return Collections.emptyMap();
    }

    default public List<ILibraryWrapper> getLibraries(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<ILibraryWrapper> getLibraries(RfMixedLangProject project) {
        return Collections.emptyList();
    }

    default public List<ILibraryWrapper> getSelectedLibraries(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<ITestWrapper> getTests(IProject project) {
        return Collections.emptyList();
    }

    default public List<IAssertWrapper> getAssertions(IProject project) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getChecks(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public List<IFreeMarkerWrapper> getCovergroups(SpecadorModel model) {
        return Collections.emptyList();
    }

    default public String getDesignTopFile(IRfDesignElement top) {
        return "";
    }

    public String getHyperlink(IRfNamedElement var1);

    default public String getPackageName(IRfNamedElement element) {
        return "";
    }

    default public String getParserPath(IRfNamedElement namedElement) {
        if (namedElement.isPredefined() || namedElement.getDeclaration() == null) {
            return "";
        }
        IRfFileDef defFile = namedElement.getDeclaration().getDefFile();
        if (defFile == null || defFile.getParserPath() == null) {
            return "";
        }
        return defFile.getParserPath().path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public boolean isElementMatchingPathFilters(String parserPath, Collection<StringMatcher> filterMatchers) {
        try {
            if (filterMatchers == null) return false;
            if (filterMatchers.isEmpty()) {
                return false;
            }
            if (parserPath.isEmpty()) {
                return false;
            }
            File parserPathFile = new File(parserPath);
            String canonicalPath = parserPathFile.getCanonicalPath();
            if (canonicalPath.isEmpty()) {
                return false;
            }
            Iterator<StringMatcher> iterator = filterMatchers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                StringMatcher filterMatcher = iterator.next();
                if (filterMatcher == null) continue;
                if (canonicalPath.startsWith(filterMatcher.getPattern())) return true;
                if (parserPath.startsWith(filterMatcher.getPattern())) {
                    return true;
                }
                if (filterMatcher.match(canonicalPath)) return true;
                if (filterMatcher.match(parserPath)) break;
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    default public boolean isFilteredByPath(String parserPath) {
        if (this.getModel().getFilterPathsMatchers().isEmpty()) {
            return false;
        }
        return this.isElementMatchingPathFilters(parserPath, this.getModel().getFilterPathsMatchers());
    }

    default public boolean isElementIncluded(String parserPath) {
        if (this.getModel().getIncludePathsMatchers().isEmpty()) {
            return true;
        }
        return this.isElementMatchingPathFilters(parserPath, this.getModel().getIncludePathsMatchers());
    }

    public boolean isPublic(IRfNamedElement var1);

    public boolean isFilteredByName(IRfNamedElement var1);

    default public boolean shouldFilter(IRfNamedElement namedElement) {
        if (this.getModel() == null) {
            return namedElement.isPredefined();
        }
        if (this.getModel().isPublicOnlyAPI() && !this.isPublic(namedElement)) {
            return true;
        }
        if (namedElement.isPredefined()) {
            return true;
        }
        if (this.isFilteredByName(namedElement)) {
            return true;
        }
        if (this.getParserPath(namedElement).isEmpty()) {
            return false;
        }
        if (this.isFilteredByPath(this.getParserPath(namedElement))) {
            return true;
        }
        return !this.isElementIncluded(this.getParserPath(namedElement));
    }

    public IDesignInstanceWrapper getInstance(IRfDesignElement var1, ElementPath var2, String var3);

    public String getKind(IRfNamedElement var1);

    public String getURL(IRfNamedElement var1);

    public String getFullNameLabel(IRfNamedElement var1);

    default public Map.Entry<IRfFieldElement, IFSMModel> getFSMModelForBlock(IRfActionBlockElement block, Map<IRfFieldElement, IFSMModel> variablesWithModels) {
        if (block == null || variablesWithModels == null) {
            return null;
        }
        Optional<Map.Entry> model = variablesWithModels.entrySet().stream().filter(e -> block.equals(((IFSMModel)e.getValue()).getEnclosingScope())).findFirst();
        return model.isPresent() ? model.get() : null;
    }

    default public List<SpecadorCommentWrapper> getTransitionComment(Set<GoToInfo> markers, ParserPath parserPath, IProject project, String partitioning, String singleLineContext, String multilineContext, IFreeMarkerWrapper wrapper) {
        LinkedList<SpecadorCommentWrapper> comments = new LinkedList<SpecadorCommentWrapper>();
        DocumentManager documentManager = new DocumentManager(true);
        IDocument document = documentManager.getDocument(parserPath, project);
        if (!(document instanceof DVTSynchronizableDocument)) {
            return comments;
        }
        DVTSynchronizableDocument dvtDocument = (DVTSynchronizableDocument)document;
        int documentLength = dvtDocument.getLength();
        for (GoToInfo marker : markers) {
            int markerOffset = marker.offset;
            int markerLine = marker.line;
            try {
                if (dvtDocument.getLength() < markerOffset || markerOffset < 0) continue;
                String contextType = dvtDocument.getContentType(partitioning, markerOffset, false);
                int currentOffset = markerOffset;
                int currentLine = markerLine;
                while (!contextType.equals(singleLineContext) && !contextType.equals(multilineContext) && markerLine == currentLine && currentOffset < documentLength - 1) {
                    currentLine = document.getLineOfOffset(++currentOffset) + 1;
                    contextType = dvtDocument.getContentType(partitioning, currentOffset, false);
                }
                if (currentLine > markerLine || currentOffset >= documentLength) continue;
                ITypedRegion region = dvtDocument.getPartition(partitioning, currentOffset, false);
                String comment = document.get(currentOffset, region.getLength());
                if (contextType.equals(singleLineContext)) {
                    comment = comment.substring(2);
                } else if (contextType.equals(multilineContext)) {
                    comment = comment.substring(2, comment.length() - 2);
                    comment = ML_COMMENT.matcher(comment).replaceAll("");
                }
                CommentBlock commentBlock = new CommentBlock(comment, "", false);
                comments.addAll(wrapper.getComment(commentBlock));
            }
            catch (BadLocationException | BadPartitioningException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
        return comments;
    }

    default public IFreeMarkerWrapper getWrapper(IRfNamedElement namedElement) {
        return null;
    }

    default public boolean isValidForHTMLPreview(IRfNamedElement namedElement) {
        return false;
    }

    default public void addSpecadorPreviewListenerToBuildListeners() {
    }

    default public void removeSpecadorPreviewListenerFromBuildListeners() {
    }

    public String getFullPath(IRfNamedElement var1);

    default public String getPreviewPath(IRfNamedElement namedElement, SpecadorModel model) {
        String location = model.getLocation();
        return String.valueOf(location) + File.separator + "build" + File.separator + model.getOutputFormat().toBuildPath() + File.separator + this.getRelativePathToElement(namedElement, location) + ".html";
    }

    default public String getRelativePathToElement(IRfNamedElement namedElement, String location) {
        IFreeMarkerWrapper wrapper = this.getWrapper(namedElement);
        String fullPath = String.valueOf(wrapper.getFullPath()) + (namedElement.getLanguageKind().equals((Object)LanguageKind.E) ? File.separator : "");
        String sourceDirPath = String.valueOf(location) + File.separator + "source" + File.separator;
        String relativePath = fullPath.substring(sourceDirPath.length());
        return String.valueOf(relativePath) + wrapper.getName();
    }

    default public String getVerificationTopPath(IRfNamedElement element) {
        return "";
    }

    default public String getLibraryName(IRfNamedElement element) {
        return "";
    }

    default public String getClassPath(IRfNamedElement element, boolean includeClass) {
        return "";
    }

    default public String getPathToUpperMostClass(IRfNamedElement element) {
        return "";
    }

    default public int getNumberOfClassesWithInner(IRfNamedElement element) {
        return 0;
    }
}

