/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public class SpecadorCommentWrapper
implements IFreeMarkerWrapper {
    private CommentOutputType outputType;
    private DVTComment.CommentFormat inputFormat;
    private String content;
    private String rawContent;
    private String startLine;

    public SpecadorCommentWrapper(CommentOutputType type, String content, String startLine) {
        this.outputType = type;
        this.content = content;
        this.rawContent = content;
        this.startLine = startLine;
    }

    public SpecadorCommentWrapper(CommentOutputType type, String content, DVTComment.CommentFormat format, String startLine) {
        this.outputType = type;
        this.content = content;
        this.rawContent = content;
        this.inputFormat = format;
        this.startLine = startLine;
    }

    public SpecadorCommentWrapper(CommentOutputType type, String content, DVTComment.CommentFormat format, String rawContent, String startLine) {
        this.outputType = type;
        this.content = content;
        this.inputFormat = format;
        this.rawContent = rawContent;
        this.startLine = startLine;
    }

    public String getType() {
        return this.outputType.toString();
    }

    public String getContent() {
        return this.content;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public DVTComment.CommentFormat getInputFormat() {
        return this.inputFormat;
    }

    public String getFormatName() {
        return this.inputFormat == null ? "none" : this.inputFormat.getSpecadorXMLPreferenceName();
    }

    public String getStartLine() {
        return this.startLine;
    }

    public String getEndLine() {
        if (!this.rawContent.contains("\n")) {
            return this.startLine;
        }
        int start = Integer.parseInt(this.startLine);
        return String.valueOf(start + StringUtils.countMatches((String)this.rawContent, (String)"\n"));
    }

    @Override
    public IRfNamedElement getNamedElement() {
        return null;
    }

    @Override
    public String getKind() {
        return null;
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public CommentBlock getCommentBlock() {
        return null;
    }

    @Override
    public ICommentLinkResolver getLinker() {
        return null;
    }

    @Override
    public String createFileReferenceContent(File codeFileLocation) {
        return null;
    }

    @Override
    public String getLanguageKind() {
        return null;
    }

    @Override
    public SpecadorModel getModel() {
        return null;
    }

    public static enum CommentOutputType {
        TEXT("text"),
        TITLE("title"),
        WAVEDROM("wavedrom"),
        CUSTOM_DIAGRAM("custom_diagram"),
        RST("rst"),
        CODE_BLOCK("code-block"),
        NONE("none");

        private String name;

        private CommentOutputType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

