/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.specador.templates;

import com.google.common.collect.Maps;
import freemarker.template.SimpleHash;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorExitCode;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IAlwaysBlockWrapper;
import ro.amiq.dvt.specador.templates.IArchitectureWrapper;
import ro.amiq.dvt.specador.templates.IAssertWrapper;
import ro.amiq.dvt.specador.templates.IClassWrapper;
import ro.amiq.dvt.specador.templates.IComponentWrapper;
import ro.amiq.dvt.specador.templates.IEntityWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IInterfaceWrapper;
import ro.amiq.dvt.specador.templates.ILibraryWrapper;
import ro.amiq.dvt.specador.templates.IModuleWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.specador.templates.IStructWrapper;
import ro.amiq.dvt.specador.templates.ITestWrapper;
import ro.amiq.dvt.specador.templates.IUnitWrapper;
import ro.amiq.dvt.specador.templates.SpecadorCancelException;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.specador.templates.SphinxBuildRunner;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.dvt.wizards.specador.SpecadorManager;
import ro.amiq.dvt.wizards.specador.SpecadorModel;

public enum SpecadorGenerator {
    INSTANCE;

    private static final Pattern GENERATED_DATE;

    static {
        GENERATED_DATE = Pattern.compile("var generated_date = '");
    }

    public static String generateDocumentation(SpecadorModel model, SpecadorProgressMonitor monitor, IRfNamedElement namedElement) {
        return SpecadorGenerator.generateDocumentationInternal(model, monitor, namedElement);
    }

    public static String generateDocumentation(SpecadorModel model, SpecadorProgressMonitor monitor) {
        return SpecadorGenerator.generateDocumentationInternal(model, monitor, null);
    }

    public static String getOutputFilePath(SpecadorModel model, String sourceIndexBaseNameUsed) {
        if (sourceIndexBaseNameUsed == null) {
            sourceIndexBaseNameUsed = SpecadorGenerator.getSourceIndexBaseName(model);
        }
        String indexFileExtension = model.getOutputFormat() == SpecadorModel.OutputFormat.PDF ? ".pdf" : ".html";
        String outputFileName = model.getOutputFormat() == SpecadorModel.OutputFormat.PDF ? StringUtils.deleteWhitespace((String)model.getTitleText().toLowerCase().trim().replace(".", "")) : sourceIndexBaseNameUsed;
        return Paths.get(model.getLocation(), "build", model.getOutputFormat().toBuildPath(), String.valueOf(outputFileName) + indexFileExtension).toString();
    }

    public static IRfNamedElement getElementForPreview(IRfScopeElement element) {
        if (element == null) {
            return null;
        }
        IRfNamedElement namedElement = null;
        if (element instanceof IRfDefElement) {
            namedElement = ((IRfDefElement)((Object)element)).getNamedElement();
        } else if (element instanceof IRfNamedElement) {
            namedElement = (IRfNamedElement)element;
        }
        while (namedElement != null) {
            if (LanguageContributor.get(namedElement.getLanguageKind()).isValidForHTMLPreview(namedElement)) {
                return namedElement;
            }
            IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
            if (!(enclosingScope instanceof IRfNamedElement)) break;
            namedElement = (IRfNamedElement)enclosingScope;
        }
        return null;
    }

    public static String getHyperlink(IRfNamedElement namedElement, LanguageKind lang) {
        return LanguageContributor.get(lang).getHyperlink(namedElement);
    }

    private static String generateDocumentationInternal(SpecadorModel model, SpecadorProgressMonitor monitor, IRfNamedElement namedElement) {
        try {
            Wavedrom.initEngine();
            LanguageContributor.init(model);
            File location = SpecadorGenerator.createOutputLocation(model);
            File rstFilesLocation = new File(location, "source");
            if (model.isPreviewMode()) {
                monitor.beginTask("Generating Specador Preview", 3);
                IFreeMarkerWrapper wrapper = LanguageContributor.get(namedElement.getLanguageKind()).getWrapper(namedElement);
                SpecadorGenerator.generatePreviewPage(model, wrapper, monitor);
                SpecadorGenerator.generateConfigurationFile(model, "Specador Preview", rstFilesLocation, "index", monitor, true);
                SimpleHash root = FreeMarkerFileGenerator.createDataModel();
                root.put("previewPage", (Object)LanguageContributor.get(namedElement.getLanguageKind()).getRelativePathToElement(namedElement, location.getAbsolutePath()));
                SpecadorGenerator.generateIndexFile(model, model.getTitleText(), rstFilesLocation, root, monitor, true);
                monitor.worked(1);
                SphinxBuildRunner sphinxBuildRunner = new SphinxBuildRunner(model, monitor, true);
                sphinxBuildRunner.runBuild();
                String string = LanguageContributor.get(namedElement.getLanguageKind()).getPreviewPath(namedElement, model);
                return string;
            }
            monitor.beginTask(SpecadorConstants.getMessage(SpecadorConstants.generateFileMessage, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), String.valueOf(model.getOutputFormat().toString().toUpperCase()) + " Files"), SpecadorGenerator.getNumberOfFilesToDocument(model));
            SpecadorGenerator.validateCustomIndexFile(model, monitor);
            String sourceIndexBaseNameUsed = SpecadorGenerator.generateRstFiles(model, rstFilesLocation, monitor);
            monitor.beginSphinx();
            SphinxBuildRunner sphinxBuildRunner = new SphinxBuildRunner(model, monitor, false);
            if (sphinxBuildRunner.runBuild()) {
                String outputPath = SpecadorGenerator.getOutputFilePath(model, sourceIndexBaseNameUsed);
                ProgressPrinter.INSTANCE.printProgressRaw(model.getProject(), SpecadorConstants.getMessage(SpecadorConstants.indexFileMessage, outputPath));
                String string = outputPath;
                return string;
            }
            try {
                monitor.setExitCodeValue(SpecadorExitCode.EXTERNAL_ERROR);
            }
            catch (Exception e) {
                SpecadorManager.INSTANCE.logError(model.getProject(), e);
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private static void generatePreviewPage(SpecadorModel model, IFreeMarkerWrapper wrapper, SpecadorProgressMonitor monitor) {
        File outputFile = new File(wrapper.getFullPath());
        if (wrapper instanceof IClassWrapper) {
            SpecadorGenerator.generateClass(model, (IClassWrapper)wrapper, outputFile, Maps.newHashMap(), monitor, true);
        } else if (wrapper instanceof IModuleWrapper) {
            SpecadorGenerator.generateModule(model, (IModuleWrapper)wrapper, outputFile, Maps.newHashMap(), new File(outputFile, "diagrams"), monitor, true);
        } else if (wrapper instanceof IInterfaceWrapper) {
            SpecadorGenerator.generateInterface(model, (IInterfaceWrapper)wrapper, outputFile, new File(outputFile, "diagrams"), monitor);
        } else if (wrapper instanceof IArchitectureWrapper) {
            SpecadorGenerator.generateArchitecture(model, (IArchitectureWrapper)wrapper, outputFile, Maps.newHashMap(), monitor, true);
        } else if (wrapper instanceof IEntityWrapper) {
            SpecadorGenerator.generateEntity(model, (IEntityWrapper)wrapper, outputFile, Maps.newHashMap(), new File(outputFile, "diagrams"), monitor, true);
        } else if (wrapper instanceof IComponentWrapper) {
            SpecadorGenerator.generateComponent(model, (IComponentWrapper)wrapper, outputFile, monitor, true);
        } else if (wrapper instanceof IUnitWrapper) {
            SpecadorGenerator.generateUnit(model, (IUnitWrapper)wrapper, outputFile, (Map<String, String>)Maps.newHashMap(), (IProgressMonitor)monitor, ((IUnitWrapper)wrapper).getUnitType(), true);
        }
    }

    private static File createOutputLocation(SpecadorModel model) {
        model.setRawLocation(new File(model.getLocation(), model.getOutputFolderName()).getAbsolutePath());
        File location = new File(model.getLocation());
        location.mkdirs();
        if (model.isCleanLocation()) {
            SpecadorManager.recursiveClean(location);
        }
        SpecadorGenerator.extractSourcesFromJarTo(model, location);
        SpecadorGenerator.copyCustomStylingFiles(model, location);
        return location;
    }

    private static String generateRstFiles(SpecadorModel model, File rstFilesLocation, SpecadorProgressMonitor monitor) {
        HashMap<String, String> diagrams = new HashMap<String, String>();
        File externLocation = new File(rstFilesLocation, "extern");
        SpecadorGenerator.copyAttachedFiles(model, rstFilesLocation);
        SpecadorGenerator.copyAttachedFiles(model, externLocation);
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("hasDesignTops", SpecadorGenerator.generateDesignIndexTops(model, model.getProject(), rstFilesLocation, monitor));
        root.put("hasVerificationTops", SpecadorGenerator.generateVerificationIndexTops(model, rstFilesLocation, monitor));
        monitor.beginLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.E);
        File edtPackagesLocation = new File(rstFilesLocation, "packages");
        root.put("hasPackages", SpecadorGenerator.generateIndexPackages(model, rstFilesLocation, edtPackagesLocation, diagrams, monitor));
        File testsLocation = new File(rstFilesLocation, "tests");
        root.put("hasTests", model.hasEdtNature() && model.isExportEdtTests() && SpecadorGenerator.generateIndexTests(model, model.getProject(), testsLocation, diagrams, monitor));
        monitor.endLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.E);
        File librariesLocation = new File(rstFilesLocation, "libraries");
        root.put("libraries", model.hasVlogNature() || model.hasVhdlNature() ? SpecadorGenerator.generateIndexLibraries(model, librariesLocation, diagrams, monitor) : Collections.emptyList());
        root.put("hasMacros", SpecadorGenerator.generateIndexMacros(model, rstFilesLocation, monitor));
        root.put("hasAsserts", model.isExportVlogAssertions() && SpecadorGenerator.generateIndexAsserts(model, rstFilesLocation, monitor));
        root.put("hasChecks", SpecadorGenerator.generateIndexChecks(model, rstFilesLocation, monitor));
        root.put("hasCovergroups", SpecadorGenerator.generateIndexCovergroups(model, rstFilesLocation, monitor));
        if (!model.isForPDF()) {
            SpecadorGenerator.generateIndexDiagrams(model, rstFilesLocation, diagrams, monitor);
            root.put("hasDiagrams", !diagrams.isEmpty());
        }
        String indexFile = SpecadorGenerator.generateIndexFile(model, model.getTitleText(), rstFilesLocation, root, monitor, false);
        SpecadorGenerator.generateConfigurationFile(model, model.getTitleText(), rstFilesLocation, indexFile, monitor, false);
        return indexFile;
    }

    private static void validateCustomIndexFile(SpecadorModel model, SpecadorProgressMonitor monitor) throws SpecadorCancelException {
        if (model.getCustomIndexFilePath() != null && !model.getCustomIndexFilePath().getValue().isEmpty()) {
            File providedIndexFile = new File(model.getCustomIndexFilePath().getValue());
            if (!providedIndexFile.isAbsolute()) {
                providedIndexFile = new File(model.getProject().getLocation().toOSString(), model.getCustomIndexFilePath().getValue());
                model.setCustomIndexFile(providedIndexFile.getAbsolutePath());
            }
            if (!providedIndexFile.exists()) {
                monitor.setExitCodeValue(SpecadorExitCode.INVALID_ERROR);
                throw new SpecadorCancelException("*** Error: Custom index file path does not point to an existing file!");
            }
            if (!model.getCustomIndexFilePath().getValue().endsWith("rst") && !model.getCustomIndexFilePath().getValue().endsWith("md")) {
                monitor.setExitCodeValue(SpecadorExitCode.INVALID_ERROR);
                throw new SpecadorCancelException("*** Error: Custom index file is not a reStructuredText/Markdown file!");
            }
        }
    }

    private static void generateIndexDiagrams(SpecadorModel model, File location, Map<String, String> diagrams, SpecadorProgressMonitor monitor) {
        if (diagrams.isEmpty()) {
            return;
        }
        diagrams = diagrams.entrySet().stream().sorted(Comparator.comparing(e -> (String)e.getValue()).thenComparing(e -> (String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("diagrams", (Object)diagrams);
        root.put("hasBlockDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("Block")).findFirst().isPresent());
        root.put("hasFlowDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("Flow")).findFirst().isPresent());
        root.put("hasSubInstancesDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("Sub-Instances")).findFirst().isPresent());
        root.put("hasSchematicDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("Schematic")).findFirst().isPresent());
        root.put("hasFSMDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("FSM")).findFirst().isPresent());
        root.put("hasUMLInheritanceDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("UML Inheritance")).findFirst().isPresent());
        root.put("hasUMLCollaborationDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("UML Collaboration")).findFirst().isPresent());
        root.put("hasComponentsDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("UVM")).findFirst().isPresent());
        root.put("hasBitFieldDiagrams", diagrams.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("Bit")).findFirst().isPresent());
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-diagrams"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-diagrams")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), monitor);
    }

    private static void copyAttachedFiles(SpecadorModel model, File sourceLocation) {
        List<File> attachedLocations = model.getAttachedLocations();
        try {
            if (attachedLocations != null && !attachedLocations.isEmpty()) {
                sourceLocation.mkdirs();
                for (File attachedLocation : attachedLocations) {
                    File destinationDirectory = new File(sourceLocation, attachedLocation.getName());
                    if (destinationDirectory.exists()) {
                        SpecadorManager.recursiveClean(destinationDirectory);
                    } else {
                        Files.createDirectory(destinationDirectory.toPath(), new FileAttribute[0]);
                    }
                    FileUtils.copyDirectory((File)attachedLocation, (File)destinationDirectory);
                }
            }
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
        }
    }

    private static void generateConfigurationFile(SpecadorModel model, String title, File location, String index, IProgressMonitor progressMonitor, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("project", (Object)title);
        root.put("copyright", (Object)model.getCopyright());
        root.put("author", (Object)model.getAuthor());
        root.put("version", (Object)model.getVersion());
        root.put("specador_version", (Object)SpecadorManager.getVersion());
        root.put("hasCode", model.getExportSourceCode());
        root.put("styleVerbatimComments", DVTComment.CommentFormat.OLD_VERBATIM.equals((Object)model.getDocFormattingType()));
        root.put("location", (Object)location.getAbsolutePath());
        root.put("isPreview", isPreview);
        root.put("index", (Object)index);
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.configurationTemplateFile, model.getOutputFormat().toString()), new File(location, SpecadorConstants.configurationFile), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
    }

    private static String getSourceIndexBaseName(SpecadorModel model) {
        String baseName = "index";
        if (model.getCustomIndexFilePath() != null && !model.getCustomIndexFilePath().getValue().isEmpty()) {
            File providedIndexFile = new File(model.getCustomIndexFilePath().getValue());
            try {
                if (!providedIndexFile.isAbsolute()) {
                    providedIndexFile = new File(model.getProject().getLocation().toOSString(), model.getCustomIndexFilePath().getValue());
                }
                Path providedIndexPath = providedIndexFile.getCanonicalFile().toPath();
                Path providedIndexParentPath = providedIndexFile.getParentFile().getCanonicalFile().toPath();
                for (File attached : model.getAttachedLocations()) {
                    Path attachedPath = attached.getCanonicalFile().toPath();
                    if (!providedIndexParentPath.startsWith(attachedPath)) continue;
                    String indexPath = FilenameUtils.removeExtension((String)providedIndexPath.toString());
                    return indexPath.substring(indexPath.indexOf(attached.getName()));
                }
                baseName = "index";
            }
            catch (Exception e) {
                SpecadorManager.INSTANCE.logError(model.getProject(), e);
                baseName = "index";
            }
        }
        return baseName;
    }

    private static String generateIndexFile(SpecadorModel model, String title, File location, SimpleHash root, IProgressMonitor progressMonitor, boolean isPreview) {
        try {
            String sourceIndexBaseName = SpecadorGenerator.getSourceIndexBaseName(model);
            if (!isPreview && model.getCustomIndexFilePath() != null && !model.getCustomIndexFilePath().getValue().isEmpty()) {
                File providedIndexFile = new File(model.getCustomIndexFilePath().getValue());
                if (!providedIndexFile.isAbsolute()) {
                    providedIndexFile = new File(model.getProject().getLocation().toOSString(), model.getCustomIndexFilePath().getValue());
                }
                String customFileExtension = FilenameUtils.getExtension((String)model.getCustomIndexFilePath().getValue());
                File targetIndexFileInSourceDir = Paths.get(location.getAbsolutePath(), String.valueOf(sourceIndexBaseName) + "." + customFileExtension).toFile();
                targetIndexFileInSourceDir.getParentFile().mkdirs();
                Files.copy(providedIndexFile.toPath(), targetIndexFileInSourceDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return sourceIndexBaseName;
            }
            root.put("project", (Object)title);
            File defaultIndexFile = new File(location, SpecadorConstants.getMessage(SpecadorConstants.indexFile, "rst"));
            FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index"), defaultIndexFile, root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
            return "index";
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
            return "index";
        }
    }

    public boolean hasTops(IProject project, SpecadorModel model) {
        return !SpecadorGenerator.getDesignTops(project, model).isEmpty();
    }

    private static List<IRfDesignElement> getDesignTops(IProject project, SpecadorModel model) {
        if (!(model.hasVlogNature() && model.isExportVlogLibraries() || model.hasVhdlNature() && model.isExportVhdlLibraries())) {
            return Collections.emptyList();
        }
        if (BuildConfigManager.getTopConfigurationProperties(project).isEmpty()) {
            return Collections.emptyList();
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return Collections.emptyList();
        }
        List<IRfDesignElement> tops = elManager.getTopDesigns();
        if (tops == null) {
            return Collections.emptyList();
        }
        tops = tops.stream().filter(top -> !LanguageContributor.get(top.getLanguageKind()).shouldFilter((IRfNamedElement)top)).collect(Collectors.toList());
        return tops;
    }

    private static boolean generateDesignIndexTops(SpecadorModel model, IProject project, File location, IProgressMonitor progressMonitor) {
        List<IRfDesignElement> topDesigns = SpecadorGenerator.getDesignTops(project, model);
        if (topDesigns.isEmpty()) {
            return false;
        }
        location.mkdirs();
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("elements", topDesigns.stream().map(t -> LanguageContributor.get(t.getLanguageKind()).getDesignTopFile((IRfDesignElement)t)).collect(Collectors.toList()));
        root.put("title", (Object)"Design Tops");
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-elements"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-tops")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static Set<IRfNamedElement> getVerificationTops(SpecadorModel model) {
        TreeSet<IRfNamedElement> topVerificationTests = new TreeSet<IRfNamedElement>((o1, o2) -> o1.getName().compareTo(o2.getName()));
        if (model.hasVlogNature()) {
            topVerificationTests.addAll(LanguageContributor.get(LanguageKind.VLOG).getVerificationTops(model));
        }
        if (model.hasEdtNature()) {
            topVerificationTests.addAll(LanguageContributor.get(LanguageKind.E).getVerificationTops(model));
        }
        return topVerificationTests;
    }

    private static boolean generateVerificationIndexTops(SpecadorModel model, File location, IProgressMonitor progressMonitor) {
        Set<IRfNamedElement> topVerificationTests = SpecadorGenerator.getVerificationTops(model);
        if (topVerificationTests.isEmpty()) {
            return false;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        location.mkdirs();
        ArrayList<String> verificationTopsWithDisplayNames = new ArrayList<String>(2 * topVerificationTests.size());
        for (IRfNamedElement t : topVerificationTests) {
            verificationTopsWithDisplayNames.add(String.valueOf(LanguageContributor.get(t.getLanguageKind()).getVerificationTopPath(t)) + "/" + t.getName());
            if (t.getLanguageKind().equals((Object)LanguageKind.VLOG)) {
                verificationTopsWithDisplayNames.add("Class " + t.getName());
                continue;
            }
            verificationTopsWithDisplayNames.add("");
        }
        root.put("hasDisplayNames", true);
        root.put("elements", verificationTopsWithDisplayNames);
        root.put("title", (Object)"Verification Tops");
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-elements"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-verification-tops")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static boolean generateIndexPackages(SpecadorModel model, File rootLocation, File edtLocation, Map<String, String> diagrams, SpecadorProgressMonitor progressMonitor) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        LinkedList<? super IFreeMarkerWrapper> packages = new LinkedList<IFreeMarkerWrapper>();
        packages.addAll(LanguageContributor.get(LanguageKind.E).getPackages(model).stream().filter(pkg -> SpecadorGenerator.generatePackageELang(model, pkg, edtLocation, diagrams, progressMonitor)).collect(Collectors.toList()));
        if (packages.isEmpty()) {
            return false;
        }
        packages.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("title", (Object)"Packages");
        root.put("elements", packages.stream().map(element -> "packages/" + element.getPackageName() + "/" + element.getName()).collect(Collectors.toList()));
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-elements"), new File(rootLocation, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-packages")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static List<String> generateIndexLibraries(SpecadorModel model, File location, Map<String, String> diagrams, SpecadorProgressMonitor progressMonitor) {
        LinkedList<? super IFreeMarkerWrapper> libraries = new LinkedList<IFreeMarkerWrapper>();
        List<ILibraryWrapper> verilogLibraries = LanguageContributor.get(LanguageKind.VLOG).getSelectedLibraries(model);
        List<ILibraryWrapper> vhdlLibraries = LanguageContributor.get(LanguageKind.VHDL).getSelectedLibraries(model);
        boolean mixedLibraries = !verilogLibraries.isEmpty() && !vhdlLibraries.isEmpty();
        boolean singleLibrary = verilogLibraries.size() + vhdlLibraries.size() == 1;
        progressMonitor.beginLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.VLOG);
        libraries.addAll(verilogLibraries.stream().filter(lib -> SpecadorGenerator.generateLibraryVerilog(model, lib, diagrams, location, progressMonitor, mixedLibraries, !singleLibrary)).collect(Collectors.toList()));
        progressMonitor.endLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.VLOG);
        progressMonitor.beginLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.VHDL);
        libraries.addAll(vhdlLibraries.stream().filter(l -> SpecadorGenerator.generateLibraryVHDL(model, l, location, diagrams, progressMonitor, mixedLibraries, !singleLibrary)).collect(Collectors.toList()));
        progressMonitor.endLanguage(SpecadorProgressMonitor.SpecadorLanguageKind.VHDL);
        if (libraries.isEmpty()) {
            return Collections.emptyList();
        }
        libraries.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        List<String> libraryFileNames = libraries.stream().map(library -> String.valueOf(library.getFileName()) + "/" + library.getFileName()).collect(Collectors.toList());
        if (!singleLibrary) {
            SimpleHash root = FreeMarkerFileGenerator.createDataModel();
            root.put("title", (Object)"Libraries");
            root.put("elements", libraryFileNames);
            location.mkdirs();
            FreeMarkerFileGenerator.generateFile(model, "index-elements.rst.ftl", new File(location, "index-libraries.rst"), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        }
        return libraryFileNames;
    }

    private static boolean generateIndexMacros(SpecadorModel model, File location, IProgressMonitor progressMonitor) {
        List<IFreeMarkerWrapper> definedControlDefines = LanguageContributor.get(LanguageKind.VLOG).getDefinedControlDefines(model);
        List<IFreeMarkerWrapper> undefinedControlDefines = LanguageContributor.get(LanguageKind.VLOG).getUndefinedControlDefines(model);
        List<IFreeMarkerWrapper> defines = LanguageContributor.get(LanguageKind.VLOG).getDefines(model);
        List<IFreeMarkerWrapper> ifndefGuards = LanguageContributor.get(LanguageKind.VLOG).getIfndefGuards(model);
        Map<String, List<IFreeMarkerWrapper>> macros = LanguageContributor.get(LanguageKind.E).getMacros(model);
        if (definedControlDefines.isEmpty() && undefinedControlDefines.isEmpty() && defines.isEmpty() && ifndefGuards.isEmpty() && macros.isEmpty()) {
            return false;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        definedControlDefines.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("definedControlDefines", definedControlDefines);
        undefinedControlDefines.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("undefinedControlDefines", undefinedControlDefines);
        defines.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("defines", defines);
        ifndefGuards.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("ifndefGuards", ifndefGuards);
        for (Map.Entry<String, List<IFreeMarkerWrapper>> macro : macros.entrySet()) {
            List<IFreeMarkerWrapper> macrosList = macro.getValue();
            macrosList.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put(macro.getKey(), macrosList);
        }
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-macros"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-macros")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static boolean generateIndexAsserts(SpecadorModel model, File location, IProgressMonitor progressMonitor) {
        List<IAssertWrapper> assertions;
        block5: {
            block4: {
                try {
                    if (model.getProject().hasNature("ro.amiq.vlogdt.VlogNature")) break block4;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            assertions = LanguageContributor.get(LanguageKind.VLOG).getAssertions(model.getProject());
            if (!assertions.isEmpty()) break block5;
            return false;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("immediateAssertions", assertions.stream().filter(a -> !a.isConcurrentAssertion()).collect(Collectors.toList()));
        root.put("concurrentAssertions", assertions.stream().filter(a -> a.isConcurrentAssertion()).collect(Collectors.toList()));
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-asserts"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-asserts")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static boolean generateIndexChecks(SpecadorModel model, File location, IProgressMonitor progressMonitor) {
        if (!model.hasEdtNature()) {
            return false;
        }
        List<IFreeMarkerWrapper> checks = LanguageContributor.get(LanguageKind.E).getChecks(model);
        if (checks.isEmpty()) {
            return false;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("hasCode", false);
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("checks", checks);
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-checks"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-checks")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static boolean generateIndexCovergroups(SpecadorModel model, File location, IProgressMonitor progressMonitor) {
        if (!model.hasVlogNature() && !model.hasEdtNature()) {
            return false;
        }
        ArrayList<IFreeMarkerWrapper> covergroups = new ArrayList<IFreeMarkerWrapper>();
        covergroups.addAll(LanguageContributor.get(LanguageKind.VLOG).getCovergroups(model));
        covergroups.addAll(LanguageContributor.get(LanguageKind.E).getCovergroups(model));
        if (covergroups.isEmpty()) {
            return false;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("hasCode", false);
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("covergroups", covergroups);
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-covergroups"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-covergroups")), root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor);
        return true;
    }

    private static boolean generateLibraryVerilog(SpecadorModel model, ILibraryWrapper lib, Map<String, String> diagrams, File rootLocation, IProgressMonitor progressMonitor, boolean mixedLibraries, boolean showTitle) {
        List<IFreeMarkerWrapper> events;
        List<IFreeMarkerWrapper> structs;
        List<IFreeMarkerWrapper> enums;
        if (!model.isExportVlogLibraries() || !model.getVlogSelectedLibraryNames().contains(lib.getName())) {
            return false;
        }
        File location = new File(rootLocation, lib.getFileName());
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)lib.getFormatedName());
        root.put("unformatedname", (Object)lib.getName());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        root.put("id", (Object)lib.getID());
        if (mixedLibraries) {
            root.put("language", (Object)"SV");
        }
        root.put("showTitle", showTitle);
        List<IModuleWrapper> modules = lib.getModules(model);
        List<IClassWrapper> classes = lib.getClasses();
        List<IInterfaceWrapper> interfaces = lib.getInterfaces(model);
        List<IPackageWrapper> packages = lib.getPackages(model);
        File modulesLocation = new File(location, "modules");
        File classesLocation = new File(location, "classes");
        File interfaceLocation = new File(location, "interfaces");
        File packageLocation = new File(location, "packages");
        File moduleDiagramsLocation = new File(modulesLocation, "diagrams");
        File interfaceDiagramsLocation = new File(interfaceLocation, "diagrams");
        modules.stream().forEach(m -> SpecadorGenerator.generateModule(model, m, modulesLocation, diagrams, moduleDiagramsLocation, progressMonitor, false));
        classes.stream().forEach(c -> SpecadorGenerator.generateClass(model, c, classesLocation, diagrams, progressMonitor, false));
        interfaces.stream().forEach(i -> SpecadorGenerator.generateInterface(model, i, interfaceLocation, interfaceDiagramsLocation, progressMonitor));
        packages = packages.stream().filter(p -> SpecadorGenerator.generatePackageVerilog(model, p, packageLocation, diagrams, progressMonitor)).collect(Collectors.toList());
        modules.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        classes.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        interfaces.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        packages.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("modules", modules);
        root.put("classes", classes);
        root.put("interfaces", interfaces);
        root.put("packages", packages);
        root.put("verilog", true);
        List<IFreeMarkerWrapper> typedefs = lib.getTypedefs();
        if (!typedefs.isEmpty()) {
            root.put("typedefs", typedefs);
        }
        if (!(enums = lib.getEnums()).isEmpty()) {
            root.put("enums", enums);
        }
        if (!(structs = lib.getStructs()).isEmpty()) {
            if (model.getBitfieldDiagram()) {
                structs.parallelStream().forEach(struct -> ((IStructWrapper)struct).setBitField(((IStructWrapper)struct).generateBitfieldDiagram(new File(location, "diagrams"), progressMonitor)));
            }
            root.put("structs", structs);
            root.put("structsIndexes", SpecadorGenerator.generateStructFiles(model, structs, lib.getName(), location, progressMonitor));
        }
        List<IFreeMarkerWrapper> functions = lib.getFunctions();
        List<IFreeMarkerWrapper> DPIexports = lib.getDPIExports();
        List<IFreeMarkerWrapper> DPIimports = lib.getDPIImports();
        List<IFreeMarkerWrapper> tasks = lib.getTasks();
        if (!functions.isEmpty()) {
            root.put("functions", functions);
        }
        if (!DPIexports.isEmpty()) {
            root.put("DPIexports", DPIexports);
        }
        if (!DPIimports.isEmpty()) {
            root.put("DPIimports", DPIimports);
        }
        if (!tasks.isEmpty()) {
            root.put("tasks", tasks);
        }
        if (!(events = lib.getEvents()).isEmpty()) {
            root.put("events", events);
        }
        typedefs.forEach(t -> SpecadorGenerator.generateCode(model, t, progressMonitor, location));
        enums.forEach(e -> SpecadorGenerator.generateCode(model, e, progressMonitor, location));
        structs.forEach(e -> SpecadorGenerator.generateCode(model, e, progressMonitor, location));
        functions.forEach(fi -> SpecadorGenerator.generateCode(model, fi, progressMonitor, location));
        DPIexports.forEach(df -> SpecadorGenerator.generateCode(model, df, progressMonitor, location));
        DPIimports.forEach(df -> SpecadorGenerator.generateCode(model, df, progressMonitor, location));
        tasks.forEach(t -> SpecadorGenerator.generateCode(model, t, progressMonitor, location));
        if (modules.isEmpty() && classes.isEmpty() && interfaces.isEmpty() && packages.isEmpty() && typedefs.isEmpty() && enums.isEmpty() && structs.isEmpty() && functions.isEmpty() && DPIexports.isEmpty() && DPIimports.isEmpty() && tasks.isEmpty() && events.isEmpty()) {
            return false;
        }
        location.mkdirs();
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "library"), new File(location, String.valueOf(lib.getFileName()) + ".rst"), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 1);
        return true;
    }

    private static void generateModule(SpecadorModel model, IModuleWrapper adapter, File location, Map<String, String> diagrams, File diagramsLocation, IProgressMonitor progressMonitor, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("id", (Object)adapter.getID());
        root.put("isPreview", isPreview);
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        List<IClassWrapper> classes = adapter.getClasses();
        if (!classes.isEmpty()) {
            if (!isPreview) {
                File classesLocation = new File(location, adapter.getName());
                classesLocation.mkdirs();
                classes.stream().forEach(c -> SpecadorGenerator.generateClass(model, c, classesLocation, diagrams, progressMonitor, false));
            }
            root.put("classes", classes);
        }
        root.put("parameters", adapter.getParameters());
        root.put("ports", adapter.getPorts());
        root.put("variables", model.isExportVlogModulesVariables() ? adapter.getVariables() : Collections.emptyList());
        root.put("typedefs", adapter.getTypeAliases());
        root.put("structs", adapter.getStructTypeAliases());
        root.put("comment", adapter.getComment());
        root.put("commentLine", (Object)adapter.getCommentLine());
        root.put("line", (Object)adapter.getDeclarationLine());
        root.put("localparams", model.isExportVlogLocalparams() ? adapter.getLocalparams() : Collections.emptyList());
        if (model.isExportVlogAssertions()) {
            root.put("assertions", adapter.getAssertions());
        }
        List<IAlwaysBlockWrapper> alwaysBlocks = adapter.getAlwaysBlocks();
        for (IAlwaysBlockWrapper alwaysBlock : alwaysBlocks) {
            if (!alwaysBlock.containsFSMDiagram()) continue;
            diagrams.put(String.valueOf(adapter.getID()) + "-fsm-" + alwaysBlock.getFSMDiagramVariableName(), SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "FSM", String.valueOf(adapter.getName()) + "." + alwaysBlock.getFSMDiagramVariableName()));
        }
        List<IRfDesignElement> topDesigns = SpecadorGenerator.getDesignTops(model.getProject(), model);
        root.put("alwaysBlocks", alwaysBlocks);
        root.put("functions", adapter.getFunctions());
        root.put("tasks", adapter.getTasks());
        root.put("clockingBlocks", adapter.getClockingBlocks());
        root.put("events", adapter.getEvents());
        root.put("instances", topDesigns.isEmpty() ? Collections.emptyList() : adapter.getInstances(topDesigns));
        Map<Object, Object> subInstances = topDesigns.isEmpty() ? Collections.emptyMap() : adapter.getSubInstances();
        root.put("submodules", subInstances);
        root.put("isDesignTop", !topDesigns.isEmpty() && topDesigns.contains(adapter.getNamedElement()));
        boolean hasBlockDiagram = model.getDesignBlockDiagram() && adapter.generateBlockDiagram(diagramsLocation, progressMonitor);
        boolean hasFlowDiagram = model.getDesignFlowDiagram() && !subInstances.isEmpty() && adapter.generateFlowDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        boolean hasSubInstancesDiagram = model.getDesignSubInstancesDiagram() && !subInstances.isEmpty() && adapter.generateSubInstancesDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        boolean hasSchematicDiagram = model.getDesignSchematicDiagram() && !subInstances.isEmpty() && adapter.generateSchematicDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        root.put("hasFlowDiagram", hasFlowDiagram);
        root.put("hasSubInstancesDiagram", hasSubInstancesDiagram);
        root.put("hasSchematicDiagram", hasSchematicDiagram);
        root.put("hasBlockDiagram", hasBlockDiagram);
        if (hasBlockDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-block", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Block", adapter.getName()));
        }
        if (hasFlowDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-flow", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Flow", adapter.getName()));
        }
        if (hasSubInstancesDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-subinstances", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Sub-Instances", adapter.getName()));
        }
        if (hasSchematicDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-schematic", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Schematic", adapter.getName()));
        }
        if (model.getFSMDiagrams()) {
            adapter.generateFSMDiagrams(diagramsLocation, progressMonitor);
        }
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "module"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, adapter.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 1);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, location);
    }

    private static void generateInterface(SpecadorModel model, IInterfaceWrapper adapter, File location, File diagramsLocation, IProgressMonitor progressMonitor) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML) && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("id", (Object)adapter.getID());
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        root.put("isPreview", model.isPreviewMode());
        List<IRfDesignElement> topDesigns = SpecadorGenerator.getDesignTops(model.getProject(), model);
        root.put("parameters", adapter.getParameters());
        root.put("ports", adapter.getPorts());
        root.put("line", (Object)adapter.getDeclarationLine());
        root.put("variables", adapter.getVariables());
        root.put("comment", adapter.getComment());
        root.put("commentLine", (Object)adapter.getCommentLine());
        root.put("functions", adapter.getFunctions());
        root.put("tasks", adapter.getTasks());
        root.put("clockingBlocks", adapter.getClockingBlocks());
        root.put("events", adapter.getEvents());
        root.put("modports", adapter.getModports());
        root.put("instances", topDesigns.isEmpty() ? Collections.emptyList() : adapter.getInstances(topDesigns));
        root.put("hasBlockDiagram", model.getDesignBlockDiagram() && adapter.generateBlockDiagram(diagramsLocation, progressMonitor));
        root.put("localparams", model.isExportVlogLocalparams() ? adapter.getLocalparams() : Collections.emptyList());
        if (model.isExportVlogAssertions()) {
            root.put("assertions", adapter.getAssertions());
        }
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "interface"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, adapter.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 1);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, location);
    }

    private static boolean generatePackageVerilog(SpecadorModel model, IPackageWrapper pkg, File rootLocation, Map<String, String> diagrams, IProgressMonitor progressMonitor) {
        File location = new File(rootLocation, pkg.getName());
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)pkg.getFormatedName());
        root.put("fullName", (Object)pkg.getName());
        root.put("unformatedname", (Object)pkg.getName());
        root.put("id", (Object)pkg.getID());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        List<IFreeMarkerWrapper> typedefs = pkg.getTypedefs();
        List<IFreeMarkerWrapper> variables = pkg.getVariables();
        List<IFreeMarkerWrapper> enums = pkg.getEnums();
        List<IFreeMarkerWrapper> parameters = pkg.getParameters();
        List<IFreeMarkerWrapper> localparams = pkg.getLocalParameters();
        List<IFreeMarkerWrapper> structs = pkg.getStructs();
        if (model.getBitfieldDiagram()) {
            structs.parallelStream().forEach(struct -> ((IStructWrapper)struct).setBitField(((IStructWrapper)struct).generateBitfieldDiagram(new File(location, "diagrams"), progressMonitor)));
        }
        root.put("typedefs", typedefs);
        root.put("variables", model.isExportVlogPackagesVariables() ? variables : Collections.emptyList());
        root.put("enums", enums);
        root.put("parameters", parameters);
        root.put("localparams", model.isExportVlogLocalparams() ? localparams : Collections.emptyList());
        root.put("structs", structs);
        root.put("structsIndexes", SpecadorGenerator.generateStructFiles(model, structs, pkg.getName(), location, progressMonitor));
        List<IFreeMarkerWrapper> functions = pkg.getFunctions();
        List<IFreeMarkerWrapper> DPIexports = pkg.getDPIExports();
        List<IFreeMarkerWrapper> DPIimports = pkg.getDPIImports();
        List<IFreeMarkerWrapper> tasks = pkg.getTasks();
        root.put("functions", functions);
        root.put("DPIexports", DPIexports);
        root.put("DPIimports", DPIimports);
        root.put("tasks", tasks);
        root.put("events", pkg.getEvents());
        List<IClassWrapper> classes = pkg.getClasses();
        if (!classes.isEmpty()) {
            location.mkdirs();
            classes.stream().forEach(c -> SpecadorGenerator.generateClass(model, c, location, diagrams, progressMonitor, false));
            root.put("classes", classes);
        }
        typedefs.forEach(t -> SpecadorGenerator.generateCode(model, t, progressMonitor, location));
        variables.forEach(v -> SpecadorGenerator.generateCode(model, v, progressMonitor, location));
        enums.forEach(e -> SpecadorGenerator.generateCode(model, e, progressMonitor, location));
        structs.forEach(e -> SpecadorGenerator.generateCode(model, e, progressMonitor, location));
        functions.forEach(f2 -> SpecadorGenerator.generateCode(model, f2, progressMonitor, location));
        DPIexports.forEach(f2 -> SpecadorGenerator.generateCode(model, f2, progressMonitor, location));
        DPIimports.forEach(f2 -> SpecadorGenerator.generateCode(model, f2, progressMonitor, location));
        tasks.forEach(t -> SpecadorGenerator.generateCode(model, t, progressMonitor, location));
        if (!(classes.isEmpty() && typedefs.isEmpty() && variables.isEmpty() && enums.isEmpty() && structs.isEmpty() && functions.isEmpty() && DPIexports.isEmpty() && DPIimports.isEmpty() && tasks.isEmpty() && parameters.isEmpty() && localparams.isEmpty())) {
            location.mkdirs();
            FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "package"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, pkg.getDocumentationName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 0);
            return true;
        }
        return false;
    }

    private static void generateClass(SpecadorModel model, IClassWrapper clazz, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, boolean isPreview) {
        SpecadorGenerator.generateClass(model, clazz, location, diagrams, true, progressMonitor, isPreview);
    }

    private static void generateClass(SpecadorModel model, IClassWrapper clazz, File location, Map<String, String> diagrams, boolean exportSourceCode, IProgressMonitor progressMonitor, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)clazz.getFormatedName());
        root.put("unformatedname", (Object)clazz.getName());
        root.put("id", (Object)clazz.getID());
        root.put("variables", clazz.getVariables());
        root.put("declaration", (Object)clazz.getDeclarationLocation());
        root.put("line", (Object)clazz.getDeclarationLine());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        root.put("comment", clazz.getComment());
        root.put("commentLine", (Object)clazz.getCommentLine());
        root.put("classHierarchy", clazz.getClassHierarchy(isPreview));
        root.put("parameters", clazz.getParameters());
        root.put("constraints", clazz.getConstraints());
        root.put("constructors", clazz.getConstructors());
        root.put("isPreview", isPreview);
        root.put("typedefs", clazz.getPureTypeAliases());
        root.put("enums", clazz.getEnumTypeAliases());
        root.put("localparams", model.isExportVlogLocalparams() ? clazz.getLocalparams() : Collections.emptyList());
        root.put("isUVMTest", clazz.isUvmTestClass());
        if (model.isExportVlogAssertions()) {
            root.put("assertions", clazz.getAssertions());
        }
        List<IStructWrapper> structs = clazz.getStructTypeAliases();
        File diagramsLocation = new File(location, "diagrams");
        if (model.getBitfieldDiagram()) {
            structs.parallelStream().forEach(struct -> struct.setBitField(struct.generateBitfieldDiagram(diagramsLocation, progressMonitor)));
        }
        root.put("structs", structs);
        root.put("structsIndexes", SpecadorGenerator.generateStructFiles(model, structs, clazz.getName(), location, progressMonitor));
        root.put("coverGroups", clazz.getCoverGroups());
        if (model.isExportVlogClassInheritedMembers()) {
            root.put("inheritedVariables", clazz.getInheritedVariables());
            root.put("inheritedFunctions", clazz.getInheritedMisc("functions"));
            root.put("inheritedTasks", clazz.getInheritedMisc("tasks"));
        }
        root.put("events", clazz.getEvents());
        root.put("functions", clazz.getFunctions());
        root.put("tasks", clazz.getTasks());
        Set<IRfNamedElement> verificationTops = SpecadorGenerator.getVerificationTops(model);
        boolean hasBitfieldDiagram = model.getBitfieldDiagram() && clazz.generateBitfieldDiagram(diagramsLocation, progressMonitor);
        boolean hasUMLDiagram = !verificationTops.contains(clazz.getNamedElement()) && !hasBitfieldDiagram && clazz.generateUMLInheritanceDiagram(diagramsLocation, progressMonitor);
        boolean hasUMLCollaborationDiagram = !verificationTops.contains(clazz.getNamedElement()) && !hasBitfieldDiagram && clazz.generateUMLCollaborationDiagram(diagramsLocation, progressMonitor);
        boolean hasComponentDiagram = verificationTops.contains(clazz.getNamedElement()) && clazz.generateComponentDiagram(diagramsLocation, progressMonitor, model.getUvmComponentDiagramDepth());
        root.put("hasUMLDiagram", hasUMLDiagram);
        root.put("hasUMLCollaborationDiagram", hasUMLCollaborationDiagram);
        root.put("hasBitfieldDiagram", hasBitfieldDiagram);
        root.put("hasComponentDiagram", hasComponentDiagram);
        if (hasUMLDiagram) {
            diagrams.put(String.valueOf(clazz.getID()) + "-uml", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "UML Inheritance", clazz.getFormatedName()));
        }
        if (hasUMLCollaborationDiagram) {
            diagrams.put(String.valueOf(clazz.getID()) + "-collaboration", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "UML Collaboration", clazz.getFormatedName()));
        }
        if (hasBitfieldDiagram) {
            diagrams.put(String.valueOf(clazz.getID()) + "-bitfield", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Bit Field", "UVM Register " + clazz.getFormatedName()));
        }
        if (hasComponentDiagram) {
            diagrams.put(String.valueOf(clazz.getID()) + "-components", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "UVM Components", clazz.getFormatedName()));
        }
        root.put("bitfields", hasBitfieldDiagram ? clazz.getBitFields() : Collections.emptyList());
        List<Object> innerClasses = model.isExportVlogInnerClasses() ? clazz.getInnerClasses() : Collections.emptyList();
        root.put("innerClasses", innerClasses);
        if (!isPreview) {
            location.mkdirs();
            File innerClassesLocation = new File(location, clazz.getName());
            innerClasses.forEach(c -> SpecadorGenerator.generateClass(model, c, innerClassesLocation, diagrams, false, progressMonitor, false));
        }
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "class"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, clazz.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 1);
        if (exportSourceCode) {
            SpecadorGenerator.generateCode(model, clazz, progressMonitor, location);
        }
    }

    private static List<String> generateStructFiles(SpecadorModel model, List<? extends IFreeMarkerWrapper> structs, String enclosingScopeName, File location, IProgressMonitor progressMonitor) {
        if (model.isForPDF() || !model.getBitfieldDiagram()) {
            return Collections.emptyList();
        }
        if (structs.stream().filter(struct -> ((IStructWrapper)struct).hasBitField()).count() < 20L) {
            return Collections.emptyList();
        }
        location.mkdirs();
        LinkedList<String> results = new LinkedList<String>();
        int i = 0;
        while (i < structs.size()) {
            SimpleHash root = FreeMarkerFileGenerator.createDataModel();
            int toIndex = i + 20 > structs.size() ? structs.size() : i + 20;
            root.put("structs", structs.subList(i, toIndex));
            root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
            root.put("format", (Object)model.getOutputFormat().toString());
            String fileName = SpecadorConstants.getMessage(SpecadorConstants.rstFile, "structs_of_" + enclosingScopeName + "_" + i / 20);
            FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-structs"), new File(location, fileName), root, SpecadorProgressMonitor.SpecadorLanguageKind.VLOG.getName(), progressMonitor, 0);
            results.add(fileName);
            i += 20;
        }
        return results;
    }

    private static boolean generateLibraryVHDL(SpecadorModel model, ILibraryWrapper lib, File rootLocation, Map<String, String> diagrams, IProgressMonitor progressMonitor, boolean mixedLibraries, boolean showTitle) {
        if (!model.getVhdlSelectedLibraryNames().contains(lib.getName())) {
            return false;
        }
        File location = new File(rootLocation, lib.getFileName());
        File diagramsLocation = new File(location, "diagrams");
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)lib.getFormatedName());
        root.put("unformatedname", (Object)lib.getName());
        root.put("id", (Object)lib.getID());
        if (mixedLibraries) {
            root.put("language", (Object)"VHDL");
        }
        root.put("showTitle", showTitle);
        List<IEntityWrapper> entities = lib.getEntities(model);
        List<IPackageWrapper> packages = lib.getPackages(model);
        if (entities.isEmpty() && packages.isEmpty()) {
            return false;
        }
        location.mkdirs();
        entities.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        packages.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        entities.stream().forEach(e -> SpecadorGenerator.generateEntity(model, e, location, diagrams, diagramsLocation, progressMonitor, false));
        root.put("entities", entities);
        packages.stream().forEach(p -> SpecadorGenerator.generatePackageVHDL(model, p, location, progressMonitor));
        root.put("packages", packages);
        FreeMarkerFileGenerator.generateFile(model, "library.rst.ftl", new File(location, String.valueOf(lib.getFileName()) + ".rst"), root, SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), progressMonitor, 1);
        return true;
    }

    private static void generateEntity(SpecadorModel model, IEntityWrapper adapter, File location, Map<String, String> diagrams, File diagramsLocation, IProgressMonitor progressMonitor, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML) && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("comment", adapter.getComment());
        root.put("commentLine", (Object)adapter.getCommentLine());
        root.put("declarationLine", (Object)adapter.getDeclarationLine());
        root.put("id", (Object)adapter.getID());
        root.put("isPreview", isPreview);
        List<IArchitectureWrapper> architectures = adapter.getArchitectures(SpecadorGenerator.getDesignTops(model.getProject(), model));
        architectures.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        if (!isPreview) {
            architectures.stream().forEach(architecture -> SpecadorGenerator.generateArchitecture(model, architecture, location, diagrams, progressMonitor, false));
        }
        root.put("architectures", architectures);
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        root.put("configurations", adapter.getConfigurations());
        root.put("generics", adapter.getGenerics());
        root.put("ports", adapter.getPorts());
        root.put("types", adapter.getTypes());
        root.put("functions", adapter.getFunctions());
        root.put("procedures", adapter.getProcedures());
        boolean hasBlockDiagram = model.getDesignBlockDiagram() && adapter.generateBlockDiagram(diagramsLocation, progressMonitor);
        root.put("hasBlockDiagram", hasBlockDiagram);
        if (hasBlockDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-block", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Block", adapter.getName()));
        }
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "entity"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, adapter.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), progressMonitor, 1);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, location);
    }

    private static void generateArchitecture(SpecadorModel model, IArchitectureWrapper adapter, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, boolean isPreview) {
        String architectureFullName = String.valueOf(adapter.getEntityName()) + "." + adapter.getName();
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        File architectureLocation = new File(location, adapter.getEntityName());
        architectureLocation.mkdirs();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML) && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("comment", adapter.getComment());
        root.put("entityName", (Object)adapter.getEntityName());
        root.put("entityID", (Object)adapter.getEntityID());
        root.put("libraryName", (Object)adapter.getLibraryName());
        root.put("declarationLine", (Object)adapter.getDeclarationLine());
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        root.put("id", (Object)adapter.getID());
        root.put("isPreview", isPreview);
        root.put("types", adapter.getTypes());
        root.put("functions", adapter.getFunctions());
        root.put("procedures", adapter.getProcedures());
        List<IAlwaysBlockWrapper> processes = adapter.getProcesses();
        for (IAlwaysBlockWrapper process : processes) {
            if (!process.containsFSMDiagram()) continue;
            diagrams.put(String.valueOf(adapter.getID()) + "-fsm-" + process.getFSMDiagramVariableName(), SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "FSM", String.valueOf(architectureFullName) + "." + process.getFSMDiagramVariableName()));
        }
        root.put("processes", processes);
        File diagramsLocation = new File(isPreview ? location : architectureLocation, "diagrams");
        List<IComponentWrapper> components = adapter.getComponents();
        components.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        if (!isPreview) {
            components.stream().forEach(component -> SpecadorGenerator.generateComponent(model, component, location, progressMonitor, false));
        }
        root.put("components", components);
        List<IRfDesignElement> topDesigns = SpecadorGenerator.getDesignTops(model.getProject(), model);
        root.put("instances", topDesigns.isEmpty() ? Collections.emptyMap() : adapter.getInstances(topDesigns));
        root.put("submodules", topDesigns.isEmpty() ? Collections.emptyMap() : adapter.getSubInstances());
        root.put("isDesignTop", !topDesigns.isEmpty() && topDesigns.contains(adapter.getNamedElement()));
        if (model.getFSMDiagrams()) {
            adapter.generateFSMDiagrams(diagramsLocation, progressMonitor);
        }
        boolean hasSchematicDiagram = adapter.generateSchematicDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        boolean hasSubInstancesDiagram = adapter.generateSubInstancesDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        boolean hasFlowDiagram = !topDesigns.isEmpty() && adapter.generateFlowDiagram(diagramsLocation, progressMonitor, model.getDesignDiagramsFiltersSet());
        root.put("hasSchematicDiagram", hasSchematicDiagram);
        root.put("hasFlowDiagram", hasFlowDiagram);
        root.put("hasSubInstancesDiagram", hasSubInstancesDiagram);
        if (hasSchematicDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-schematic", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Schematic", architectureFullName));
        }
        if (hasFlowDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-flow", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Flow", architectureFullName));
        }
        if (hasSubInstancesDiagram) {
            diagrams.put(String.valueOf(adapter.getID()) + "-subinstances", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "Sub-Instances", architectureFullName));
        }
        FreeMarkerFileGenerator.generateFile(model, "architecture.rst.ftl", new File(isPreview ? location : architectureLocation, String.valueOf(adapter.getName()) + ".rst"), root, SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), progressMonitor);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, architectureLocation);
    }

    private static void generatePackageVHDL(SpecadorModel model, IPackageWrapper adapter, File location, IProgressMonitor progressMonitor) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML) && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("id", (Object)adapter.getID());
        root.put("comment", adapter.getComment());
        root.put("commentTitle", (Object)"");
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        root.put("declarationLine", (Object)adapter.getDeclarationLine());
        root.put("constants", adapter.getConstants());
        root.put("types", adapter.getTypes());
        root.put("functions", adapter.getFunctions());
        root.put("procedures", adapter.getProcedures());
        List<IComponentWrapper> components = adapter.getComponents();
        components.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        components.stream().forEach(component -> SpecadorGenerator.generateComponent(model, component, location, progressMonitor, false));
        root.put("components", components);
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "package"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, adapter.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), progressMonitor, 1);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, location);
    }

    private static void generateComponent(SpecadorModel model, IComponentWrapper adapter, File location, IProgressMonitor progressMonitor, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        File componentLocation = isPreview ? location : new File(location, adapter.getEnclosingScope());
        componentLocation.mkdirs();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("hasCode", model.getOutputFormat().equals((Object)SpecadorModel.OutputFormat.HTML) && model.getExportSourceCode());
        root.put("unformatedname", (Object)adapter.getName());
        root.put("name", (Object)adapter.getFormatedName());
        root.put("comment", adapter.getComment());
        root.put("id", (Object)adapter.getID());
        root.put("declaration", (Object)adapter.getDeclarationLocation());
        root.put("declarationLine", (Object)adapter.getDeclarationLine());
        root.put("generics", adapter.getGenerics());
        root.put("ports", adapter.getPorts());
        File diagramsLocation = new File(componentLocation, "diagrams");
        if (model.getDesignBlockDiagram()) {
            diagramsLocation.mkdirs();
        }
        root.put("hasBlockDiagram", model.getDesignBlockDiagram() && adapter.generateBlockDiagram(diagramsLocation, progressMonitor));
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "component"), new File(componentLocation, SpecadorConstants.getMessage(SpecadorConstants.rstFile, adapter.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.VHDL.getName(), progressMonitor);
        SpecadorGenerator.generateCode(model, adapter, progressMonitor, componentLocation);
    }

    private static boolean generatePackageELang(SpecadorModel model, IPackageWrapper pkg, File rootLocation, Map<String, String> diagrams, IProgressMonitor progressMonitor) {
        List<IFreeMarkerWrapper> sequences;
        List<IFreeMarkerWrapper> units;
        File location = new File(rootLocation, pkg.getName());
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)pkg.getFormatedName());
        root.put("fullName", (Object)pkg.getName());
        root.put("unformatedname", (Object)pkg.getName());
        root.put("id", (Object)pkg.getID());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        List<IFreeMarkerWrapper> structs = pkg.getStructs();
        if (!structs.isEmpty()) {
            location.mkdirs();
            structs.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, (IUnitWrapper)unit, location, diagrams, progressMonitor, "Struct"));
            structs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("structures", structs);
        }
        if (!(units = pkg.getUnits()).isEmpty()) {
            location.mkdirs();
            units.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, (IUnitWrapper)unit, location, diagrams, progressMonitor, "Unit"));
            units.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("units", units);
        }
        if (!(sequences = pkg.getSequences()).isEmpty()) {
            location.mkdirs();
            sequences.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, (IUnitWrapper)unit, location, diagrams, progressMonitor, "Sequence"));
            sequences.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("sequences", sequences);
        }
        List<IFreeMarkerWrapper> scalars = pkg.getScalars();
        scalars.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("scalars", scalars);
        if (!(structs.isEmpty() && units.isEmpty() && sequences.isEmpty() && scalars.isEmpty())) {
            location.mkdirs();
            FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "package"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, pkg.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), progressMonitor, 0);
            return true;
        }
        return false;
    }

    private static void generateUnit(SpecadorModel model, IUnitWrapper unit, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, String type) {
        SpecadorGenerator.generateUnit(model, unit, location, diagrams, progressMonitor, type, 1, false);
    }

    private static void generateUnit(SpecadorModel model, IUnitWrapper unit, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, String type, int work) {
        SpecadorGenerator.generateUnit(model, unit, location, diagrams, progressMonitor, type, work, false);
    }

    private static void generateUnit(SpecadorModel model, IUnitWrapper unit, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, String type, boolean isPreview) {
        SpecadorGenerator.generateUnit(model, unit, location, diagrams, progressMonitor, type, 1, isPreview);
    }

    private static void generateUnit(SpecadorModel model, IUnitWrapper unit, File location, Map<String, String> diagrams, IProgressMonitor progressMonitor, String type, int work, boolean isPreview) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("type", (Object)type);
        root.put("name", (Object)unit.getFormatedName());
        root.put("unformatedname", (Object)unit.getName());
        root.put("id", (Object)unit.getID());
        root.put("declaration", (Object)unit.getDeclarationLocation());
        root.put("line", (Object)unit.getDeclarationLine());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        root.put("comment", unit.getComment());
        root.put("commentLine", (Object)unit.getCommentLine());
        root.put("subtypes", unit.getSubtypes());
        root.put("fields", unit.getFields());
        root.put("ports", unit.getPorts());
        root.put("checks", unit.getChecks());
        root.put("structHierarchy", unit.getStructHierarchy(isPreview));
        root.put("isPreview", isPreview);
        List<IFreeMarkerWrapper> methods = unit.getMethods();
        root.put("methods", methods);
        if (!isPreview) {
            methods.stream().forEach(method -> SpecadorGenerator.generateCode(model, method, progressMonitor, location));
        }
        root.put("extendedMethods", unit.getExtendedMethods());
        List<IFreeMarkerWrapper> TCMs = unit.getTCMs();
        root.put("TCMs", TCMs);
        if (!isPreview) {
            TCMs.stream().forEach(method -> SpecadorGenerator.generateCode(model, method, progressMonitor, location));
        }
        root.put("extendedTCMs", unit.getExtendedTCMs());
        List<IFreeMarkerWrapper> events = unit.getEvents();
        root.put("events", events);
        if (!isPreview) {
            events.stream().forEach(event -> SpecadorGenerator.generateCode(model, event, progressMonitor, location));
        }
        root.put("extendedEvents", unit.getExtendedEvents());
        File diagramsLocation = new File(location, "diagrams");
        boolean hasUMLDiagram = unit.generateUMLInheritanceDiagram(diagramsLocation, progressMonitor);
        root.put("hasUMLDiagram", hasUMLDiagram);
        boolean hasUMLCollaborationDiagram = unit.generateUMLCollaborationDiagram(diagramsLocation, progressMonitor);
        root.put("hasUMLCollaborationDiagram", hasUMLCollaborationDiagram);
        if (hasUMLCollaborationDiagram) {
            diagrams.put(String.valueOf(unit.getID()) + "-collaboration", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "UML Collaboration", unit.getName()));
        }
        if (hasUMLDiagram) {
            diagrams.put(String.valueOf(unit.getID()) + "-uml", SpecadorConstants.getMessage(SpecadorConstants.diagramOf, "UML Inheritance", unit.getName()));
        }
        File unitFileLocation = new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, unit.getName()));
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "unit"), unitFileLocation, root, SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), progressMonitor, work);
        SpecadorGenerator.generateCode(model, unit, progressMonitor, location);
    }

    private static boolean generateIndexTests(SpecadorModel model, IProject project, File location, Map<String, String> diagrams, IProgressMonitor monitor) {
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        List<ITestWrapper> tests = LanguageContributor.get(LanguageKind.E).getTests(project);
        if (tests.isEmpty()) {
            return false;
        }
        location.mkdirs();
        tests.stream().forEach(m -> SpecadorGenerator.generateTest(model, m, new File(location, m.getName()), diagrams, monitor));
        tests.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("title", (Object)"Tests");
        root.put("elements", tests.stream().map(element -> String.valueOf(element.getName()) + File.separator + element.getName()).collect(Collectors.toList()));
        FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "index-elements"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, "index-tests")), root, SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), monitor);
        return true;
    }

    private static void generateTest(SpecadorModel model, ITestWrapper test, File location, Map<String, String> diagrams, IProgressMonitor monitor) {
        List<IUnitWrapper> sequences;
        List<IUnitWrapper> units;
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("format", (Object)model.getOutputFormat().toString());
        root.put("name", (Object)test.getFormatedName());
        root.put("unformatedname", (Object)test.getName());
        root.put("id", (Object)test.getID());
        root.put("declaration", (Object)test.getDeclarationLocation());
        root.put("line", (Object)test.getDeclarationLine());
        root.put("hasCode", !model.isForPDF() && model.getExportSourceCode());
        root.put("comment", test.getComment());
        List<? extends IFreeMarkerWrapper> subtypes = test.getSubtypes();
        root.put("subtypes", subtypes);
        List<IUnitWrapper> structs = test.getStructs();
        if (!structs.isEmpty()) {
            location.mkdirs();
            structs.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, unit, location, diagrams, monitor, "Struct", 0));
            structs.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("structures", structs);
        }
        if (!(units = test.getUnits()).isEmpty()) {
            location.mkdirs();
            units.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, unit, location, diagrams, monitor, "Unit", 0));
            units.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("units", units);
        }
        if (!(sequences = test.getSequences()).isEmpty()) {
            location.mkdirs();
            sequences.stream().forEach(unit -> SpecadorGenerator.generateUnit(model, unit, location, diagrams, monitor, "Sequence", 0));
            sequences.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
            root.put("sequences", sequences);
        }
        List<IFreeMarkerWrapper> scalars = test.getScalars();
        scalars.sort(SpecadorConstants.ALPHABETIC_COMPARATOR);
        root.put("scalars", scalars);
        if (!(subtypes.isEmpty() && structs.isEmpty() && units.isEmpty() && sequences.isEmpty() && scalars.isEmpty())) {
            location.mkdirs();
            FreeMarkerFileGenerator.generateFile(model, SpecadorConstants.getMessage(SpecadorConstants.templateFile, "test"), new File(location, SpecadorConstants.getMessage(SpecadorConstants.rstFile, test.getName())), root, SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), monitor, 1);
            SpecadorGenerator.generateCode(model, test, monitor, location);
        }
    }

    private static void generateCode(SpecadorModel model, IFreeMarkerWrapper adapter, IProgressMonitor progressMonitor, File location) {
        if (model.isForPDF() || !model.getExportSourceCode()) {
            return;
        }
        File file = SpecadorGenerator.createCodeLocation(model, adapter, location);
        if (file.exists()) {
            return;
        }
        SimpleHash root = FreeMarkerFileGenerator.createDataModel();
        root.put("title", (Object)adapter.getName());
        root.put("kind", (Object)adapter.getLanguageKind());
        File sourceLocation = new File(model.getLocation(), "source");
        Path staticCodePath = SpecadorGenerator.getRelativePathToHTMLGeneratedCodeFolder(model, location);
        root.put("content", (Object)adapter.createFileReferenceContent(staticCodePath.toFile()));
        root.put("staticPath", (Object)staticCodePath.relativize(sourceLocation.toPath().resolve("_static")));
        FreeMarkerFileGenerator.generateFile(model, "code.ftl", file, root, SpecadorProgressMonitor.SpecadorLanguageKind.MISC.getName(), progressMonitor, -1);
    }

    private static Path getRelativePathToHTMLGeneratedCodeFolder(SpecadorModel model, File location) {
        File sourceLocation = new File(model.getLocation(), "source");
        Path relativePath = sourceLocation.toPath().relativize(location.toPath());
        return sourceLocation.toPath().resolve(relativePath).resolve("code");
    }

    private static File createCodeLocation(SpecadorModel model, IFreeMarkerWrapper adapter, File location) {
        String toBeGeneratedHTMLFileName = String.valueOf(adapter.getDeclarationLocation()) + ".html";
        File sourceLocation = new File(model.getLocation(), "source");
        Path relativePath = sourceLocation.toPath().relativize(location.toPath());
        File codeLocation = sourceLocation.toPath().resolve("extern").resolve(relativePath).resolve("code").toFile();
        codeLocation.mkdirs();
        return new File(codeLocation, toBeGeneratedHTMLFileName);
    }

    private static void extractSourcesFromJarTo(SpecadorModel model, File targetDir) {
        try {
            Path sourceDir = Files.createTempDirectory("specador_docs", new FileAttribute[0]);
            JarUtils.extractDirectory("/resources/specador_docs", SpecadorGenerator.class, true, sourceDir.toFile().getAbsolutePath(), true);
            if (model.isPreviewMode()) {
                JarUtils.extractFile("/resources/marked/marked.dvt.rhino.js", SpecadorGenerator.class, sourceDir.toFile().getAbsolutePath(), false);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> fileWalker = Files.walk(sourceDir, new FileVisitOption[0]);){
                fileWalker.forEach(sourceFile -> {
                    try {
                        if (sourceFile.getFileName().toString().equals("Makefile") && DVTProfilingUtils.isWinOS()) {
                            return;
                        }
                        if (sourceFile.getFileName().toString().equals("make.bat") && !DVTProfilingUtils.isWinOS()) {
                            return;
                        }
                        Path targetFile = targetDir.toPath().resolve(sourceDir.relativize((Path)sourceFile));
                        if (sourceFile.toFile().isDirectory()) {
                            Files.createDirectories(targetFile, new FileAttribute[0]);
                        } else {
                            boolean isImageFile;
                            boolean targetFileExists = targetFile.toFile().exists();
                            boolean bl = isImageFile = sourceFile.toString().endsWith(".png") || sourceFile.toString().endsWith(".svg");
                            if (isImageFile) {
                                if (!targetFileExists) {
                                    byte[] originalBytes = Files.readAllBytes(sourceFile);
                                    Files.write(targetFile, originalBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                                }
                            } else {
                                String originalContent = FileUtils.readFileToString((File)sourceFile.toFile());
                                if ("specador.js".equals(sourceFile.getFileName().toString())) {
                                    LocalDate currentDate = LocalDate.now();
                                    DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("MMMM dd, yyyy");
                                    originalContent = GENERATED_DATE.matcher(originalContent).replaceFirst(GENERATED_DATE + currentDate.format(dateFormat));
                                }
                                if (!targetFileExists || originalContent.length() > 0 && !originalContent.equals(FileUtils.readFileToString((File)targetFile.toFile()))) {
                                    Files.write(targetFile, originalContent.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        SpecadorManager.INSTANCE.logError(model.getProject(), e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            FileUtils.cleanDirectory((File)sourceDir.toFile());
            FileUtils.deleteDirectory((File)sourceDir.toFile());
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
        }
    }

    private static void copyCustomStylingFiles(SpecadorModel model, File rstFilesLocation) {
        File staticDirectory = new File(rstFilesLocation, "source/_static");
        SpecadorGenerator.copyCustomFile(model, model.getCustomCssFile(), staticDirectory, "custom.css");
        SpecadorGenerator.copyCustomFile(model, model.getCustomJsFile(), staticDirectory, "custom.js");
    }

    private static void copyCustomFile(SpecadorModel model, String customFilePath, File destination, String fileName) {
        if (customFilePath == null || customFilePath.isEmpty()) {
            return;
        }
        File customFile = new File(customFilePath);
        if (!customFile.exists() && !(customFile = model.getProject().getLocation().toFile().toPath().resolve(customFilePath).toFile()).exists()) {
            return;
        }
        try {
            Files.copy(customFile.toPath(), destination.toPath().resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            SpecadorManager.INSTANCE.logError(model.getProject(), e);
        }
    }

    private static int getNumberOfFilesToDocument(SpecadorModel model) {
        List libraries;
        int totalWork = 0;
        if (model.hasVlogNature() && model.isExportVlogLibraries()) {
            libraries = LanguageContributor.get(LanguageKind.VLOG).getLibraries(model).stream().filter(lib -> model.getVlogSelectedLibraryNames().contains(lib.getName())).collect(Collectors.toList());
            totalWork += libraries.size();
            if (LanguageContributor.get(LanguageKind.VHDL).getLibraries(model).isEmpty() && libraries.size() == 1) {
                --totalWork;
            }
            for (ILibraryWrapper lib2 : libraries) {
                List<IModuleWrapper> modules = lib2.getModules(model);
                totalWork += modules.size();
                totalWork += modules.stream().mapToInt(m -> m.getNumberOfClasses()).sum();
                totalWork += lib2.getInterfaces(model).size();
                totalWork += lib2.getPackages(model).stream().mapToInt(p -> p.getNumberOfClasses()).sum();
                totalWork += lib2.getClasses().stream().mapToInt(c -> c.getNumberOfClasses()).sum();
            }
        }
        if (model.hasVhdlNature() && model.isExportVhdlLibraries()) {
            libraries = LanguageContributor.get(LanguageKind.VHDL).getLibraries(model).stream().filter(lib -> model.getVhdlSelectedLibraryNames().contains(lib.getName())).collect(Collectors.toList());
            totalWork += libraries.size();
            totalWork += libraries.stream().mapToInt(lib -> lib.getEntities(model).size()).sum();
            totalWork += libraries.stream().mapToInt(lib -> lib.getPackages(model).size()).sum();
        }
        if (model.hasEdtNature()) {
            if (model.isExportEdtPackages()) {
                List packages = LanguageContributor.get(LanguageKind.E).getPackages(model).stream().filter(pkg -> model.getEdtSelectedPackageNames().contains(pkg.getName())).collect(Collectors.toList());
                totalWork += packages.stream().mapToInt(p -> p.getNumberOfClasses()).sum();
            }
            if (model.isExportEdtTests()) {
                totalWork += LanguageContributor.get(LanguageKind.E).getTests(model.getProject()).size();
            }
        }
        return totalWork;
    }
}

