/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.statistics.Metric;

public class RelevantInfo {
    public int counter;
    String peekElementName;
    int peekCounter;

    public RelevantInfo(String elementName) {
        this.peekElementName = elementName;
    }

    public boolean update(RelevantInfo other) {
        this.counter += other.counter;
        if (other.counter <= this.peekCounter) {
            return false;
        }
        this.peekCounter = other.counter;
        this.peekElementName = other.peekElementName;
        return true;
    }

    public List<Metric> getMetrics(String title, int counter) {
        ArrayList<Metric> result = new ArrayList<Metric>();
        result.add(new Metric.LongMetric("Average " + title, Math.round((float)this.counter / (float)counter)));
        result.add(new Metric.LongMetric("Max " + title, this.peekCounter));
        result.add(new Metric.StringMetric("Max " + title + " Name", this.peekElementName));
        return result;
    }
}

