/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.io.File;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.StatisticsPreferenceModel;
import ro.amiq.dvt.statistics.StatisticsPreferenceParser;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTFileUtils;

public class StatisticsPreferenceDialog
extends TrayDialog {
    private Text fPathsText;
    private Button fInsertFileButton;
    private Button fInsertDirectoryButton;
    private Button fCollectSystemInfo;
    private Button fCollectMacroExpansionInfo;
    private Button fFullBuild;
    private Text fMessageLabel;
    private File fPrefFile;
    private StatisticsPreferenceModel fSpm;
    private String fNature;

    public StatisticsPreferenceDialog(Shell parentShell, File prefFile, String nature) {
        block8: {
            super(parentShell);
            this.fPrefFile = prefFile;
            this.fNature = nature;
            try {
                try {
                    StatisticsPreferenceParser parser = StatisticsPreferenceParser.newParser(prefFile, true);
                    this.fSpm = parser.load();
                }
                catch (Exception exception) {
                    if (this.fSpm == null) {
                        this.fSpm = new StatisticsPreferenceModel();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.fSpm == null) {
                    this.fSpm = new StatisticsPreferenceModel();
                }
                throw throwable;
            }
            if (this.fSpm == null) {
                this.fSpm = new StatisticsPreferenceModel();
            }
        }
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Collect Project Statistics");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ancestor = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(ancestor, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 500;
        layoutData.widthHint = 630;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout());
        this.createHeaderArea(composite);
        this.createMainArea(composite);
        this.createMessageArea(composite);
        this.loadFromModel();
        this.addListeners();
        return ancestor;
    }

    private void loadFromModel() {
        String strings = "";
        for (String s : this.fSpm.getStrings()) {
            strings = String.valueOf(strings) + s + "\n";
        }
        this.fPathsText.setText(strings);
        this.fCollectMacroExpansionInfo.setSelection(this.fSpm.isCollectMacroExpansionInfo());
        this.fCollectSystemInfo.setSelection(this.fSpm.isCollectSystemInfo());
        this.fFullBuild.setSelection(this.fSpm.isPerformFullBuild());
    }

    private void addListeners() {
        this.fInsertFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(StatisticsPreferenceDialog.this.getShell());
                dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                StatisticsPreferenceDialog.this.fPathsText.append(String.valueOf(path) + "\n");
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fInsertDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(StatisticsPreferenceDialog.this.getShell());
                dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
                String path = dialog.open();
                if (path == null || path.length() == 0) {
                    return;
                }
                StatisticsPreferenceDialog.this.fPathsText.append(String.valueOf(path) + "\n");
                DVTFileUtils.getInstance().setLastDirectory(path);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fPathsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] lines;
                StatisticsPreferenceDialog.this.fSpm.clear();
                String content = StatisticsPreferenceDialog.this.fPathsText.getText();
                String[] stringArray = lines = content.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.trim().length() > 0) {
                        StatisticsPreferenceDialog.this.fSpm.addPath(line.trim());
                    }
                    ++n2;
                }
                StatisticsPreferenceDialog.this.update();
            }
        });
    }

    private void update() {
        this.fMessageLabel.setText(this.fSpm.validate());
        if ("".equals(this.fSpm.validate())) {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fMessageLabel, DVTColorUtil.INSTANCE.getDefaultBackground((Control)this.fMessageLabel.getParent()));
            this.getButton(0).setEnabled(true);
        } else {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fMessageLabel, PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
            this.getButton(0).setEnabled(false);
        }
    }

    protected void okPressed() {
        if (!"".equals(this.fSpm.validate())) {
            return;
        }
        this.fSpm.setCollectSystemInfo(this.fCollectSystemInfo.getSelection());
        this.fSpm.setCollectMacroExpansionInfo(this.fCollectMacroExpansionInfo.getSelection());
        this.fSpm.setPerformFullBuild(this.fFullBuild.getSelection());
        this.save();
        super.okPressed();
    }

    private void save() {
        try {
            StatisticsPreferenceParser parser = StatisticsPreferenceParser.newParser(this.fPrefFile, true);
            parser.save(this.fSpm);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void createHeaderArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Specify a list of files or directories you want to exclude from\nstatistics collection (Path filters). You can also use system variables.\n");
    }

    private void createMessageArea(Composite composite) {
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setLayout((Layout)new FillLayout());
        this.fMessageLabel = new Text(group, 8);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fMessageLabel, DVTColorUtil.INSTANCE.getBackground((Control)this.fMessageLabel.getParent()));
    }

    private void createMainArea(Composite parent) {
        this.createFiltersGroup(parent);
        this.createGeneralPreferencesArea(parent);
    }

    private void createGeneralPreferencesArea(Composite composite) {
        this.fCollectSystemInfo = new Button(composite, 32);
        this.fCollectSystemInfo.setText("Collect system information (OS, CPU, memory, load)");
        this.fCollectSystemInfo.setSelection(true);
        this.fCollectMacroExpansionInfo = new Button(composite, 32);
        this.fCollectMacroExpansionInfo.setText("Collect macro expansion statistics");
        this.fCollectMacroExpansionInfo.setSelection(true);
        this.fFullBuild = new Button(composite, 32);
        this.fFullBuild.setText("Perform a full build before collecting info");
        this.fFullBuild.setSelection(true);
    }

    private void createFiltersGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Path filters");
        this.fInsertFileButton = new Button((Composite)group, 8);
        this.fInsertFileButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fInsertFileButton.setText("Insert File...");
        this.fInsertDirectoryButton = new Button((Composite)group, 8);
        this.fInsertDirectoryButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fInsertDirectoryButton.setText("Insert Directory...");
        this.fPathsText = new Text((Composite)group, 2818);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 300;
        this.fPathsText.setLayoutData((Object)gridData);
    }
}

