/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class StatisticsPreferenceModel {
    private Map<String, File> fStrings = new HashMap<String, File>();
    private boolean fCollectSystemInfo = true;
    private boolean fCollectMacroExpansionInfo = false;
    private boolean fPerformFullBuild = true;

    public Set<String> getStrings() {
        return this.fStrings.keySet();
    }

    public void addPath(String s) {
        String replaced = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(s);
        if (replaced == null) {
            this.fStrings.put(s, null);
        } else {
            this.fStrings.put(s, new File(replaced));
        }
    }

    public String validate() {
        for (Map.Entry<String, File> entry : this.fStrings.entrySet()) {
            String s = entry.getKey();
            File file = entry.getValue();
            if (file == null) {
                return "'" + s + "' contains invalid system variables!";
            }
            if (file.exists()) continue;
            return "'" + file + "' does not exist!";
        }
        return "";
    }

    public Set<String> getNonValidFilteredPaths() {
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry<String, File> entry : this.fStrings.entrySet()) {
            String s = entry.getKey();
            File file = entry.getValue();
            if (file == null) {
                res.add(s);
                continue;
            }
            if (file.exists()) continue;
            res.add(file.getPath());
        }
        return res;
    }

    public void clear() {
        this.fStrings.clear();
    }

    public boolean isFiltered(String path) {
        IPath p = Path.fromOSString((String)path);
        for (File f2 : this.fStrings.values()) {
            if (!Path.fromOSString((String)f2.getAbsolutePath()).isPrefixOf(p)) continue;
            return true;
        }
        return false;
    }

    public void setCollectSystemInfo(boolean state) {
        this.fCollectSystemInfo = state;
    }

    public void setCollectMacroExpansionInfo(boolean state) {
        this.fCollectMacroExpansionInfo = state;
    }

    public void setPerformFullBuild(boolean state) {
        this.fPerformFullBuild = state;
    }

    public boolean isCollectSystemInfo() {
        return this.fCollectSystemInfo;
    }

    public boolean isCollectMacroExpansionInfo() {
        return this.fCollectMacroExpansionInfo;
    }

    public boolean isPerformFullBuild() {
        return this.fPerformFullBuild;
    }
}

