/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.statistics.StatisticsPreferenceModel;
import ro.amiq.dvt.statistics.StatisticsPreferenceParser1;
import ro.amiq.dvt.utils.XMLErrorHandler;

public abstract class StatisticsPreferenceParser {
    private final File fFile;
    private static final String LAST_VERSION = "1";

    protected StatisticsPreferenceParser(File file) {
        this.fFile = file;
    }

    public abstract void save(StatisticsPreferenceModel var1) throws Exception;

    public abstract StatisticsPreferenceModel load() throws Exception;

    public File getFile() {
        return this.fFile;
    }

    public static StatisticsPreferenceParser newParser(File file, boolean useLastVersion) throws Exception {
        if (useLastVersion) {
            return StatisticsPreferenceParser.newParser(file, LAST_VERSION);
        }
        String version = StatisticsPreferenceParser.detectVersion(file);
        return StatisticsPreferenceParser.newParser(file, version);
    }

    private static StatisticsPreferenceParser newParser(File file, String version) throws Exception {
        if (LAST_VERSION.equals(version)) {
            return new StatisticsPreferenceParser1(file);
        }
        throw new IllegalArgumentException("Unknown waivers file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName("waivers");
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute("version");
    }
}

