/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.statistics.StatisticsPreferenceModel;
import ro.amiq.dvt.statistics.StatisticsPreferenceParser;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class StatisticsPreferenceParser1
extends StatisticsPreferenceParser {
    public static final String VERSION_ID = "1";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_PROJ_STAT = "proj_stat";
    private static final String TAG_PATH = "path";
    private static final String TAG_PREF = "pref";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String COLLECT_SYSTEM_INFO = "collectSystemInfo";
    private static final String COLLECT_MACRO_EXPANSION_INFO = "collectMacroExpansionInfo";
    private static final String PERFORM_FULL_BUILD = "performFullBuild";

    public StatisticsPreferenceParser1(File file) {
        super(file);
    }

    @Override
    public void save(StatisticsPreferenceModel spm) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_PROJ_STAT);
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        this.appendPreferenceNodes(spm, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendPreferenceNodes(StatisticsPreferenceModel spm, Element root, Document document) {
        for (String s : spm.getStrings()) {
            Element elem = document.createElement(TAG_PATH);
            root.appendChild(elem);
            elem.setTextContent(s);
        }
        Element sysInfoElem = document.createElement(TAG_PREF);
        sysInfoElem.setAttribute(ATTR_KEY, COLLECT_SYSTEM_INFO);
        sysInfoElem.setAttribute(ATTR_VALUE, Boolean.toString(spm.isCollectSystemInfo()));
        root.appendChild(sysInfoElem);
        Element macroInfoElem = document.createElement(TAG_PREF);
        macroInfoElem.setAttribute(ATTR_KEY, COLLECT_MACRO_EXPANSION_INFO);
        macroInfoElem.setAttribute(ATTR_VALUE, Boolean.toString(spm.isCollectMacroExpansionInfo()));
        root.appendChild(macroInfoElem);
        Element performFullBuild = document.createElement(TAG_PREF);
        performFullBuild.setAttribute(ATTR_KEY, PERFORM_FULL_BUILD);
        performFullBuild.setAttribute(ATTR_VALUE, Boolean.toString(spm.isPerformFullBuild()));
        root.appendChild(performFullBuild);
    }

    @Override
    public StatisticsPreferenceModel load() throws Exception {
        StatisticsPreferenceModel spm = new StatisticsPreferenceModel();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        Element elem = null;
        NodeList pathNodes = document.getElementsByTagName(TAG_PATH);
        int i = 0;
        while (i < pathNodes.getLength()) {
            elem = (Element)pathNodes.item(i);
            spm.addPath(elem.getTextContent());
            ++i;
        }
        NodeList prefNodes = document.getElementsByTagName(TAG_PREF);
        int i2 = 0;
        while (i2 < prefNodes.getLength()) {
            elem = (Element)prefNodes.item(i2);
            String key = elem.getAttribute(ATTR_KEY);
            String value = elem.getAttribute(ATTR_VALUE);
            if (COLLECT_MACRO_EXPANSION_INFO.equals(key)) {
                spm.setCollectMacroExpansionInfo(Boolean.parseBoolean(value));
            } else if (COLLECT_SYSTEM_INFO.equals(key)) {
                spm.setCollectSystemInfo(Boolean.parseBoolean(value));
            } else if (PERFORM_FULL_BUILD.equals(key)) {
                spm.setPerformFullBuild(Boolean.parseBoolean(value));
            }
            ++i2;
        }
        return spm;
    }
}

