/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.statistics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.StatisticsPreferenceModel;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.MemUtils;

public abstract class StatisticsUtilProviderBase {
    protected static final String UNKNOWN_METRIC_VALUE = "N/A";
    protected static final String LINE_SERPARATOR = System.getProperty("line.separator");
    protected StatisticsPreferenceModel fSpm;
    protected IProgressMonitor fProgressMonitor;
    private ArrayList<Metric> fMetrics;

    public void createAndAddMetrics(Info info) {
        this.fMetrics.addAll(info.getMetrics());
    }

    public void createAndAddMetric(String name, long value) {
        this.fMetrics.add(new Metric.LongMetric(name, value));
    }

    public void createAndAddMetric(String name, String value) {
        this.fMetrics.add(new Metric.StringMetric(name, value));
    }

    public void createAndAddMetric(String name) {
        this.fMetrics.add(new Metric.SimpleMetric(name));
    }

    public void addMetrics(ArrayList<Metric> addMetrics) {
        if (addMetrics != null) {
            this.fMetrics.addAll(addMetrics);
        }
    }

    public void addSeparator() {
        this.fMetrics.add(new Metric.SeparatorMetric());
    }

    public void init() {
        this.fMetrics = new ArrayList();
    }

    public void clean() {
        this.fMetrics = null;
    }

    private static String convertToHeading(String text) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(text) + LINE_SERPARATOR);
        int i = 0;
        while (i < text.length()) {
            result.append('=');
            ++i;
        }
        return result.toString();
    }

    public static String getCommonStatistics(IProject project, StatisticsPreferenceModel spm) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(StatisticsUtilProviderBase.convertToHeading("General statistics")) + LINE_SERPARATOR + LINE_SERPARATOR);
        result.append("Project name : \"" + project.getName() + "\"" + LINE_SERPARATOR);
        if (spm.isCollectSystemInfo()) {
            result.append("OS information : " + DVTProfilingUtils.sysInfo() + LINE_SERPARATOR);
            result.append("CPU information : " + DVTProfilingUtils.cpuInfo() + LINE_SERPARATOR);
            result.append("Memory information : " + DVTProfilingUtils.memInfo() + LINE_SERPARATOR);
            result.append("Load information : " + DVTProfilingUtils.loadInfo() + LINE_SERPARATOR);
        }
        result.append("Load information : " + DVTProfilingUtils.loadInfo() + LINE_SERPARATOR);
        return result.toString();
    }

    public String getStatistics(IProject project, IProgressMonitor progressMonitor, StatisticsPreferenceModel spm) {
        this.fSpm = spm;
        this.collectSpecificStatistics(project, progressMonitor);
        StringBuilder result = new StringBuilder("");
        for (Metric i : this.fMetrics) {
            if (i instanceof Metric.SeparatorMetric) {
                result.append(LINE_SERPARATOR);
                continue;
            }
            if (i instanceof Metric.SimpleMetric) {
                result.append(String.valueOf(i.name) + LINE_SERPARATOR);
                continue;
            }
            result.append(String.valueOf(i.name) + " : " + i.getStringValue() + LINE_SERPARATOR);
        }
        this.clean();
        return result.toString();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
        this.setCurrentTask("Initializing ...", false);
        this.init();
        this.createAndAddMetric(String.valueOf(LINE_SERPARATOR) + LINE_SERPARATOR + StatisticsUtilProviderBase.convertToHeading(this.heading()) + LINE_SERPARATOR);
        IRfSingleLangProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        long lastFullBuildDuration = rfProject.getLastFullBuildDuration();
        long lastFullBuildMemoryAllocation = rfProject.getLastFullBuildMemoryAllocation();
        if (!this.setCurrentTask("Collecting performance statistics ...", false)) {
            return;
        }
        this.createAndAddMetric("Full Build Duration (sec)", lastFullBuildDuration);
        if (MemUtils.COLLECT_STATS) {
            this.createAndAddMetric("Full Build Memory (MB)", lastFullBuildMemoryAllocation);
        } else {
            this.createAndAddMetric("Full Build Memory (MB)", "Set $DVT_COLLECT_MEMORY_STATISTICS to 'true' for memory statistics.");
        }
        if (!this.setCurrentTask("Collecting file statistics ...", true)) {
            return;
        }
        FileInfoWrapper fileStatistics = this.collectFileStatistics(rfProject);
        if (fileStatistics == null) {
            return;
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Files", fileStatistics.allNofFiles);
        this.createAndAddMetric("Nof Lines", fileStatistics.total.totalNofLines);
        this.createAndAddMetric("Nof Code Lines", fileStatistics.total.codeNofLines);
        this.createAndAddMetric("Nof Code Lines/sec", lastFullBuildDuration == 0L ? UNKNOWN_METRIC_VALUE : "" + (long)fileStatistics.total.codeNofLines / lastFullBuildDuration);
        this.createAndAddMetric("Nof Code Chars", fileStatistics.total.codeNofChars);
        this.createAndAddMetric("Nof Comment Lines", fileStatistics.total.commentNofLines);
        this.createAndAddMetric("Nof Empty Lines", fileStatistics.total.emptyNofLines);
        if (fileStatistics.minFile != null) {
            this.createAndAddMetric("Min File Size (lines)", fileStatistics.minFile.totalNofLines);
            this.createAndAddMetric("Min File Name", fileStatistics.minFile.getName());
        }
        if (fileStatistics.maxFile != null) {
            this.createAndAddMetric("Max File Size (lines)", fileStatistics.maxFile.totalNofLines);
            this.createAndAddMetric("Max File Name", fileStatistics.maxFile.getName());
        }
        this.createAndAddMetric("Average File Size", fileStatistics.allNofFiles == 0 ? UNKNOWN_METRIC_VALUE : "" + Math.round((float)fileStatistics.total.totalNofLines / (float)fileStatistics.allNofFiles));
        this.createAndAddMetric("Average Line Size (chars)", fileStatistics.total.codeNofLines == 0 ? UNKNOWN_METRIC_VALUE : "" + Math.round((float)fileStatistics.total.codeNofChars / (float)fileStatistics.total.codeNofLines));
    }

    private FileInfoWrapper collectFileStatistics(IRfSingleLangProject rfProject) {
        List<ParserPath> allFiles = this.getCompiledParserPaths(rfProject);
        FileInfoWrapper result = new FileInfoWrapper();
        for (ParserPath fileName : allFiles) {
            if (!this.setCurrentTask("Collecting file statistics for " + fileName + " ...", false)) {
                return null;
            }
            if (this.isFiltered(fileName.path)) continue;
            ++result.allNofFiles;
            FileInfo fileInfo = this.computeFileInfo(fileName.path);
            if (result.minFile != null) {
                if (result.minFile.totalNofLines > fileInfo.totalNofLines) {
                    result.minFile = fileInfo;
                }
            } else {
                result.minFile = fileInfo;
            }
            if (result.maxFile != null) {
                if (result.maxFile.totalNofLines < fileInfo.totalNofLines) {
                    result.maxFile = fileInfo;
                }
            } else {
                result.maxFile = fileInfo;
            }
            result.total.totalNofLines += fileInfo.totalNofLines;
            result.total.commentNofLines += fileInfo.commentNofLines;
            result.total.codeNofLines += fileInfo.codeNofLines;
            result.total.emptyNofLines += fileInfo.emptyNofLines;
            result.total.codeNofChars += fileInfo.codeNofChars;
        }
        return result;
    }

    protected boolean setCurrentTask(String task, boolean worked) {
        if (this.fProgressMonitor == null) {
            return true;
        }
        if (this.fProgressMonitor.isCanceled()) {
            return false;
        }
        this.fProgressMonitor.setTaskName(task);
        if (worked) {
            this.fProgressMonitor.worked(1);
        }
        return true;
    }

    protected abstract boolean isFiltered(Object var1);

    protected boolean isFiltered(List<?> l) {
        if (l == null) {
            return true;
        }
        for (Object o : l) {
            if (this.isFiltered(o)) continue;
            return true;
        }
        return false;
    }

    public abstract String getNature();

    protected abstract String heading();

    protected abstract IRfSingleLangProject getRfProject(IProject var1);

    protected abstract List<ParserPath> getCompiledParserPaths(IRfSingleLangProject var1);

    protected abstract FileInfo computeFileInfo(String var1);

    private static class FileInfoWrapper {
        public int allNofFiles;
        public FileInfo total = new FileInfo("N/A");
        public FileInfo minFile;
        public FileInfo maxFile;

        private FileInfoWrapper() {
        }
    }
}

