/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorContributor;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorRequest;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;

public enum DVTSymbolCollector {
    INSTANCE;


    public List<ISymbolCollectorPrerequisite> collectSymbolsPrerequisites(ISymbolCollectorRequest request) {
        try {
            ArrayList<ISymbolCollectorPrerequisite> allPrerequisites = new ArrayList<ISymbolCollectorPrerequisite>();
            if (request == null || request.isCanceled()) {
                return allPrerequisites;
            }
            SymbolCollectorConfigurator configurator = new SymbolCollectorConfigurator(request);
            DVTSymbolKind[] symbolKinds = this.getSymbolKinds(configurator);
            if (symbolKinds == null || symbolKinds.length == 0) {
                return allPrerequisites;
            }
            DVTSymbolKind[] dVTSymbolKindArray = symbolKinds;
            int n = symbolKinds.length;
            int n2 = 0;
            while (n2 < n) {
                DVTSymbolKind symbolKind = dVTSymbolKindArray[n2];
                if (symbolKind != null) {
                    if (request.isCanceled()) {
                        return Collections.emptyList();
                    }
                    configurator.resetSymbolCount();
                    List<ISymbolCollectorPrerequisite> prerequisites = this.collectPrerequisites(symbolKind, configurator);
                    if (prerequisites != null && !prerequisites.isEmpty()) {
                        allPrerequisites.addAll(prerequisites);
                    }
                }
                ++n2;
            }
            return allPrerequisites;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<ISymbolCollectorPrerequisite> collectPrerequisites(DVTSymbolKind symbolKind, SymbolCollectorConfigurator configurator) {
        if (symbolKind == null || configurator == null || configurator.shouldStopCollecting()) {
            return Collections.emptyList();
        }
        ArrayList<ISymbolCollectorPrerequisite> result = new ArrayList<ISymbolCollectorPrerequisite>();
        List<? extends ISymbolCollectorContributor> contributors = symbolKind.getLanguageContributors();
        for (ISymbolCollectorContributor iSymbolCollectorContributor : contributors) {
            if (configurator.shouldStopCollecting()) {
                return result;
            }
            List<ISymbolCollectorPrerequisite> prerequisites = iSymbolCollectorContributor.getSymbolsPrerequisites(configurator);
            if (prerequisites == null) continue;
            result.addAll(prerequisites);
        }
        return result;
    }

    private DVTSymbolKind[] getSymbolKinds(SymbolCollectorConfigurator configurator) {
        if (configurator == null) {
            return null;
        }
        DVTSymbolKind symbolKind = SymbolQueryKey.getSymbolKind(configurator.getQueryKey());
        if (symbolKind != null) {
            return new DVTSymbolKind[]{symbolKind};
        }
        return configurator.getDefaultSymbolKinds();
    }
}

