/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import java.util.List;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorContributor;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.ITypesViewContributor;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public enum DVTSymbolKind {
    TYPE(ITypesViewContributor.class),
    MACRO(IMacrosViewContributor.class),
    COMPILED_FILE(ICompileOrderViewContributor.class);

    private DVTLabelProviderProxy<? extends ISymbolCollectorContributor> labelProvider;
    private List<? extends ISymbolCollectorContributor> languageContributors;

    private DVTSymbolKind(Class<? extends ISymbolCollectorContributor> contributorClass) {
        this.labelProvider = new DVTLabelProviderProxy<ISymbolCollectorContributor>(contributorClass, "default-tree");
        this.languageContributors = DVTViewContributors.getInstance().getAllInstanceOf(contributorClass);
    }

    public DVTLabelProviderProxy<? extends IDVTViewContributor> getLabelProvider() {
        return this.labelProvider;
    }

    protected List<? extends ISymbolCollectorContributor> getLanguageContributors() {
        return this.languageContributors;
    }

    public static DVTSymbolKind of(ISymbolCollectorPrerequisite prerequisite) {
        if (prerequisite == null) {
            return null;
        }
        if (prerequisite instanceof IMacroInfo) {
            return MACRO;
        }
        if (!(prerequisite instanceof IDVTElementWrapper)) {
            return null;
        }
        Object element = ((IDVTElementWrapper)prerequisite).getRfElement();
        if (element instanceof IDVTFileInstance || element instanceof IRfFileDef) {
            return COMPILED_FILE;
        }
        return TYPE;
    }
}

