/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import java.util.List;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;

public interface ISymbolCollectorContributor
extends IDVTViewContributor {
    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator var1);

    public boolean symbolMatchesQueryKey(ISymbolCollectorPrerequisite var1, SymbolCollectorConfigurator var2);

    default public boolean shouldCollectSymbol(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (symbolPrerequisite == null || configurator == null) {
            return false;
        }
        if (configurator.shouldStopCollecting()) {
            return false;
        }
        if (!this.symbolMatchesQueryKey(symbolPrerequisite, configurator)) {
            return false;
        }
        if (!this.symbolMatchesQueryPattern(symbolPrerequisite, configurator)) {
            return false;
        }
        return !configurator.shouldSkipSymbol(symbolPrerequisite);
    }

    default public boolean symbolMatchesQueryPattern(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (symbolPrerequisite == null || configurator == null) {
            return false;
        }
        DVTSymbolKind symbolKind = DVTSymbolKind.of(symbolPrerequisite);
        if (symbolKind == null) {
            return false;
        }
        DVTLabelProviderProxy<? extends IDVTViewContributor> labelProvider = symbolKind.getLabelProvider();
        if (labelProvider == null) {
            return false;
        }
        return ViewsUtilsCommon.matchCamelCaseOrRegex(configurator.getQueryPatternMatcher(), labelProvider.getText(symbolPrerequisite));
    }
}

