/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorRequest;
import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.symbolcollector.SymbolQueryWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class SymbolCollectorConfigurator {
    private final String queryKey;
    private final StringMatcher queryPatternMatcher;
    private final ISymbolCollectorRequest request;
    private int symbolCount;
    private static IRfFilterableTreeAccessor DUMMY_VIEW = new IRfFilterableTreeAccessor(){

        @Override
        public boolean isFiltered() {
            return false;
        }

        @Override
        public UpdateJob getUpdateJob() {
            return null;
        }

        @Override
        public boolean[] getTreeSearchStrictness() {
            return ViewsUtils.EMPTY_SEARCH_STRICTNESS;
        }

        @Override
        public StringMatcher[] getTreeSearchSegments() {
            return ViewsUtils.EMPTY_SEARCH_SEGMENTS;
        }

        @Override
        public String getTreeSearchPort() {
            return null;
        }

        @Override
        public ILabelProvider getTreeLabelProvider() {
            return null;
        }

        @Override
        public List<String> getMemberNames(IDVTElementWrapper node) {
            return null;
        }
    };

    protected SymbolCollectorConfigurator(ISymbolCollectorRequest request) {
        SymbolQueryWrapper queryWrapper = SymbolQueryUtils.processQuery(request.getQuery());
        this.queryKey = queryWrapper.getQueryKey();
        this.queryPatternMatcher = queryWrapper.getQueryPatternMatcher();
        this.request = request;
        this.symbolCount = 0;
    }

    public boolean shouldStopCollecting() {
        if (this.isSymbolCollectionCanceled()) {
            return true;
        }
        return this.symbolCount >= this.request.getMaxSymbolsPerCategory();
    }

    public boolean isSymbolCollectionCanceled() {
        return this.request == null || this.request.isCanceled();
    }

    public void countNewSymbol() {
        ++this.symbolCount;
    }

    protected DVTSymbolKind[] getDefaultSymbolKinds() {
        if (this.request == null) {
            return null;
        }
        return this.request.getDefaultSymbolKinds();
    }

    public IProject getProject() {
        if (this.request == null) {
            return null;
        }
        return this.request.getProject();
    }

    public StringMatcher getQueryPatternMatcher() {
        return this.queryPatternMatcher;
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    protected void resetSymbolCount() {
        this.symbolCount = 0;
    }

    protected IRfFilterableTreeAccessor getView() {
        return DUMMY_VIEW;
    }

    protected boolean sortByCategory() {
        if (this.request == null) {
            return false;
        }
        return this.request.sortByCategory();
    }

    public boolean ignoreContentFilters() {
        if (this.request == null) {
            return false;
        }
        return this.request.ignoreContentFilters();
    }

    protected boolean shouldSkipSymbol(ISymbolCollectorPrerequisite symbolPrerequisite) {
        if (this.request == null) {
            return false;
        }
        return this.request.shouldSkipSymbol(symbolPrerequisite);
    }
}

