/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;

public enum SymbolQueryKey {
    ACTION(DVTSymbolKind.TYPE, Constants.PSS),
    ANY_PORT(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    ANY_SEQUENCE(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    ANY_SEQUENCE_DRIVER(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    ANY_SEQUENCE_ITEM(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    ARCHITECTURE(DVTSymbolKind.TYPE, Constants.VHDL),
    BUFFER(DVTSymbolKind.TYPE, Constants.PSS),
    CHECKER(DVTSymbolKind.TYPE, Constants.VLOG),
    CLASS(DVTSymbolKind.TYPE, Constants.VLOG),
    COMPONENT(DVTSymbolKind.TYPE, Constants.PSS),
    CONFIGURATION(DVTSymbolKind.TYPE, Constants.VLOG_VHDL),
    COVERGROUP(DVTSymbolKind.TYPE, Constants.VLOG),
    ENTITY(DVTSymbolKind.TYPE, Constants.VHDL),
    ENUM(DVTSymbolKind.TYPE, Constants.VLOG_PSS, false, "enum type"),
    EXTENDS(DVTSymbolKind.TYPE, Constants.VLOG),
    FILE(DVTSymbolKind.COMPILED_FILE, Constants.ALL_LANGUAGES),
    GENERATE(DVTSymbolKind.TYPE, Constants.VLOG, false, "generate block"),
    INTERFACE(DVTSymbolKind.TYPE, Constants.VLOG),
    LIBRARY(DVTSymbolKind.TYPE, Constants.VLOG_VHDL),
    MACRO(DVTSymbolKind.MACRO, Constants.VLOG_E),
    MODULE(DVTSymbolKind.TYPE, Constants.VLOG),
    PACKAGE(DVTSymbolKind.TYPE, Constants.ALL_LANGUAGES),
    PACKAGE_BODY(DVTSymbolKind.TYPE, Constants.VHDL),
    PRIMITIVE(DVTSymbolKind.TYPE, Constants.VLOG),
    PROGRAM(DVTSymbolKind.TYPE, Constants.VLOG),
    RESOURCE(DVTSymbolKind.TYPE, Constants.PSS),
    SCALAR_TYPE(DVTSymbolKind.TYPE, Constants.E),
    SEQUENCE(DVTSymbolKind.TYPE, Constants.E),
    STATE(DVTSymbolKind.TYPE, Constants.PSS),
    STREAM(DVTSymbolKind.TYPE, Constants.PSS),
    STRUCT(DVTSymbolKind.TYPE, Constants.VLOG_E_PSS),
    TYPE(DVTSymbolKind.TYPE, Constants.ALL_LANGUAGES),
    TYPE_BODY(DVTSymbolKind.TYPE, Constants.VHDL),
    TYPEDEF(DVTSymbolKind.TYPE, Constants.VLOG_PSS, false, "type alias"),
    UNION(DVTSymbolKind.TYPE, Constants.VLOG),
    UNIT(DVTSymbolKind.TYPE, Constants.E),
    VHDL_TYPE(DVTSymbolKind.TYPE, Constants.VHDL, false, SymbolQueryKey.TYPE.name),
    VR_AD_MAP(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    VR_AD_MEM(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    VR_AD_REG(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    VR_AD_REG_FILE(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_AGENT(DVTSymbolKind.TYPE, Constants.VLOG_E, true, new String[0]),
    UVM_AGENT_CONFIG(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_BFM(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_COLLECTOR(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_COMPONENT(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_CONFIG_PARAMS(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_DRIVER(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.ANY_SEQUENCE_DRIVER.name),
    UVM_ENV(DVTSymbolKind.TYPE, Constants.VLOG_E, true, new String[0]),
    UVM_ENV_CONFIG(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_MEM(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.VR_AD_MEM.name),
    UVM_MONITOR(DVTSymbolKind.TYPE, Constants.VLOG_E, true, new String[0]),
    UVM_OBJECT(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.VR_AD_REG.name),
    UVM_REG_ADAPTER(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_BACKDOOR(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_BLOCK(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_FIELD(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_FIFO(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_FILE(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.VR_AD_REG_FILE.name),
    UVM_REG_FRONTDOOR(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_MAP(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.VR_AD_MAP.name),
    UVM_REG_PREDICTOR(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_REG_SEQUENCE(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_SCOREBOARD(DVTSymbolKind.TYPE, Constants.VLOG_E, true, new String[0]),
    UVM_SEQUENCE(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.ANY_SEQUENCE.name),
    UVM_SEQUENCE_ITEM(DVTSymbolKind.TYPE, Constants.VLOG_E, true, SymbolQueryKey.ANY_SEQUENCE_ITEM.name),
    UVM_SEQUENCER(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]),
    UVM_SIGNAL_MAP(DVTSymbolKind.TYPE, Constants.E, true, new String[0]),
    UVM_TEST(DVTSymbolKind.TYPE, Constants.VLOG, true, new String[0]);

    private static EnumMap<LanguageKind, Set<String>> queryKeysPerLanguage;
    private final String name = this.name().toLowerCase();
    private final DVTSymbolKind symbolKind;
    private final boolean isUvmSpecific;
    private final Set<String> equivalentTypes;

    private SymbolQueryKey(DVTSymbolKind symbolKind, EnumSet<LanguageKind> languageKinds) {
        this(symbolKind, languageKinds, false, new String[0]);
    }

    private SymbolQueryKey(DVTSymbolKind symbolKind, EnumSet<LanguageKind> languageKinds, boolean isUvmSpecific, String ... equivalentTypes) {
        this.symbolKind = symbolKind;
        this.isUvmSpecific = isUvmSpecific;
        SymbolQueryKey.markSupportedLanguages(this.name, languageKinds);
        this.equivalentTypes = equivalentTypes != null && equivalentTypes.length > 0 ? new HashSet<String>(Arrays.asList(equivalentTypes)) : this.computeEquivalentTypes(languageKinds);
    }

    private static void markSupportedLanguages(String queryKey, EnumSet<LanguageKind> languageKinds) {
        if (languageKinds == null) {
            return;
        }
        if (queryKeysPerLanguage == null) {
            queryKeysPerLanguage = new EnumMap(LanguageKind.class);
        }
        for (LanguageKind languageKind : languageKinds) {
            if (languageKind == null) continue;
            Set queryKeys = queryKeysPerLanguage.getOrDefault((Object)languageKind, new HashSet());
            queryKeys.add(queryKey);
            queryKeysPerLanguage.put(languageKind, queryKeys);
        }
    }

    private Set<String> computeEquivalentTypes(EnumSet<LanguageKind> languageKinds) {
        HashSet<String> result = new HashSet<String>();
        List<? extends ISymbolCollectorContributor> contributors = DVTSymbolKind.TYPE.getLanguageContributors();
        for (ISymbolCollectorContributor iSymbolCollectorContributor : contributors) {
            String kindName;
            IRfKind kind;
            BaseTypesViewContributor contributor;
            if (!(iSymbolCollectorContributor instanceof BaseTypesViewContributor) || !languageKinds.contains((Object)(contributor = (BaseTypesViewContributor)iSymbolCollectorContributor).getLanguageKind()) || (kind = contributor.getKind(this.name())) == null || (kindName = kind.getName()) == null || kindName.equals(this.name)) continue;
            result.add(kindName);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static SymbolQueryKey getEnumValue(String queryKey) {
        SymbolQueryKey enumValue;
        block5: {
            block4: {
                try {
                    if (queryKey != null && !queryKey.isEmpty()) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            enumValue = SymbolQueryKey.valueOf(queryKey.toUpperCase());
            if (enumValue != null && enumValue.name.equals(queryKey)) break block5;
            return null;
        }
        return enumValue;
    }

    public String toString() {
        return this.name;
    }

    public boolean isEqualTo(String queryKey) {
        return this.name.equals(queryKey);
    }

    public boolean isUvmSpecific() {
        return this.isUvmSpecific;
    }

    protected static DVTSymbolKind getSymbolKind(String queryKeyString) {
        SymbolQueryKey queryKey = SymbolQueryKey.getEnumValue(queryKeyString);
        if (queryKey == null) {
            return null;
        }
        return queryKey.symbolKind;
    }

    protected static boolean isValid(String queryKeyString) {
        if (queryKeyString == null || queryKeyString.isEmpty()) {
            return false;
        }
        SymbolQueryKey queryKey = SymbolQueryKey.getEnumValue(queryKeyString);
        return queryKey != null;
    }

    public static boolean isUvmSpecific(String queryKeyString) {
        if (queryKeyString == null || queryKeyString.isEmpty()) {
            return false;
        }
        SymbolQueryKey queryKey = SymbolQueryKey.getEnumValue(queryKeyString);
        if (queryKey == null) {
            return false;
        }
        return queryKey.isUvmSpecific;
    }

    public static boolean symbolMatchesQueryKey(String elementKind, String queryKeyString) {
        if (elementKind == null || queryKeyString == null) {
            return false;
        }
        if (elementKind.equals(queryKeyString)) {
            return true;
        }
        SymbolQueryKey queryKey = SymbolQueryKey.getEnumValue(queryKeyString);
        if (queryKey == null) {
            return false;
        }
        Set<String> equivalentTypes = queryKey.equivalentTypes;
        if (equivalentTypes == null || equivalentTypes.isEmpty()) {
            return false;
        }
        return equivalentTypes.contains(elementKind);
    }

    public static Set<String> getSupportedQueryKeys(LanguageKind languageKind) {
        if (languageKind == null) {
            return null;
        }
        return queryKeysPerLanguage.get((Object)languageKind);
    }

    public String toQuery(String queryPattern) {
        if (queryPattern == null) {
            queryPattern = "";
        }
        return String.valueOf(this.name) + ":" + queryPattern;
    }

    public String toQuery() {
        return this.toQuery("");
    }

    public static EnumSet<LanguageKind> getAllSupportedLanguageKinds() {
        return Constants.ALL_LANGUAGES;
    }

    private static class Constants {
        private static final EnumSet<LanguageKind> VLOG = EnumSet.of(LanguageKind.VLOG);
        private static final EnumSet<LanguageKind> VHDL = EnumSet.of(LanguageKind.VHDL);
        private static final EnumSet<LanguageKind> E = EnumSet.of(LanguageKind.E);
        private static final EnumSet<LanguageKind> PSS = EnumSet.of(LanguageKind.PSS);
        private static final EnumSet<LanguageKind> VLOG_VHDL = EnumSet.of(LanguageKind.VLOG, LanguageKind.VHDL);
        private static final EnumSet<LanguageKind> VLOG_E = EnumSet.of(LanguageKind.VLOG, LanguageKind.E);
        private static final EnumSet<LanguageKind> VLOG_PSS = EnumSet.of(LanguageKind.VLOG, LanguageKind.PSS);
        private static final EnumSet<LanguageKind> VLOG_E_PSS = EnumSet.of(LanguageKind.VLOG, LanguageKind.E, LanguageKind.PSS);
        private static final EnumSet<LanguageKind> ALL_LANGUAGES = EnumSet.of(LanguageKind.VLOG, LanguageKind.VHDL, LanguageKind.E, LanguageKind.PSS);

        private Constants() {
        }
    }
}

