/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.symbolcollector.SymbolQueryWrapper;

public class SymbolQueryUtils {
    public static final String QUERY_PART_SEPARATOR = ":";
    private static final String START_CARET = "^";
    private static final String END_DOLLAR = "$";

    private SymbolQueryUtils() {
    }

    public static SymbolQueryWrapper processQuery(String query) {
        return new SymbolQueryWrapper(query);
    }

    public static String getQueryKey(String query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        int separatorIndex = query.indexOf(QUERY_PART_SEPARATOR);
        if (separatorIndex <= 0) {
            return "";
        }
        String queryKey = query.substring(0, separatorIndex);
        if (!SymbolQueryKey.isValid(queryKey)) {
            return "";
        }
        return queryKey;
    }

    public static String getQueryPattern(String query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        String queryKey = SymbolQueryUtils.getQueryKey(query);
        if (queryKey == null || queryKey.isEmpty()) {
            return "";
        }
        int patternIndex = queryKey.length() + QUERY_PART_SEPARATOR.length();
        return query.substring(patternIndex);
    }

    public static String assembleQuery(String queryKey, String queryPattern) {
        String query = "";
        if (queryKey != null && !queryKey.isEmpty()) {
            query = String.valueOf(queryKey) + QUERY_PART_SEPARATOR;
        }
        if (queryPattern != null && !queryPattern.isEmpty()) {
            query = String.valueOf(query) + queryPattern;
        }
        return query;
    }

    public static boolean hasSpecialCharacters(String queryPattern) {
        if (queryPattern == null || queryPattern.isEmpty()) {
            return false;
        }
        return queryPattern.contains("*") || queryPattern.startsWith(START_CARET) || queryPattern.endsWith(END_DOLLAR);
    }

    public static String makeExactPattern(String queryPattern) {
        if (queryPattern == null || queryPattern.isEmpty()) {
            return "";
        }
        if (queryPattern.contains("*")) {
            return queryPattern;
        }
        if (!queryPattern.startsWith(START_CARET)) {
            queryPattern = START_CARET + queryPattern;
        }
        if (!queryPattern.endsWith(END_DOLLAR)) {
            queryPattern = String.valueOf(queryPattern) + END_DOLLAR;
        }
        return queryPattern;
    }
}

