/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.symbolcollector;

import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;

public class SymbolQueryWrapper {
    private static final StringMatcher EMPTY_QUERY_PATTERN_MATCHER = new StringMatcher("", true, false);
    private String queryKey;
    private String queryPattern;
    private StringMatcher queryPatternMatcher;

    protected SymbolQueryWrapper(String query) {
        this.processQuery(query);
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public String getQueryPattern() {
        return this.queryPattern;
    }

    protected StringMatcher getQueryPatternMatcher() {
        return this.queryPatternMatcher;
    }

    private void processQuery(String query) {
        if (query == null || query.isEmpty()) {
            this.setEmptyQuery();
            return;
        }
        this.queryKey = SymbolQueryUtils.getQueryKey(query);
        this.queryPattern = this.queryKey == null || this.queryKey.isEmpty() ? query : query.substring(this.queryKey.length() + ":".length());
        this.queryPatternMatcher = this.queryPattern.isEmpty() ? EMPTY_QUERY_PATTERN_MATCHER : ViewsUtilsCommon.createCamelCaseOrRegexMatcher(this.queryPattern, true, false);
    }

    private void setEmptyQuery() {
        this.queryKey = "";
        this.queryPattern = "";
        this.queryPatternMatcher = EMPTY_QUERY_PATTERN_MATCHER;
    }
}

