/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTCommandTypeArg;
import ro.amiq.dvt.tcl.model.DVTTclCommandArg;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public abstract class DVTTclCommand
implements Command {
    private IDVTCommandType type;
    protected DVTTclCommandArg[] args;
    protected DVTTclInterp interp;

    protected DVTTclCommand(IDVTCommandType type) {
        this.type = type;
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (!(interp instanceof DVTTclInterp)) {
            return;
        }
        this.interp = (DVTTclInterp)interp;
        this.args = new DVTTclCommandArg[objv.length];
        int i = 0;
        while (i < objv.length) {
            String argString = objv[i].toString();
            int line = interp.getLine(objv[i]);
            this.args[i] = new DVTTclCommandArg(argString, line, interp.scriptFile);
            ++i;
        }
        this.dvtCmdProc((DVTTclInterp)interp, objv);
    }

    public IDVTCommandType getType() {
        return this.type;
    }

    public int getNofPositionalArgs() {
        return this.type == null ? 0 : this.type.getNofPositionalArgs();
    }

    public String getName() {
        return this.type == null ? "" : this.type.getCommandName();
    }

    public List<DVTCommandTypeArg> getCommandArgs() {
        return this.type == null ? Collections.emptyList() : this.type.getCommandArgs();
    }

    protected DVTCommandResult parseCommandArguments() {
        return this.parseCommandArguments(this.interp.scriptFile);
    }

    @Deprecated
    protected DVTCommandResult parseCommandArguments(String currParsedFileOverride) {
        String commandName;
        String[] cliArgs;
        CommandLine commandLine;
        block16: {
            block15: {
                block14: {
                    GnuParser parser = new GnuParser();
                    Options options = new Options();
                    for (DVTCommandTypeArg commandOptionInfo : this.getCommandArgs()) {
                        if (commandOptionInfo.hasArg()) {
                            OptionBuilder.hasArg();
                            options.addOption(OptionBuilder.create((String)commandOptionInfo.getName()));
                            continue;
                        }
                        options.addOption(OptionBuilder.create((String)commandOptionInfo.getName()));
                    }
                    commandLine = parser.parse(options, Arrays.asList(this.args).stream().map(arg -> arg.getArgName()).collect(Collectors.toList()).toArray(new String[this.args.length]));
                    if (commandLine != null) break block14;
                    return null;
                }
                cliArgs = commandLine.getArgs();
                if (cliArgs.length >= this.getNofPositionalArgs()) break block15;
                return null;
            }
            commandName = this.getName();
            if (commandName.equals(cliArgs[0])) break block16;
            return null;
        }
        try {
            List<String> allCommandLine = Arrays.asList(cliArgs);
            ArrayList<String> commandArgsName = new ArrayList<String>(allCommandLine);
            commandArgsName.remove(commandName);
            HashMap<String, List<String>> commandOptionsByName = new HashMap<String, List<String>>();
            for (DVTCommandTypeArg commandOptionInfo : this.getCommandArgs()) {
                int n;
                int n2;
                String[] stringArray;
                String commandOptionName = commandOptionInfo.getName();
                if (!commandLine.hasOption(commandOptionName)) continue;
                String[] optionValues = commandLine.getOptionValues(commandOptionName);
                Option[] cmdOptions = commandLine.getOptions();
                if (optionValues == null) {
                    if (cmdOptions == null) continue;
                    stringArray = cmdOptions;
                    n2 = cmdOptions.length;
                    n = 0;
                    while (n < n2) {
                        String cmdOpt = stringArray[n];
                        if (commandOptionName.equals(cmdOpt.getOpt())) {
                            if (!commandOptionsByName.containsKey(commandOptionName)) {
                                commandOptionsByName.put(commandOptionName, new ArrayList());
                            }
                            ((List)commandOptionsByName.get(commandOptionName)).add("true");
                        }
                        ++n;
                    }
                    continue;
                }
                stringArray = optionValues;
                n2 = optionValues.length;
                n = 0;
                while (n < n2) {
                    String optionValue = stringArray[n];
                    if (!commandOptionsByName.containsKey(commandOptionName)) {
                        commandOptionsByName.put(commandOptionName, new ArrayList());
                    }
                    ((List)commandOptionsByName.get(commandOptionName)).add(optionValue != null ? optionValue : "true");
                    ++n;
                }
            }
            return new DVTCommandResult(commandArgsName, commandOptionsByName);
        }
        catch (Exception e) {
            this.interp.handleException(e, currParsedFileOverride, this.args[0].getArgLine(), this.getName());
            return null;
        }
    }

    protected abstract void dvtCmdProc(DVTTclInterp var1, TclObject[] var2) throws TclException;
}

