/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl.model;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.TclProblemKinds;
import ro.amiq.dvt.power.format.utils.DVTPFCommandUtils;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclCommand;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.utils.DVTStringUtil;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class DVTTclDummyCommand
extends DVTTclCommand {
    private String fResult;
    private boolean fFirstTimePrinted;
    private IProject project;
    private String name;

    public DVTTclDummyCommand(String name, IProject project) {
        super(null);
        this.name = name;
        this.project = project;
        if (DVTStringUtil.isNumber(name)) {
            this.fResult = "[" + name + "]";
        }
    }

    @Override
    public void dvtCmdProc(DVTTclInterp interp, TclObject[] objv) throws TclException {
        if (this.fResult != null) {
            interp.setResult(this.fResult);
        } else if (!this.fFirstTimePrinted) {
            this.fFirstTimePrinted = true;
            interp.printCmdProcToConsole(interp, "dummy", objv, DVTDebugKind.PF_DEBUG_INFO);
            if (DVTPFCommandUtils.COMMAND_TOOLTIP_BY_NAME.containsKey(this.getName())) {
                return;
            }
            int offset = interp.getOffset(objv[0]);
            int length = this.getName().length();
            DVTProblem prob = new DVTProblem(this.project, TclProblemKinds.TCL_WARNING, interp.scriptFile, false, -1, this.getName());
            prob.setAttribute("charStart", offset);
            prob.setAttribute("charEnd", offset + length);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("QUICKFIX_KIND", 1);
            attributes.put("QUICKFIX_ELEMENT_NAME", this.getName());
            prob.addAttributes(attributes);
            DVTProblemManager.getInstance().reportProblem(prob);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

