/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl.model;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclCommand;
import ro.amiq.dvt.tcl.model.DVTTclDummyCommand;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IGnuCommandErrorHandler;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;
import tcl.lang.cmd.PutsCmd;

public abstract class DVTTclInterp
extends Interp
implements IGnuCommandErrorHandler {
    public static final String DVT_PRE_TCL_INTERPRET_FILE_NAME = "dvt_pre_interpret.tcl";
    public static final String DVT_POST_TCL_INTERPRET_FILE_NAME = "dvt_post_interpret.tcl";
    private boolean fFirstCallDone = false;
    protected IProgressMonitor monitor;
    Deque<StopWatch> times = new ArrayDeque<StopWatch>();

    protected DVTTclInterp(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    /*
     * Unable to fully structure code
     */
    public void evalDVTScript(String scriptPath, String compilationRoot, IProject project) {
        block6: {
            block7: {
                try {
                    if (compilationRoot == null) {
                        DVTLogger.INSTANCE.logError("DVTTclInterp: Compilation root is null!");
                        return;
                    }
                    this.setWorkingDir(compilationRoot);
                    if (!this.validateInitialConditions()) {
                        return;
                    }
                    this.addBuildConfigVars(project);
                    this.overrideBuiltinCommands();
                    this.addCommands();
                    this.addUnknownCommandsResolver();
                    this.preInterpret();
                    this.evalFile(scriptPath);
                    this.postEvalScriptActions();
                    this.postInterpret();
                    break block6;
                }
                catch (TclException e) {
                    stackTrace = e.stackTrace;
                    if (stackTrace == null || stackTrace.length <= 0) break block7;
                    fileName = stackTrace[stackTrace.length - 1].getFileName();
                    lineNumber = stackTrace[stackTrace.length - 1].getLineNumber();
                    i = stackTrace.length - 1;
                    ** while (i >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    stackTraceElement = stackTrace[i];
                    if (fileName != null && fileName.equals(stackTraceElement.getFileName())) {
                        lineNumber += stackTraceElement.getLineNumber();
                    }
                    --i;
                    continue;
                }
lbl29:
                // 1 sources

                this.addTCLProblem(this.getResult().toString(), lineNumber, fileName);
                break block6;
            }
            message = "DVTTclInterp: " + this.getResult().toString();
            DVTTclUtils.printToConsole(message, this.getProject(), this.getBuildKind(), DVTDebugKind.TCL_ERROR, false);
        }
    }

    private void overrideBuiltinCommands() {
        PutsCmd putsImpl = new PutsCmd(){

            public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
                if (DVTTclInterp.this.monitor.isCanceled()) {
                    DVTTclInterp.this.setInterrupted();
                    return;
                }
                super.cmdProc(interp, argv);
                int line = interp.getLine(argv[0]);
                String file = interp.scriptFile;
                String message = "    TCL puts " + file + " @ " + line + " : " + argv[1];
                DVTTclUtils.printToConsole(message, DVTTclInterp.this.getProject(), DVTTclInterp.this.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, DVTTclInterp.this.isDebugMode());
            }
        };
        this.createCommand("puts", (Command)putsImpl);
    }

    private void addBuildConfigVars(IProject project) throws TclException {
        Map<String, String> bcEnvs = BuildConfigManager.getUserDefinedEnvVars(project);
        if (bcEnvs == null || bcEnvs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : bcEnvs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.setVar("env", key, value, 1);
            String message = "[DVTTclInterp] Defined build config var '" + key + "=" + value + "'";
            DVTTclUtils.printToConsole(message, this.getProject(), this.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.isDebugMode());
        }
    }

    public void eval(String string, int flags) throws TclException {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.setInterrupted();
            return;
        }
        super.eval(string, flags);
    }

    public void eval(TclObject tobj, int flags) throws TclException {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.setInterrupted();
            return;
        }
        this.pushEvalToken(tobj.token);
        try {
            super.eval(tobj, flags);
        }
        finally {
            this.popEvalToken();
        }
    }

    public void evalFile(String s) throws TclException {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.setInterrupted();
            return;
        }
        if (!this.times.isEmpty()) {
            this.times.peek().stop();
        }
        this.times.push(new StopWatch("").start());
        super.evalFile(s);
        StopWatch last = this.times.pop();
        last.stop();
        if (!this.times.isEmpty()) {
            this.times.peek().start();
        }
        String message = "    TCL done " + s + " [" + last.timeFormatted() + "]";
        DVTTclUtils.printToConsole(message, this.getProject(), this.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.isDebugMode());
    }

    protected void addCommand(DVTTclCommand command) {
        this.createCommand(command.getName(), command);
    }

    private void preInterpret() throws TclException {
        List allTclPreInterpFiles = DVTSFiles.DVT_PRE_TCL_INTERPRET_FILE.getAllFiles(true);
        if (allTclPreInterpFiles == null) {
            return;
        }
        this.interpretInternal(allTclPreInterpFiles);
    }

    private void postInterpret() throws TclException {
        List allTclPostInterpFiles = DVTSFiles.DVT_POST_TCL_INTERPRET_FILE.getAllFiles(true);
        if (allTclPostInterpFiles == null) {
            return;
        }
        this.interpretInternal(allTclPostInterpFiles);
    }

    private void interpretInternal(List<File> tclFiles) throws TclException {
        for (File file : tclFiles) {
            String interpPath;
            if (!file.exists() || (interpPath = file.getAbsolutePath()) == null || interpPath.isEmpty()) continue;
            this.evalFile(interpPath);
        }
    }

    private void addUnknownCommandsResolver() throws TclException {
        this.addInterpResolver("dummy_resolver", new Resolver(){

            public Var resolveVar(Interp interp, String name, Namespace context, int flags) throws TclException {
                return null;
            }

            public WrappedCommand resolveCmd(Interp interp, String name, Namespace context, int flags) throws TclException {
                if (DVTTclInterp.this.fFirstCallDone) {
                    return null;
                }
                DVTTclInterp.this.fFirstCallDone = true;
                WrappedCommand cmd = interp.getWrappedCommand(name);
                if (cmd == null) {
                    DVTTclInterp.this.addCommand(new DVTTclDummyCommand(name, DVTTclInterp.this.getProject()));
                    cmd = interp.getWrappedCommand(name);
                }
                DVTTclInterp.this.fFirstCallDone = false;
                return cmd;
            }
        });
    }

    public void printCmdProcToConsole(DVTTclInterp interp, String tag, TclObject[] objv, DVTDebugKind pfDebugInfo) {
        DVTTclUtils.printToConsole(() -> "    TCL " + tag + " " + dVTTclInterp.scriptFile + " @ " + interp.getLine(objv[0]) + " : " + DVTStringUtil.join(objv, ", "), this.getProject(), this.getBuildKind(), pfDebugInfo, this.isDebugMode());
    }

    protected abstract boolean validateInitialConditions();

    protected abstract void addCommands();

    protected abstract void postEvalScriptActions();

    protected abstract void addTCLProblem(String var1, int var2, String var3);

    public abstract IProject getProject();

    public abstract int getBuildKind();

    public abstract boolean isDebugMode();
}

