/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl.model;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.tcl.model.DVTDebugKind;

public class DVTTclUtils {
    public static final String TCL_ERROR_FORMAT = "*** Error: {0}" + System.lineSeparator();

    public static void printToConsole(String message, IProject project, int buildKind, DVTDebugKind debugKind, boolean isDebugMode) {
        DVTTclUtils.printToConsole(() -> message, project, buildKind, debugKind, isDebugMode);
    }

    public static void printToConsole(IMessageProvider message, IProject project, int buildKind, DVTDebugKind debugKind, boolean isDebugMode) {
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
        if (console == null) {
            return;
        }
        if (isDebugMode) {
            String msgString = message.getMessage();
            console.print(msgString.length() > 1024 ? msgString.substring(0, 1024).concat(" [...line too long]") : msgString);
        } else {
            switch (buildKind) {
                case 6: {
                    if (debugKind == DVTDebugKind.PF_DEBUG_INFO || debugKind == DVTDebugKind.QUARTUS_DEBUG_INFO) {
                        return;
                    }
                    String msgString = message.getMessage();
                    if (debugKind == DVTDebugKind.TCL_ERROR) {
                        console.print(MessageFormat.format(TCL_ERROR_FORMAT, message.getMessage()));
                        break;
                    }
                    console.print(msgString.length() > 1024 ? msgString.substring(0, 1024).concat(" [...line too long]") : msgString);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public static interface IMessageProvider {
        public String getMessage();
    }
}

