/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.tcl.model;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTCommandTypeArg;
import ro.amiq.dvt.tcl.model.DVTTclCommand;

public interface IDVTCommandType {
    public static final Map<IDVTCommandType, CommandDescriptor> DESCRIPTORS = new HashMap<IDVTCommandType, CommandDescriptor>();

    default public String getCommandName() {
        return this.getDescriptor().commandName;
    }

    default public Class<?> getCommandClass() {
        return this.getDescriptor().commandClass;
    }

    default public int getNofPositionalArgs() {
        return this.getDescriptor().nofPositionalArgs;
    }

    default public List<DVTCommandTypeArg> getCommandArgs() {
        return this.getDescriptor().commandArgs;
    }

    default public CommandDescriptor getDescriptor() {
        CommandDescriptor commandDescriptor = DESCRIPTORS.get(this);
        if (commandDescriptor == null) {
            throw new IllegalArgumentException("Command type " + this + " not initialized!");
        }
        return commandDescriptor;
    }

    default public void makeCommandType(String commandName, Class<? extends DVTTclCommand> commandClass, int nofPositionalArgs, DVTCommandTypeArg ... commandArgs) {
        CommandDescriptor commandDescriptor = new CommandDescriptor();
        commandDescriptor.commandName = commandName;
        commandDescriptor.commandClass = commandClass;
        commandDescriptor.nofPositionalArgs = nofPositionalArgs;
        commandDescriptor.commandArgs = commandArgs == null ? Collections.emptyList() : Arrays.asList(commandArgs);
        DESCRIPTORS.put(this, commandDescriptor);
    }

    default public DVTTclCommand makeCommand() {
        try {
            Class<?> clazz = this.getCommandClass();
            Constructor<?> ctor = clazz.getDeclaredConstructor(IDVTCommandType.class);
            ctor.setAccessible(true);
            DVTTclCommand newInstance = (DVTTclCommand)ctor.newInstance(this);
            return newInstance;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static class CommandDescriptor {
        private String commandName;
        private Class<? extends DVTTclCommand> commandClass;
        private int nofPositionalArgs;
        private List<DVTCommandTypeArg> commandArgs;
    }
}

