/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.templates;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTTemplateVariables {
    private static IFile getCurrentFile() {
        IEditorInput editorInput;
        block11: {
            IEditorPart activeEditor;
            block10: {
                IWorkbenchPage activePage;
                block9: {
                    IWorkbenchWindow activeWindow;
                    block8: {
                        IWorkbench workbench;
                        block7: {
                            try {
                                workbench = DVTPlugin.getDefault().getWorkbench();
                                if (workbench != null) break block7;
                                return null;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        activeWindow = workbench.getActiveWorkbenchWindow();
                        if (activeWindow != null) break block8;
                        return null;
                    }
                    activePage = activeWindow.getActivePage();
                    if (activePage != null) break block9;
                    return null;
                }
                activeEditor = activePage.getActiveEditor();
                if (activeEditor != null) break block10;
                return null;
            }
            editorInput = activeEditor.getEditorInput();
            if (editorInput != null) break block11;
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    public static class FileName
    extends SimpleTemplateVariableResolver {
        public FileName() {
            super("file_name", "File name");
        }

        protected String resolve(TemplateContext context) {
            IFile file = DVTTemplateVariables.getCurrentFile();
            if (file == null) {
                return null;
            }
            String fileName = file.getName();
            if (fileName == null) {
                return null;
            }
            int index = Math.min(fileName.length(), Math.max(0, fileName.lastIndexOf(".")));
            return fileName.substring(0, index);
        }
    }

    public static class ProjectName
    extends SimpleTemplateVariableResolver {
        public ProjectName() {
            super("project_name", "Project name");
        }

        protected String resolve(TemplateContext context) {
            IFile file = DVTTemplateVariables.getCurrentFile();
            if (file == null) {
                return null;
            }
            return file.getProject().getName();
        }
    }
}

