/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import org.eclipse.jface.action.Action;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.Utils;

@ProductSafe
@ForTestingOrDebuggingOnly
public class CopyTooltipToClipboardHelper
extends Action {
    private static String fTooltipSignature = "";
    private static String fTooltipContent = "";
    private static String fTooltipUpfSignature = "";
    private static int fColumn = -1;
    private static int fLine = -1;
    private static String fTooltipBitfieldDiagram = "";
    private static String fTooltipWaveDromDiagram = "";
    private static int fWindowWidth = -1;
    private static int fWindowHeight = -1;
    private static String fPreference = "";
    private static String fFile = "";
    private static String fLinterPragma = "";

    public CopyTooltipToClipboardHelper() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        this.setImageDescriptor(DVTImages.INFORMATION);
        this.setToolTipText("Test Mode: Copy tooltip to clipboard");
    }

    public void run() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        try {
            Utils.copyToClipboard(CopyTooltipToClipboardHelper.getJSON().toString(4), 3);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static JSONObject getJSON() {
        JSONObject json = null;
        try {
            json = new JSONObject();
            json.put("ID", 1);
            json.put("FILE", fFile);
            json.put("LINE", fLine);
            json.put("COLUMN", fColumn);
            json.put("SIGNATURE", fTooltipSignature);
            json.put("CONTENT", fTooltipContent);
            json.put("UPF_SIGNATURE", fTooltipUpfSignature);
            json.put("BITFIELD_DIAGRAM", fTooltipBitfieldDiagram);
            json.put("WAVEDROM_DIAGRAM", fTooltipWaveDromDiagram);
            json.put("WINDOW_WIDTH", fWindowWidth);
            json.put("WINDOW_HEIGHT", fWindowHeight);
            json.put("LINTER_PRAGMA", fLinterPragma);
            json.put("PREFERENCE", fPreference.isEmpty() ? CommentUtils.getInstance().getTooltipFormatterPreference().getPreferenceName() : fPreference);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        CopyTooltipToClipboardHelper.clear();
        return json;
    }

    public static boolean hasValidTooltipContent(JSONObject json) {
        if (json == null) {
            return false;
        }
        try {
            String signature = json.get("SIGNATURE").toString();
            String content = json.get("CONTENT").toString();
            String upfSignature = json.get("UPF_SIGNATURE").toString();
            String htmlContent = json.get("HTML_CONTENT").toString();
            if (signature.isEmpty() && content.isEmpty() && upfSignature.isEmpty() && htmlContent.isEmpty()) {
                return false;
            }
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public static void setTooltipComment(String signature, String content, String upfSignature) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fTooltipSignature = signature == null ? "" : signature;
        fTooltipContent = content == null ? "" : content;
        fTooltipUpfSignature = upfSignature == null ? "" : upfSignature;
    }

    public static void setLineAndColumn(int line, int column) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fLine = line;
        fColumn = column;
    }

    public static void setBitFieldDiagram(String bitfieldDiagram) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fTooltipBitfieldDiagram = bitfieldDiagram;
    }

    public static void setWaveDromDiagram(String waveDrom) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fTooltipWaveDromDiagram = waveDrom == null ? "" : waveDrom;
    }

    public static void setWindowSize(int width, int height) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fWindowWidth = width;
        fWindowHeight = height;
    }

    public static void setOldTooltipContent(String tooltip) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fTooltipContent = tooltip == null ? "" : tooltip;
    }

    public static void setFile(String path) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fFile = path == null ? "" : path;
    }

    public static void setPreference(String preference) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        DVTComment.CommentFormat format = CommentUtils.getInstance().getTooltipFormatterPreference();
        if (format == DVTComment.CommentFormat.AUTO) {
            fPreference = preference == null ? "" : String.valueOf(format.getPreferenceName()) + " - " + preference;
        }
    }

    public static void setLinterPragma(String fLinterPragma) {
        if (!TestHelper.isTestMode()) {
            return;
        }
        CopyTooltipToClipboardHelper.fLinterPragma = fLinterPragma;
    }

    public static void clear() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        fTooltipSignature = "";
        fTooltipContent = "";
        fTooltipUpfSignature = "";
        fColumn = -1;
        fLine = -1;
        fTooltipBitfieldDiagram = "";
        fTooltipWaveDromDiagram = "";
        fWindowWidth = -1;
        fWindowHeight = -1;
        fFile = "";
        fPreference = "";
        fLinterPragma = "";
    }
}

