/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.progress.WorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import ro.amiq.dvt.resourcemonitor.DVTResourceMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.DebugDestinations;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.test.TestHierarchyCurrentStateNameHolder;

@ForTestingOrDebuggingOnly
public final class EclipseJobsSyncer {
    private static final String NONE = "NONE";
    private static final String WAITING = "WAITING";
    private static final String SLEEPING = "SLEEPING";
    private static final String RUNNING = "RUNNING";
    private static final String BLOCKED = "BLOCKED";
    private static final String YIELDING = "YIELDING";
    private static final String ABOUT_TO_RUN = "ABOUT_TO_RUN";
    private static final String ABOUT_TO_SCHEDULE = "ABOUT_TO_SCHEDULE";
    private static final Map<String, Collection<RuntimeException>> syncTimeouts = new LinkedHashMap<String, Collection<RuntimeException>>();
    private static final String TIMEOUT_MSG_HEADER = "!!! JOBS DID NOT FINISH !!!\n";
    public static final Predicate<Job> DEFAULT_JOBS_FILGER = EclipseJobsSyncer::isIgnored;
    private static DebugDestinations debugDestination = DebugDestinations.NOTHING;
    private final String name;
    private final Predicate<Job> jobsFilter;
    private final long timeout;
    private final long step;
    private long waitStartTime;

    private EclipseJobsSyncer(EclipseJobsSyncerBuilder builder) {
        this.name = builder.name;
        this.jobsFilter = builder.jobsFilter;
        this.timeout = builder.timeout;
        this.step = builder.step;
    }

    public static EclipseJobsSyncerBuilder build(String name) {
        return new EclipseJobsSyncerBuilder(name);
    }

    public static EclipseJobsSyncerBuilder build(EclipseJobsSyncer syncer) {
        return new EclipseJobsSyncerBuilder(syncer);
    }

    public static void setDebugDestination(DebugDestinations debugDestination) {
        EclipseJobsSyncer.debugDestination = debugDestination;
    }

    public static Map<String, Collection<RuntimeException>> getSyncTimeouts() {
        return syncTimeouts;
    }

    private static boolean isIgnored(Job job) {
        return job instanceof DVTResourceMonitor || job instanceof UIJob && "LazyTypesOverlayUpdater".equals(job.getName()) || job instanceof StringPoolJob || job instanceof DelayedSnapshotJob || "Workbench Auto-Save Job".equals(job.getName()) || "Decoration Calculation".equals(job.getName()) || "Timer".equals(job.getName()) || job instanceof WorkbenchJob && "Animation start".equals(job.getName()) || job instanceof WorkbenchJob && "Update for Decoration Completion".equals(job.getName()) || job instanceof WorkbenchSiteProgressService.SiteUpdateJob;
    }

    private static boolean isUnfinished(String state, boolean shouldRun) {
        return RUNNING.equals(state) || shouldRun && !NONE.equals(state);
    }

    void waitForJobs() {
        this.waitStartTime = System.currentTimeMillis();
        long stopTime = this.waitStartTime + this.timeout;
        this.debug("started waiting for " + this.timeout + " ms " + " with step: " + this.step + " ms");
        while (stopTime > System.currentTimeMillis() && this.getJobs().findAny().isPresent()) {
            this.debugPrintRemainingJobs();
            TestHelper.delay(this.step);
        }
        if (stopTime < System.currentTimeMillis()) {
            this.debug("timed out");
            this.logIfSyncTimedout();
            return;
        }
        this.debug("finished after " + (System.currentTimeMillis() - this.waitStartTime) + " ms");
    }

    private Stream<Job> getJobs() {
        return Arrays.stream(Job.getJobManager().find(null)).filter(j -> EclipseJobsSyncer.isUnfinished(JobManager.printState((Job)j), j.shouldRun())).filter(Predicate.not(this.jobsFilter));
    }

    private String toTimeotMessage(List<JobStateRecord> jobs) {
        StringBuilder message = new StringBuilder(TIMEOUT_MSG_HEADER);
        jobs.forEach(job -> {
            StringBuilder stringBuilder2 = message.append(job).append(System.lineSeparator());
        });
        return message.toString();
    }

    private void debugPrintRemainingJobs() {
        if (debugDestination.equals((Object)DebugDestinations.NOTHING)) {
            return;
        }
        this.debug("remaining jobs:");
        this.getJobs().forEach(j -> EclipseJobsSyncer.getOutStream().accept("\tClass: " + j.getClass() + " - Name: " + j.getName() + " - State: " + JobManager.printState((Job)j)));
    }

    private void debug(String msg) {
        if (debugDestination.equals((Object)DebugDestinations.NOTHING)) {
            return;
        }
        EclipseJobsSyncer.getOutStream().accept("===== [ " + this.name + " ] - [ " + (System.currentTimeMillis() - this.waitStartTime) + " ms ] " + msg + " =====");
    }

    private static Consumer<String> getOutStream() {
        return switch (debugDestination) {
            case DebugDestinations.LOG -> arg_0 -> ((DVTLogger)DVTLogger.INSTANCE).logDebug(arg_0);
            case DebugDestinations.CONSOLE -> TestHelper.out::println;
            default -> throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)debugDestination));
        };
    }

    private void logIfSyncTimedout() {
        List<JobStateRecord> jobs = this.getJobs().map(JobStateRecord::new).filter(j -> EclipseJobsSyncer.isUnfinished(j.state, j.shouldRun)).collect(Collectors.toList());
        if (jobs.isEmpty()) {
            return;
        }
        String message = this.toTimeotMessage(jobs);
        String currentTestName = TestHierarchyCurrentStateNameHolder.INSTANCE.getTestDisplayName();
        if (!syncTimeouts.containsKey(currentTestName)) {
            syncTimeouts.put(currentTestName, new ArrayList());
        }
        syncTimeouts.get(currentTestName).add(new RuntimeException(message));
        TestHelper.err.println(message);
    }

    public static class EclipseJobsSyncerBuilder {
        private String name = "EclipseJobsSyncer";
        private Predicate<Job> jobsFilter = DEFAULT_JOBS_FILGER;
        private long timeout = 60000L;
        private long step = 100L;

        private EclipseJobsSyncerBuilder(String name) {
            this.name = name;
        }

        private EclipseJobsSyncerBuilder(EclipseJobsSyncer syncer) {
            this.name = syncer.name;
            this.jobsFilter = syncer.jobsFilter;
            this.timeout = syncer.timeout;
            this.step = syncer.step;
        }

        public EclipseJobsSyncerBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public EclipseJobsSyncerBuilder withJobsFilter(Predicate<Job> jobsFilter) {
            this.jobsFilter = jobsFilter;
            return this;
        }

        public EclipseJobsSyncerBuilder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public EclipseJobsSyncerBuilder withStep(long step) {
            this.step = step;
            return this;
        }

        public EclipseJobsSyncer toSyncer() {
            return new EclipseJobsSyncer(this);
        }
    }

    private record JobStateRecord(String className, String name, String state, boolean shouldRun) {
        protected JobStateRecord(Job other) {
            this(other.getClass().getName(), other.getName(), JobManager.printState((Job)other), other.shouldRun());
        }

        @Override
        public String toString() {
            return String.format("[%s] %s : %s ; Should run? %s", this.className, this.name, this.state, this.shouldRun ? "YES" : "NO");
        }
    }
}

