/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.util.EnumMap;
import java.util.Set;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.TestEnvironmentVarNames;

@ProductSafe
public class TestEnvironmentStore {
    private static final TestEnvironmentStore defaultEnvironmentStore = new TestEnvironmentStore();
    private final EnumMap<TestEnvironmentVarNames, Object> testEnvMap = new EnumMap(TestEnvironmentVarNames.class);

    public TestEnvironmentStore() {
        TestEnvironmentVarNames[] testEnvironmentVarNamesArray = TestEnvironmentVarNames.values();
        int n = testEnvironmentVarNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestEnvironmentVarNames testEnv = testEnvironmentVarNamesArray[n2];
            this.testEnvMap.put(testEnv, testEnv.defaultValue);
            ++n2;
        }
    }

    public TestEnvironmentStore(TestEnvironmentStore store) {
        for (TestEnvironmentVarNames testEnv : store.getTestEnvMap().keySet()) {
            this.testEnvMap.put(testEnv, store.getTestEnvMap().get((Object)testEnv));
        }
    }

    public static TestEnvironmentStore getDefaultTestEnvironmentStore() {
        return defaultEnvironmentStore;
    }

    public EnumMap<TestEnvironmentVarNames, Object> getTestEnvMap() {
        return this.testEnvMap;
    }

    public void setValue(TestEnvironmentVarNames testRunPrefName, Object value) {
        testRunPrefName.checkIfValueIsAccepted(value);
        this.testEnvMap.put(testRunPrefName, value);
    }

    public boolean getBoolean(TestEnvironmentVarNames testRunPrefName) {
        if (this.testEnvMap.get((Object)testRunPrefName) instanceof Boolean) {
            return (Boolean)this.testEnvMap.get((Object)testRunPrefName);
        }
        throw new ClassCastException("TestEnv " + (Object)((Object)testRunPrefName) + " does not hold a boolean value.");
    }

    public int getInteger(TestEnvironmentVarNames testRunPrefName) {
        if (this.testEnvMap.get((Object)testRunPrefName) instanceof Integer) {
            return (Integer)this.testEnvMap.get((Object)testRunPrefName);
        }
        throw new ClassCastException("TestEnv " + (Object)((Object)testRunPrefName) + " does not hold an integer value.");
    }

    public String getString(TestEnvironmentVarNames testRunPrefName) {
        if (this.testEnvMap.get((Object)testRunPrefName) instanceof String) {
            return (String)this.testEnvMap.get((Object)testRunPrefName);
        }
        throw new ClassCastException("TestEnv " + (Object)((Object)testRunPrefName) + " does not hold an String value.");
    }

    public Set<?> getSet(TestEnvironmentVarNames testRunPrefName) {
        if (this.testEnvMap.get((Object)testRunPrefName) instanceof Set) {
            return (Set)this.testEnvMap.get((Object)testRunPrefName);
        }
        throw new ClassCastException("TestEnv " + (Object)((Object)testRunPrefName) + " does not hold a Set value.");
    }
}

