/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.json.JSONObject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ITestHelperListener;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.TestEnvironmentStore;
import ro.amiq.dvt.test.TestEnvironmentVarNames;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.test.TestSyncHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;

@ForTestingOrDebuggingOnly
public abstract class TestHelperCommon {
    @ProductSafe
    public static final PrintStream out;
    @ProductSafe
    public static final PrintStream err;
    public static final String DVT_TEST_PLUGIN_PATH;
    public static final boolean IS_TEST_MODE;
    public static final boolean IS_DEBUG_MODE;
    @ProductSafe
    public static final String DVT_REGRESSION_RUNNER_EDA_ARTIFACTS_DIRECTORY;
    public static final String DVT_DH_TESTS_IN_ELAB_MODE = "DVT_DH_TESTS_IN_ELAB_MODE";
    protected static boolean fFilteringSyntheticEvents;
    protected static boolean fRequiringGCInvariantTime;
    public static final String DVT_LS_TEST_MODE = "DVT_LS_TEST_MODE";
    private static final String SWTBOT_SUITE = "SWTBOT_SUITE";
    public static final boolean DVT_RESTORE_MODE;
    public static final String EXPAND_MACRO_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosExpandOneLevelInline";
    public static final String EXPAND_MACRO_ALL_LEVELS_VLOG_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosExpandAllLevelsInline";
    public static final String COLLAPSE_MACRO_INLINE_EXPANSION_VLOG_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosCollapseInlineExpansion";
    public static final String EXPAND_ALL_MACROS_INLINE_VLOG_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosExpandAllInline";
    public static final String EXPAND_ALL_MACROS_VLOG_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosExpandAll";
    public static final String COLLAPSE_ALL_MACRO_INLINE_EXPANSIONS_VLOG_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.MacrosCollapseAllInlineExpansions";
    public static final String EXPAND_MACRO_ALL_LEVELS_EDT_COMMAND_ID = "ro.amiq.edt.base.ui.editor.MacrosExpandAllLevelsInline";
    private static final Set<String> TEST_SERVER_NAMES;
    private static final Set<String> QA_MACHINES_NAMES;
    public static final String PROBLEM_MARKER_ID = "org.eclipse.core.resources.problemmarker";
    public static final String CUSTOM_CODE_FACTORY_TEMPLATE_DESCRIPTION_FORMAT = "Create from '%s'";
    @ProductSafe
    public static final String TEST_ELAB_CONTEXT_PROBLEM_ATTRIBUTE = "TEST_ELAB_CONTEXT_PROBLEM_ATTRIBUTE";
    private static TestEnvironmentStore testHelperEnvironmentStore;
    @ProductSafe
    public double fAutoIndentTime;
    @ProductSafe
    public long fCompileWaiversApplicationTime;
    public String refactoringText;
    private static final Set<String> OVERRIDE_RUN_ONLY;
    public static final String DVT_TEST_ROOT_PATH;
    public static final String EDT_TEST_PLUGIN_PATH;
    public static final String VLOGDT_TEST_PLUGIN_PATH;
    public static final String VHDLDT_TEST_PLUGIN_PATH;
    public static final String PSSDT_TEST_PLUGIN_PATH;
    public static final String MSDLDT_TEST_PLUGIN_PATH;
    public static final String DVTMIXED_TEST_PLUGIN_PATH;
    public static final String BATCH_TEST_PLUGIN_PATH;
    public static final String PREDEFINED_PROJECTS_PATH;
    public static final String WEBVIEW_TEST_SETUP_SCRIPTS_PATH;
    public static final String AI_TEST_SCENARIOS_PATH;
    public static final String LOGVIEWER_TEST_SCENARIOS_PATH;
    private static final String MEM_MONITOR_REGRESSION = "MEM_MONITOR_REGRESSION";
    public static final TestSyncHelper SYNCER;
    private static Map<String, String> PLUGIN_MAP;
    public List<ITestHelperListener> fListeners;
    private static boolean useDPICJNAImpl;

    static {
        Set overrideRunOnly;
        block14: {
            out = System.out;
            err = System.err;
            DVT_TEST_PLUGIN_PATH = System.getenv("DVT_TEST_PLUGIN_PATH");
            IS_TEST_MODE = DVT_TEST_PLUGIN_PATH != null;
            IS_DEBUG_MODE = DVT_TEST_PLUGIN_PATH != null || System.getenv("DVT_DEBUG_MODE") != null;
            DVT_REGRESSION_RUNNER_EDA_ARTIFACTS_DIRECTORY = System.getenv("DVT_REGRESSION_RUNNER_EDA_ARTIFACTS_DIRECTORY");
            DVT_RESTORE_MODE = Boolean.parseBoolean(System.getenv("DVT_TEST_RESTORE_AFTER_BUILD"));
            TEST_SERVER_NAMES = Stream.of("thor", "odin1", "odin2", "odin3", "odin4", "odin5", "ragnarok", "ragnarok1", "ragnarok2", "ragnarok3", "ragnarok4", "ragnarok5", "ragnarok6").collect(Collectors.toSet());
            QA_MACHINES_NAMES = Stream.of("anshar", "innana", "lofn").collect(Collectors.toSet());
            testHelperEnvironmentStore = TestEnvironmentStore.getDefaultTestEnvironmentStore();
            SYNCER = TestSyncHelper.INSTANCE;
            if (DVT_TEST_PLUGIN_PATH != null) {
                Path basePath = Paths.get(DVT_TEST_PLUGIN_PATH, new String[0]).getParent();
                DVT_TEST_ROOT_PATH = basePath.toString();
                EDT_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.edt.tests").toString();
                VLOGDT_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.vlogdt.tests").toString();
                VHDLDT_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.vhdldt.tests").toString();
                PSSDT_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.pssdt.tests").toString();
                MSDLDT_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.msdldt.tests").toString();
                DVTMIXED_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.dvtmixed.tests").toString();
                BATCH_TEST_PLUGIN_PATH = basePath.resolve("ro.amiq.dvt.batch.tests").toString();
                PREDEFINED_PROJECTS_PATH = basePath.resolve("ro.amiq.dvt.predefined_projects").toString();
                WEBVIEW_TEST_SETUP_SCRIPTS_PATH = basePath.resolve("ro.amiq.dvt.webviews.tests").resolve("utils").toString();
                AI_TEST_SCENARIOS_PATH = basePath.resolve("ro.amiq.dvt.ai").resolve("test").resolve("scenarios").toString();
                LOGVIEWER_TEST_SCENARIOS_PATH = basePath.resolve("ro.amiq.dvt.vscode").resolve("test").resolve("automation").resolve("src").resolve("dvt").resolve("logViewer").resolve("scenarios").toString();
            } else {
                DVT_TEST_ROOT_PATH = "";
                EDT_TEST_PLUGIN_PATH = "";
                VLOGDT_TEST_PLUGIN_PATH = "";
                VHDLDT_TEST_PLUGIN_PATH = "";
                DVTMIXED_TEST_PLUGIN_PATH = "";
                PSSDT_TEST_PLUGIN_PATH = "";
                MSDLDT_TEST_PLUGIN_PATH = "";
                BATCH_TEST_PLUGIN_PATH = "";
                PREDEFINED_PROJECTS_PATH = "";
                WEBVIEW_TEST_SETUP_SCRIPTS_PATH = "";
                AI_TEST_SCENARIOS_PATH = "";
                LOGVIEWER_TEST_SCENARIOS_PATH = "";
            }
            TestHelperCommon.initializePluginMap();
            Path overrideFile = Paths.get(System.getProperty("user.home"), new String[0]).resolve("dvt_test_override_list");
            overrideRunOnly = Collections.emptySet();
            if (overrideFile.toFile().exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (Stream<String> lines = Files.lines(overrideFile);){
                        overrideRunOnly = lines.map(String::trim).collect(Collectors.toSet());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    if (!TestHelper.isTestMode()) break block14;
                    e.printStackTrace(err);
                }
            }
        }
        OVERRIDE_RUN_ONLY = overrideRunOnly;
    }

    public static boolean shouldRun(String name) {
        return OVERRIDE_RUN_ONLY == null || OVERRIDE_RUN_ONLY.isEmpty() || OVERRIDE_RUN_ONLY.contains(name);
    }

    private static void initializePluginMap() {
        PLUGIN_MAP = new HashMap<String, String>();
        PLUGIN_MAP.put("ro.amiq.edt.tests", EDT_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.vlogdt.tests", VLOGDT_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.vhdldt.tests", VHDLDT_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.pssdt.tests", PSSDT_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.msdldt.tests", MSDLDT_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.dvtmixed.tests", DVTMIXED_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.dvt.batch.tests", BATCH_TEST_PLUGIN_PATH);
        PLUGIN_MAP.put("ro.amiq.dvt.predefined_projects", PREDEFINED_PROJECTS_PATH);
    }

    public String getRefactoringText() {
        return this.refactoringText;
    }

    public void setRefactoringText(String refactoringText) {
        this.refactoringText = refactoringText;
    }

    @ProductSafe
    public static boolean isTestMode() {
        return IS_TEST_MODE;
    }

    @ProductSafe
    public static boolean isLSTestMode() {
        return IS_TEST_MODE && System.getenv("DVT_VSCODE_TEST_MODE") == null;
    }

    @ProductSafe
    public static boolean isTestModeNoExit() {
        return IS_TEST_MODE && System.getenv("DVT_TEST_MODE_NO_EXIT") != null;
    }

    @ProductSafe
    public static boolean isDebugMode() {
        return IS_DEBUG_MODE;
    }

    public static void delay(long waitTimeMillis) {
        SYNCER.delay(waitTimeMillis);
    }

    @ProductSafe
    public static boolean isLanguageServerMode() {
        return Boolean.parseBoolean(System.getenv(DVT_LS_TEST_MODE));
    }

    @ProductSafe
    public static boolean isSWTBotSuite() {
        return Boolean.parseBoolean(System.getenv(SWTBOT_SUITE));
    }

    public abstract List<String> getImageDescriptors(Image var1);

    protected List<String> getFieldNameByDescriptor(Field[] fields, ImageDescriptor descriptor) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field != null && (field.getModifiers() & 1) != 0 && field.getType() == ImageDescriptor.class && field.get(null).equals(descriptor)) {
                    matches.add(field.getName());
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
        return matches;
    }

    @ProductSafe
    public abstract void setLastTokenTime();

    public static void setRequiringGCInvariantTime(boolean value) {
        fRequiringGCInvariantTime = value;
    }

    @ProductSafe
    public static boolean isRequiringGCInvariantTime() {
        return TestHelper.isTestMode() && fRequiringGCInvariantTime;
    }

    @ProductSafe
    public static boolean isUsingMaxIntSemanticIssuesPerFile() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.usingMaxIntSemanticIssuesPerFile);
    }

    @ProductSafe
    public static boolean isComputingFixedSizeLazyTree() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.computingLazyTreeNodesFixedSize);
    }

    @ProductSafe
    public static boolean isComputingFullSizeLazyTree() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.computingLazyTreeNodesFullSize);
    }

    @ProductSafe
    public static boolean isBuildingOnlyWithAutoconfig() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.buildingOnlyWithAutoconfig);
    }

    @ProductSafe
    public static boolean isComputingElaborationContext() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.computeElaborationContextForProblems);
    }

    public static boolean isWaitingForErrors() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.waitingForErrors);
    }

    @ProductSafe
    public static void setMaxIntSemanticIssuesPerFile(boolean value) {
        testHelperEnvironmentStore.setValue(TestEnvironmentVarNames.usingMaxIntSemanticIssuesPerFile, value);
    }

    @ProductSafe
    public static void setComputeElaborationContextForProblems(boolean value) {
        testHelperEnvironmentStore.setValue(TestEnvironmentVarNames.computeElaborationContextForProblems, value);
    }

    @ProductSafe
    public static int getLazyTreeNodesFixedSize() {
        return testHelperEnvironmentStore.getInteger(TestEnvironmentVarNames.lazyTreeNodesFixedSize);
    }

    @ProductSafe
    public static boolean isIgnoringTimeouts() {
        return TestHelperCommon.isTestMode() && testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.ignoringTimeouts);
    }

    public static Set<String> getExploratoryWaivers() {
        return testHelperEnvironmentStore.getSet(TestEnvironmentVarNames.exploratoryWaivers);
    }

    @ProductSafe
    public static boolean isPerformanceTest() {
        return testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.performanceTest);
    }

    public static boolean isTestServer() {
        try {
            return TestHelperCommon.isTestMode() && TEST_SERVER_NAMES.contains(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isQAMachine() {
        try {
            return TestHelperCommon.isTestMode() && QA_MACHINES_NAMES.contains(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    @ProductSafe
    public static boolean isFilteringSyntheticEvents() {
        return TestHelper.isTestMode() && fFilteringSyntheticEvents;
    }

    public static void setFilterSyntheticEvents(boolean value) {
        fFilteringSyntheticEvents = value;
    }

    public void addListener(ITestHelperListener l) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<ITestHelperListener>();
        }
        this.fListeners.add(l);
    }

    public abstract ICompletionProposal[] getProposals(int var1, int var2);

    public String getFileContents(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    public String getFileContents(Path filePath) throws IOException {
        return this.getFileContents(filePath.toFile());
    }

    public String getFileContents(String filePath) throws IOException {
        return this.getFileContents(Paths.get(filePath, new String[0]));
    }

    public boolean openHyperlinkNo(int line, int column, int index, String expectedLabel) {
        return this.openHyperlinkNo(line, column, index, expectedLabel, false);
    }

    public boolean openHyperlinkNo(int line, int column, int index, String expectedLabel, boolean withTimeout) {
        IHyperlink[] hs;
        if (!TestHelperCommon.isLanguageServerMode()) {
            hs = withTimeout ? this.getAllHyperlinksTimeout(line - 1, column - 1) : this.getAllHyperlinks(line - 1, column - 1);
        } else {
            hs = this.getAllHyperlinks(line - 1, column - 1, expectedLabel);
            if (hs != null && hs.length == 1) {
                index = 0;
            }
        }
        if (hs != null && hs.length > index) {
            if (!TestHelperCommon.isLanguageServerMode()) {
                String actualLabel = hs[index].getHyperlinkText();
                if (expectedLabel != null) {
                    Assert.isTrue((boolean)actualLabel.equals(expectedLabel), (String)("Hyperlink label is wrong .... Expected [ " + expectedLabel + " ] but actually, was [ " + actualLabel + " ] !"));
                }
            }
            hs[index].open();
            return true;
        }
        return false;
    }

    public abstract IHyperlink[] getAllHyperlinks(int var1, int var2);

    public abstract IHyperlink[] getAllHyperlinksTimeout(int var1, int var2);

    public abstract IHyperlink[] getAllHyperlinks(int var1, int var2, String var3);

    public abstract void closeWelcomePage();

    public abstract boolean resetWindowSize();

    public abstract void computeVerificationHierarchy(int var1, int var2) throws Exception;

    public abstract void computeDesignHierarchy(int var1, int var2) throws Exception;

    public abstract List<String> getDHTopModules();

    public abstract String getCurrentFile();

    public abstract int getCurrentLine();

    public abstract void navigateTo(int var1, int var2);

    public abstract void clearConsole();

    public final void runLaunchConfig(String launchConfigName, int filtersNo) throws Exception {
        this.runLaunchConfig(launchConfigName, filtersNo, false);
    }

    public abstract void runLaunchConfig(String var1, int var2, boolean var3) throws Exception;

    public double getRelativeVariationPercentage(double actual, double threshold) {
        return Math.abs(threshold - actual) / threshold * 100.0;
    }

    public abstract String getChecksText(Object var1);

    public abstract Image getChecksImage(Object var1);

    public abstract String getChecksComment(Object var1);

    public abstract Object[] getDvtViewChildren(Object var1);

    public abstract String getCoverageText(Object var1);

    public abstract Image getCoverageImage(Object var1);

    public abstract String getCoverageComment(Object var1);

    public abstract void computeHidHolderView();

    public abstract void setShowHidHoldersOperatorsAndPredefined(boolean var1, boolean var2, boolean var3);

    public abstract void selectProject(IProject var1) throws PartInitException;

    public abstract String insertCommand(String var1, int var2, int var3, int var4) throws BadLocationException;

    public abstract void showIncludingFile();

    public abstract void closeAllEditors();

    public abstract String getConsoleTextRetry();

    public abstract JSONObject getHTMLToolTip(int var1, int var2, boolean var3);

    public void notifyTestSetUp(Object test) {
        if (this.fListeners != null) {
            this.fListeners.forEach(l -> l.notifyTestSetUp(test));
        }
    }

    public void notifyTestTearDown(Object test) {
        if (this.fListeners != null) {
            this.fListeners.forEach(l -> l.notifyTestTearDown(test));
        }
    }

    public abstract void disableDeprecatedBuildConfigurationDialog(boolean var1);

    public abstract void disableDecorators();

    public abstract void disableGitDecorator();

    public abstract void openTestPerspective();

    public abstract void computeCallHierarchy(int var1, int var2);

    public abstract void computeTypeHierarchy(int var1, int var2);

    public abstract boolean enableGuiFilters(Objection ... var1);

    public abstract boolean disableGuiFilters(Objection ... var1);

    public abstract Object[] getTreeViewChildren(Object var1);

    public abstract Image getTypesImage(Object var1);

    public abstract String getTypesText(Object var1);

    public abstract void setContentFiltersXml(IProject var1, String var2, Objection ... var3) throws CoreException;

    public abstract void addWaiver(String var1, String var2, boolean var3, String var4, boolean var5, String var6, String var7) throws Exception;

    public abstract void deleteWaiversFile() throws Exception;

    public abstract void goToSelectedElement(ViewPart var1);

    public abstract void applyContentAssist(int var1, int var2, int var3, AbstractTextEditor var4) throws BadLocationException;

    public abstract void showMultipleRebuildMessage(boolean var1);

    public abstract ICompletionProposal[] getBCEditorProposals(int var1, int var2);

    public abstract int computeOffset(DVTEditor var1, int var2, int var3);

    public abstract void deleteContentFiltersXml(String var1);

    public abstract org.eclipse.ui.console.IHyperlink getHyperlinkForString(String var1, int var2);

    public abstract Object getDesignHierarchyRoot();

    public abstract IViewPart getView(String var1);

    public abstract List<String> closeAllViews();

    public static void pauseTest() {
        SYNCER.pauseTest();
    }

    public static void playTest() {
        SYNCER.playTest();
    }

    public DVTLazyView getLazyView(String id) {
        IViewPart view = TestHelper.getInstance().getView(id);
        return view instanceof DVTLazyView ? (DVTLazyView)view : null;
    }

    public boolean selectInLazyView(String viewId, String nodeName, int nodeNum) {
        DVTLazyView view = this.getLazyView(viewId);
        if (view == null) {
            return false;
        }
        ILazyTreeTestUtils lazyTreeTestUtils = view.getLazyTreeTestUtils();
        if (lazyTreeTestUtils == null) {
            return false;
        }
        return lazyTreeTestUtils.selectInLazyTree(nodeName, nodeNum);
    }

    public boolean searchAndSelectInLazyView(String viewId, String nodeName, int nodeNum) {
        DVTLazyView view = this.getLazyView(viewId);
        if (view == null) {
            return false;
        }
        ILazyTreeTestUtils lazyTreeTestUtils = view.getLazyTreeTestUtils();
        if (lazyTreeTestUtils == null) {
            return false;
        }
        return lazyTreeTestUtils.searchAndSelectInLazyView(nodeName, nodeNum);
    }

    public abstract boolean searchInLazyView(String var1, String var2);

    public abstract void openFlexiblePerspective(String ... var1);

    public abstract void waitPendingConsoleUpdates();

    public IPreferenceStore getGlobalPreferenceStore() {
        return DVTPlugin.getDefault().getPreferenceStore();
    }

    public abstract void replace(IDocument var1, int var2, int var3, String var4) throws BadLocationException;

    public abstract boolean isViewVisible(String var1);

    public abstract IViewPart showView(String var1);

    public void hideViews(String ... viewIds) {
        this.hideViews(Arrays.asList(viewIds));
    }

    public abstract void hideViews(Collection<String> var1);

    public void showViews(String ... viewIds) {
        this.showViews(Arrays.asList(viewIds));
    }

    public abstract void showViews(Collection<String> var1);

    public abstract List<String> getVisibleViews();

    @ProductSafe
    public static boolean memoryMonitorIsInhibited() {
        if (!TestHelper.isTestMode()) {
            return false;
        }
        if (System.getenv(MEM_MONITOR_REGRESSION) != null) {
            return false;
        }
        return !testHelperEnvironmentStore.getBoolean(TestEnvironmentVarNames.usingMemoryMonitorInTests);
    }

    public static boolean isUsingDPICJNAImpl() {
        return useDPICJNAImpl;
    }

    public static void useDPICJNAImpl() {
        useDPICJNAImpl = true;
    }

    public static List<Map<String, List<String>>> computeElabContexts(Object elements) {
        ArrayList<String> contextsList = new ArrayList<String>(List.of(((String)elements).split("\\|")));
        boolean notFull = contextsList.removeIf(c -> c.contains("..."));
        Set contexts = contextsList.stream().filter(c -> !c.equals("...")).sorted().map(s -> new LinkedHashSet<String>(List.of(s.split(",")))).collect(Collectors.toSet());
        if (contexts.isEmpty()) {
            throw new RuntimeException("No contexts");
        }
        LinkedHashSet commonContext = new LinkedHashSet((Collection)contexts.iterator().next());
        for (Set context : contexts) {
            commonContext.retainAll(context);
        }
        for (Set context : contexts) {
            context.removeAll(commonContext);
        }
        ArrayList<Set> separatedContexts = new ArrayList<Set>();
        separatedContexts.add(commonContext);
        for (Set context : contexts) {
            if (context.isEmpty()) continue;
            separatedContexts.add(context);
        }
        ArrayList<Map<String, List<String>>> result = new ArrayList<Map<String, List<String>>>();
        int i = 0;
        for (Set context : separatedContexts) {
            String elementName = separatedContexts.size() == 1 ? "Context1" : (i == 0 ? "Common" : "Context" + i);
            Map element = Collections.singletonMap(elementName, context.stream().map(s -> s.strip()).collect(Collectors.toList()));
            if (!context.isEmpty()) {
                result.add(element);
            }
            ++i;
        }
        if (notFull) {
            result.add(Collections.singletonMap("...", List.of()));
        }
        return result;
    }

    @ProductSafe
    public static void addElabContext(ELManager manager, Map<String, Object> attributes) {
        if (attributes == null) {
            return;
        }
        String elabPaths = (String)attributes.get("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE");
        if (elabPaths == null) {
            return;
        }
        IELMemory memory = manager.getMemory();
        String[] splitElabPaths = elabPaths.split(",");
        String context = TestHelperCommon.computeElabContext(splitElabPaths[splitElabPaths.length - 1], memory);
        if (context == null) {
            return;
        }
        String currentContexts = (String)attributes.get(TEST_ELAB_CONTEXT_PROBLEM_ATTRIBUTE);
        List<String> contextsList = new ArrayList<String>();
        if (currentContexts != null) {
            contextsList.addAll(List.of(currentContexts.split("\\|")));
        }
        contextsList.add(context);
        contextsList = contextsList.stream().sorted().collect(Collectors.toList());
        attributes.put(TEST_ELAB_CONTEXT_PROBLEM_ATTRIBUTE, String.join((CharSequence)"|", contextsList));
    }

    private static String computeElabContext(String path, IELMemory elMemory) {
        ELInstance instanceFor = elMemory.instanceFor(ElementPath.from(path, "."));
        if (instanceFor == null) {
            return null;
        }
        IRfNamedElement binding = instanceFor.getBinding(true);
        if (binding == null) {
            return null;
        }
        ELParamValues cachedParamValues = instanceFor.getParamValues();
        Map<Object, Object> entries = cachedParamValues == null ? Collections.emptyMap() : cachedParamValues.getEntries();
        LinkedHashSet<String> parameters = new LinkedHashSet<String>();
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            parameters.add(String.valueOf((String)entry.getKey()) + "=" + ((IELParamValue)entry.getValue()).toNiceString(null, PrefConst.getParamRadix(), false, false));
        }
        if (parameters.isEmpty()) {
            return null;
        }
        return StringUtils.join(parameters, (String)",");
    }

    public static void setEnvironmentStore(TestEnvironmentStore store) {
        testHelperEnvironmentStore = store;
    }

    @ProductSafe
    public static TestEnvironmentStore getEnvironmentStore() {
        return testHelperEnvironmentStore;
    }

    public static String getTestPlugin(String key) {
        return PLUGIN_MAP.get(key);
    }

    public static Path getPredefinedTemplatePath(String templateFileName) {
        return Paths.get(PREDEFINED_PROJECTS_PATH, "dvt_code_factory", templateFileName);
    }

    public static boolean isAtLeastJava24() {
        return Runtime.version().feature() >= 24;
    }

    public static enum ConsoleID {
        BUILD_CONSOLE,
        SIM_CONSOLE;

    }
}

