/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ITestHierarchyCurrentStateObservable;
import ro.amiq.dvt.test.ITestHierarchyCurrentStateObserver;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.TestHierarchyCurrentStateNameTypes;

@ForTestingOrDebuggingOnly
public class TestHierarchyCurrentStateNameHolder
implements ITestHierarchyCurrentStateObservable {
    @ProductSafe
    public static final TestHierarchyCurrentStateNameHolder INSTANCE = new TestHierarchyCurrentStateNameHolder();
    public static final String UNKNOWN = "Unknown";
    private String topSuiteName = "Unknown";
    private String suiteName = "Unknown";
    private String testClassName = "Unknown";
    private String testMethodName = "Unknown";
    private String testSimpleName = "Unknown";
    private final Set<ITestHierarchyCurrentStateObserver> testHierarchyCurrentStateObservers = new HashSet<ITestHierarchyCurrentStateObserver>();

    private TestHierarchyCurrentStateNameHolder() {
    }

    public String getTopSuiteName() {
        return this.topSuiteName;
    }

    public void setTopSuiteName(String topSuiteName) {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameSet(TestHierarchyCurrentStateNameTypes.TOPSUITE, this.topSuiteName, topSuiteName));
        this.topSuiteName = topSuiteName;
    }

    public void resetTopSuiteName() {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameReset(TestHierarchyCurrentStateNameTypes.TOPSUITE, this.topSuiteName));
        this.topSuiteName = UNKNOWN;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameSet(TestHierarchyCurrentStateNameTypes.SUBSUITE, this.suiteName, suiteName));
        this.suiteName = suiteName;
    }

    public void resetSuiteName() {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameReset(TestHierarchyCurrentStateNameTypes.SUBSUITE, this.suiteName));
        this.suiteName = UNKNOWN;
    }

    @ProductSafe
    public String getTestClassName() {
        return this.testClassName;
    }

    public void setTestClassName(String testClassName) {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameSet(TestHierarchyCurrentStateNameTypes.TESTCLASS, this.testClassName, testClassName));
        this.testClassName = testClassName;
        String[] testClassNameSegments = this.testClassName.split("\\.");
        if (testClassNameSegments.length > 0) {
            this.testSimpleName = testClassNameSegments[testClassNameSegments.length - 1];
        }
    }

    public void resetTestClassName() {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameReset(TestHierarchyCurrentStateNameTypes.TESTCLASS, this.testClassName));
        this.testClassName = UNKNOWN;
    }

    public String getTestMethodName() {
        return this.testMethodName;
    }

    public void setTestMethodName(String testMethodName) {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameSet(TestHierarchyCurrentStateNameTypes.TESTMETHOD, this.testMethodName, testMethodName));
        this.testMethodName = testMethodName;
    }

    public void resetTestMethodName() {
        this.testHierarchyCurrentStateObservers.forEach(observer -> observer.onNameReset(TestHierarchyCurrentStateNameTypes.TESTMETHOD, this.testMethodName));
        this.testMethodName = UNKNOWN;
    }

    public String getTestDisplayName() {
        return String.valueOf(this.testClassName) + "." + this.testMethodName;
    }

    public String getTestSimpleName() {
        return this.testSimpleName;
    }

    @Override
    public void subscribe(ITestHierarchyCurrentStateObserver stateObserver) {
        this.testHierarchyCurrentStateObservers.add(stateObserver);
    }

    @Override
    public void unsubscribe(ITestHierarchyCurrentStateObserver stateObserver) {
        this.testHierarchyCurrentStateObservers.remove(stateObserver);
    }
}

