/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.DebugDestinations;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.ObjectionNeverClearedException;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.test.SimultaneousWaitException;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.test.TestHierarchyCurrentStateNameHolder;
import ro.amiq.dvt.test.UnexpectedObjectionException;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.utils.DVTStringUtil;

@ForTestingOrDebuggingOnly
class TestObjectionManager
extends ObjectionManager {
    private Map<String, Collection<RuntimeException>> timeoutExceptionMap = new HashMap<String, Collection<RuntimeException>>();
    private AtomicBoolean isSuspended = new AtomicBoolean();
    public static final String WAIT_TIMEOUT_MESSAGE_START = "[OBJECTION] Timed out while waiting for the following objections to be cleared: ";
    private static final Set<String> DEBUG_TO_LOG_HOSTNAMES = Collections.unmodifiableSet(Stream.of("hera", "hefaistos", "hathor", "norma", "cepheus").collect(Collectors.toSet()));
    private static final Set<Objection> SPAM_OBJECTIONS = Collections.unmodifiableSet(EnumSet.of(Objection.CONSOLE_OUTPUT_COMPLETE));
    private static final Map<DVTProblemCategory, Objection> PROBLEM_CATEGORIES_TO_OBJECTIONS;
    private ConcurrentLinkedQueue<Objection> fClearQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean fWaiting = new AtomicBoolean();
    private IJobChangeListener fProblemsViewListener;
    private boolean isAddingDelayBeforeWaitFor;

    static {
        Object[][] array2D = new Object[][]{{EProblemCategories.E_NAME_CHECKING, Objection.PROBLEMS_E_NC}, {EProblemCategories.E_SEMANTIC, Objection.PROBLEMS_E_SM}, {EProblemCategories.E_SYNTAX, Objection.PROBLEMS_E_ST}, {EProblemCategories.SLN_NAME_CHECKING, Objection.PROBLEMS_SLN_NC}, {EProblemCategories.SLN_SEMANTIC, Objection.PROBLEMS_SLN_SM}, {EProblemCategories.SLN_SYNTAX, Objection.PROBLEMS_SLN_ST}, {VlogProblemCategories.SVLOG_SEMANTIC, Objection.PROBLEMS_SV_SM}, {VlogProblemCategories.SVLOG_SYNTAX, Objection.PROBLEMS_SV_ST}, {VhdlProblemCategories.VHDL_NAME_CHECKING, Objection.PROBLEMS_VHDL_NC}, {VhdlProblemCategories.VHDL_SEMANTIC, Objection.PROBLEMS_VHDL_SM}, {VhdlProblemCategories.VHDL_SYNTAX, Objection.PROBLEMS_VHDL_ST}, {PSSProblemCategories.PSS_SEMANTIC, Objection.PROBLEMS_PSS_SM}, {PSSProblemCategories.PSS_SYNTAX, Objection.PROBLEMS_PSS_ST}, {MSDLProblemCategories.MSDL_SEMANTIC, Objection.PROBLEMS_MSDL_SM}, {MSDLProblemCategories.MSDL_SYNTAX, Objection.PROBLEMS_MSDL_ST}, {DVTProblemCategories.EXTERNALTOOLS, Objection.PROBLEMS_EXTERNAL}, {DVTProblemCategories.BUILDCONFIG, Objection.PROBLEMS_BC}};
        PROBLEM_CATEGORIES_TO_OBJECTIONS = Collections.unmodifiableMap(Stream.of(array2D).collect(Collectors.toMap(data -> (DVTProblemCategory)data[0], data -> (Objection)((Object)((Object)data[1])))));
    }

    public TestObjectionManager() {
        String hostname = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (DEBUG_TO_LOG_HOSTNAMES.contains(hostname)) {
            this.setDebugDestination(DebugDestinations.LOG);
        }
    }

    @Override
    public void addDelayBeforeWaitFor() {
        this.isAddingDelayBeforeWaitFor = true;
    }

    @Override
    public void resetDelayBeforeWaitFor() {
        this.isAddingDelayBeforeWaitFor = false;
    }

    @Override
    @ProductSafe
    public void clear(Objection o) {
        if (this.isSuspended.get()) {
            return;
        }
        this.fClearQueue.add(o);
    }

    @Override
    @ProductSafe
    public void clearForOnlyBuildConfig() {
        if (this.isSuspended.get()) {
            return;
        }
        this.fClearQueue.addAll(Arrays.asList(PROBLEMS_OBJECTIONS_POST_FULL_BUILD));
    }

    @Override
    @ProductSafe
    public void conditionalClear(boolean condition, Objection o) {
        if (condition) {
            this.clear(o);
        }
    }

    @Override
    @ProductSafe
    public void clear(DVTProblemCategory category) {
        Objection o = PROBLEM_CATEGORIES_TO_OBJECTIONS.getOrDefault(category, null);
        if (o != null) {
            this.clear(o);
        }
    }

    @Override
    @ProductSafe
    public synchronized void clear(IUpdateJobImpl iUpdateJobImpl) {
        String className = iUpdateJobImpl.getClass().getName();
        Objection objection = (Objection)((Object)CLASS_NAME_TO_OBJECTIONS.get(className));
        if (objection == null) {
            return;
        }
        this.clear(objection);
    }

    @Override
    @ProductSafe
    public void clear(IDVTLazyView lazyView) {
        String className = lazyView.getClass().getName();
        Objection objection = (Objection)((Object)CLASS_NAME_TO_OBJECTIONS.get(className));
        if (objection == null) {
            return;
        }
        this.clear(objection);
    }

    @Override
    @ProductSafe
    public synchronized void clearForMembers(AbstractFilteredView iUpdateJobImpl) {
        String className = iUpdateJobImpl.getClass().getName();
        Objection objection = (Objection)((Object)CLASS_NAME_TO_OBJECTIONS_FOR_MEMBERS.get(className));
        if (objection == null) {
            return;
        }
        this.clear(objection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor(Collection<Objection> objections) {
        if (this.isSuspended.get()) {
            new IllegalStateException("Trying to wait for an objection when the manager is suspended! skipping syncronization...").printStackTrace(TestHelper.err);
            return;
        }
        if (this.isAddingDelayBeforeWaitFor) {
            TestHelper.delay(1000L);
        }
        ConcurrentLinkedQueue<Objection> concurrentLinkedQueue = this.fClearQueue;
        synchronized (concurrentLinkedQueue) {
            if (this.fWaiting.get()) {
                this.fWaiting.set(false);
                throw new SimultaneousWaitException("Only one wait for objections allowed.");
            }
            this.fWaiting.set(true);
            ArrayList<Objection> expectedObjections = new ArrayList<Objection>(objections);
            this.debug("[OBJECTION] start waiting [" + DVTStringUtil.join(expectedObjections, ", ") + "] {{{{{{{{");
            long waitUntil = System.currentTimeMillis() + TestObjectionManager.getTimeout();
            while (waitUntil > System.currentTimeMillis() && !expectedObjections.isEmpty()) {
                Objection clearedObjection = this.fClearQueue.poll();
                if (clearedObjection == null) {
                    TestHelper.delay(100L);
                    continue;
                }
                boolean wasRemoved = expectedObjections.remove((Object)clearedObjection);
                if (!wasRemoved && SPAM_OBJECTIONS.contains((Object)clearedObjection)) continue;
                this.debug("[OBJECTION] " + (Object)((Object)clearedObjection) + " cleared " + (wasRemoved ? "and removed from" : "but was not in") + " waiting list, remaining:" + "[" + DVTStringUtil.join(expectedObjections, ", ") + "]");
            }
            this.fWaiting.set(false);
            if (!expectedObjections.isEmpty()) {
                String timedOutObjections = DVTStringUtil.join(expectedObjections, ", ");
                String debugMessage = WAIT_TIMEOUT_MESSAGE_START + timedOutObjections;
                String currentTestName = TestHierarchyCurrentStateNameHolder.INSTANCE.getTestDisplayName();
                if (!this.timeoutExceptionMap.containsKey(currentTestName)) {
                    this.timeoutExceptionMap.put(currentTestName, new ArrayList());
                }
                this.timeoutExceptionMap.get(currentTestName).add(new RuntimeException(timedOutObjections));
                this.debug(debugMessage);
            }
            this.debug("[OBJECTION] stop waiting }}}}}}}}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchForUnexpected(long timeout, Objection ... objections) throws UnexpectedObjectionException {
        if (this.isSuspended.get()) {
            new IllegalStateException("Trying to wait for an unexpected objection when the manager is suspended! skipping syncronization...").printStackTrace(TestHelper.err);
            return;
        }
        ConcurrentLinkedQueue<Objection> concurrentLinkedQueue = this.fClearQueue;
        synchronized (concurrentLinkedQueue) {
            if (this.fWaiting.get()) {
                this.fWaiting.set(false);
                throw new SimultaneousWaitException("Only one wait for objections allowed.");
            }
            this.fWaiting.set(true);
            EnumSet<Objection> unexpected = EnumSet.noneOf(Objection.class);
            Collections.addAll(unexpected, objections);
            this.debug("[OBJECTION] start watching for NO [" + DVTStringUtil.join(unexpected, ", ") + "] for " + timeout + "ms {{{{{{{{");
            long waitUntil = System.currentTimeMillis() + timeout;
            while (waitUntil > System.currentTimeMillis()) {
                TestHelper.delay(100L);
            }
            this.fWaiting.set(false);
            unexpected.retainAll(this.fClearQueue);
            if (!unexpected.isEmpty()) {
                String timedOutObjections = DVTStringUtil.join(unexpected, ", ");
                throw new UnexpectedObjectionException("Unexpected: " + timedOutObjections);
            }
            this.debug("[OBJECTION] stop watching }}}}}}}}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchForExpected(long timeout, Objection ... objections) throws ObjectionNeverClearedException {
        if (this.isSuspended.get()) {
            new IllegalStateException("Trying to wait for an expected objection when the manager is suspended! skipping syncronization...").printStackTrace(TestHelper.err);
            return;
        }
        ConcurrentLinkedQueue<Objection> concurrentLinkedQueue = this.fClearQueue;
        synchronized (concurrentLinkedQueue) {
            if (this.fWaiting.get()) {
                this.fWaiting.set(false);
                throw new SimultaneousWaitException("Only one wait for objections allowed.");
            }
            this.fWaiting.set(true);
            ArrayList<Objection> expectedObjections = new ArrayList<Objection>(Arrays.asList(objections));
            this.debug("[OBJECTION] start watching for [" + DVTStringUtil.join(expectedObjections, ", ") + "] for " + timeout + "ms {{{{{{{{");
            long waitUntil = System.currentTimeMillis() + timeout;
            while (waitUntil > System.currentTimeMillis() && !expectedObjections.isEmpty()) {
                Objection clearedObjection = this.fClearQueue.poll();
                if (clearedObjection == null) {
                    TestHelper.delay(100L);
                    continue;
                }
                boolean wasRemoved = expectedObjections.remove((Object)clearedObjection);
                if (!wasRemoved && SPAM_OBJECTIONS.contains((Object)clearedObjection)) continue;
                this.debug("[OBJECTION] " + (Object)((Object)clearedObjection) + " cleared " + (wasRemoved ? "and removed from" : "but was not in") + " waiting list, remaining:" + "[" + DVTStringUtil.join(expectedObjections, ", ") + "]");
            }
            this.fWaiting.set(false);
            this.debug("[OBJECTION] stop watching }}}}}}}}");
            if (!expectedObjections.isEmpty()) {
                String timedOutObjections = DVTStringUtil.join(expectedObjections, ", ");
                throw new ObjectionNeverClearedException("The following Objections were not cleared: " + timedOutObjections);
            }
        }
    }

    private void debug(String s) {
        switch (this.debugDestination) {
            case LOG: {
                DVTLogger.INSTANCE.logDebug(s);
                break;
            }
            case CONSOLE: {
                TestHelper.out.println(s);
                break;
            }
        }
    }

    @Override
    public void debugPrintQueue() {
        this.debug("[OBJECTION] Queue content [" + DVTStringUtil.join(this.fClearQueue, ", ") + "]");
    }

    @Override
    public void clearQueue() {
        String stack = ExceptionUtils.getStackTrace((Throwable)new Exception());
        if (!(stack.contains("tearDown(") || stack.contains("setUp(") || stack.contains("Files(") || stack.contains("importProject(") || stack.contains("handlerClearQueue") || stack.contains("performTest") || stack.contains("ro.amiq.dvt.test.TestSyncHelper."))) {
            throw new RuntimeException("You should NOT call this from anywhere else except inter-test!");
        }
        this.internalClearQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClearQueue() {
        ConcurrentLinkedQueue<Objection> concurrentLinkedQueue = this.fClearQueue;
        synchronized (concurrentLinkedQueue) {
            if (!this.fClearQueue.isEmpty()) {
                this.debug("[OBJECTION] ClearQueue [" + DVTStringUtil.join(this.fClearQueue, ", ") + "]");
                this.fClearQueue.clear();
            }
        }
    }

    @Override
    public void setWaiting(boolean wait) {
        this.fWaiting.set(wait);
    }

    @Override
    public void ensureProblemsViewListenerRegistered() {
        if (this.fProblemsViewListener != null) {
            return;
        }
        this.fProblemsViewListener = new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                Job job = event.getJob();
                if (job == null) {
                    return;
                }
                if ("org.eclipse.ui.internal.views.markers.MarkerUpdateJob".equals(job.getClass().getCanonicalName())) {
                    ObjectionManager.getInstance().clear(Objection.PROBLEMS_VIEW);
                }
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        };
        Job.getJobManager().addJobChangeListener(this.fProblemsViewListener);
    }

    @Override
    public void ensureProblemsViewListenerRemoved() {
        if (this.fProblemsViewListener == null) {
            return;
        }
        Job.getJobManager().removeJobChangeListener(this.fProblemsViewListener);
        this.fProblemsViewListener = null;
    }

    @Override
    public Map<String, Collection<RuntimeException>> getTimeoutExceptionMap() {
        return this.timeoutExceptionMap;
    }

    @Override
    public void suspendObjectionSyncAndRun(Runnable code) {
        if (this.fWaiting.get()) {
            new IllegalStateException("Suspending Objections Manager while a wait is ongoing (wait started by a paralel thread from product / tests)").printStackTrace(TestHelper.err);
        }
        if (this.isSuspended.getAndSet(true)) {
            throw new IllegalStateException("Only one suspend for objections manager allowed.");
        }
        try {
            code.run();
        }
        finally {
            this.internalClearQueue();
            this.isSuspended.set(false);
        }
    }

    @Override
    public <T> T suspendObjectionSyncAndGet(Supplier<T> code) {
        if (this.fWaiting.get()) {
            new IllegalStateException("Suspending Objections Manager while a wait is ongoing (wait started by a paralel thread from product / tests)").printStackTrace(TestHelper.err);
        }
        if (this.isSuspended.getAndSet(true)) {
            throw new IllegalStateException("Only one suspend for objections manager allowed.");
        }
        try {
            T t = code.get();
            return t;
        }
        finally {
            this.internalClearQueue();
            this.isSuspended.set(false);
        }
    }
}

