/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.test;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.test.EclipseJobsSyncer;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;

@ForTestingOrDebuggingOnly
public final class TestSyncHelper {
    public static final TestSyncHelper INSTANCE = new TestSyncHelper();
    public static final long DEFAULT_ADAPTIVE_DELLAY = TestHelper.isTestServer() ? 20000 : (TestHelper.isQAMachine() ? 2000 : 0);
    private static AtomicBoolean testIsPaused = new AtomicBoolean(false);

    private TestSyncHelper() {
    }

    public final void delay(long timeMs) {
        Display display = Display.getCurrent();
        if (display != null && !TestHelper.isLanguageServerMode()) {
            timeMs += System.currentTimeMillis();
            while (timeMs > System.currentTimeMillis()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception exception) {}
            }
            display.update();
        } else {
            try {
                Thread.sleep(timeMs);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void adaptiveDelay(long timeMs, long stepMs, BooleanSupplier breakLoopCondition) {
        timeMs += System.currentTimeMillis();
        while (timeMs > System.currentTimeMillis() && !breakLoopCondition.getAsBoolean()) {
            this.delay(stepMs);
        }
    }

    public final void adaptiveDelay(long timeMs, BooleanSupplier breakLoopCondition) {
        this.adaptiveDelay(timeMs, Math.max(timeMs / 100L, 20L), breakLoopCondition);
    }

    @SafeVarargs
    public final <T> T getWithRetry(long timeMs, long stepMs, ThrowingSupplier<T> unstableCode, Class<? extends Throwable> ... acceptedThrowablesClasses) {
        Set acceptedThrowables = Stream.of(acceptedThrowablesClasses).collect(Collectors.toSet());
        timeMs += System.currentTimeMillis();
        while (true) {
            try {
                return unstableCode.get();
            }
            catch (Throwable intercepted) {
                if (timeMs < System.currentTimeMillis() || !acceptedThrowables.contains(intercepted.getClass())) {
                    throw new RuntimeException(intercepted);
                }
                this.delay(stepMs);
                continue;
            }
            break;
        }
    }

    @SafeVarargs
    public final <T> T getWithRetry(long timeMs, ThrowingSupplier<T> unstableCode, Class<? extends Throwable> ... acceptedThrowablesClasses) {
        return this.getWithRetry(timeMs, Math.max(timeMs / 100L, 20L), unstableCode, acceptedThrowablesClasses);
    }

    @SafeVarargs
    public final void runWithRetry(long timeMs, long stepMs, ThrowingRunnable unstableCode, Class<? extends Throwable> ... acceptedThrowablesClasses) {
        this.getWithRetry(timeMs, stepMs, () -> {
            unstableCode.run();
            return null;
        }, acceptedThrowablesClasses);
    }

    @SafeVarargs
    public final void runWithRetry(long timeMs, ThrowingRunnable unstableCode, Class<? extends Throwable> ... acceptedThrowablesClasses) {
        this.runWithRetry(timeMs, Math.max(timeMs / 100L, 20L), unstableCode, acceptedThrowablesClasses);
    }

    public void pauseTest() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        if (TestHelper.isLanguageServerMode()) {
            return;
        }
        if (TestHelper.isTestServer() && !Boolean.valueOf(System.getenv("DVT_TEST_SEQUENCER_ENABLE")).booleanValue()) {
            return;
        }
        TestHelper.out.println("[TESTFLOW] test paused");
        testIsPaused.set(true);
        while (testIsPaused.get()) {
            this.delay(1000L);
        }
        TestHelper.out.println("[TESTFLOW] test unpaused");
    }

    public void playTest() {
        testIsPaused.set(false);
    }

    public void runAndWaitForJobs(EclipseJobsSyncer jobsSyncer, Runnable code) {
        ObjectionManager.getInstance().suspendObjectionSyncAndRun(() -> {
            code.run();
            jobsSyncer.waitForJobs();
        });
    }

    public <T> T getAndWaitForJobs(EclipseJobsSyncer jobsSyncer, Supplier<T> code) {
        return (T)ObjectionManager.getInstance().suspendObjectionSyncAndGet(() -> {
            Object ret = code.get();
            jobsSyncer.waitForJobs();
            return ret;
        });
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

