/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ucis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossDefaultValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCGroupValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UCISDBWriter {
    private static final String DB_STRING = "jdbc:sqlite:";
    private static final String CREATE_MODULE_TABLE = "CREATE TABLE UCIS_DU_MODULE (\tmoduleId INTEGER PRIMARY KEY AUTOINCREMENT,\tname TEXT NOT NULL);";
    private static final String CREATE_INSTANCE_TABLE = "CREATE TABLE UCIS_INSTANCE (instanceId INTEGER PRIMARY KEY AUTOINCREMENT,\tname TEXT NOT NULL,\tfullPath TEXT NOT NULL,\tmoduleId INTEGER NOT NULL,\tparentId INTEGER,\tFOREIGN KEY (parentId) REFERENCES UCIS_INSTANCE(parentId),\tFOREIGN KEY (moduleId) REFERENCES UCIS_DU_MODULE(moduleId));";
    private static final String CREATE_COVERGROUP_TABLE = "CREATE TABLE UCIS_COVERGROUP (\tcovergroupId INTEGER PRIMARY KEY AUTOINCREMENT,\tname TEXT NOT NULL,\tmoduleId INTEGER NOT NULL,   coverage REAL,\tFOREIGN KEY (moduleId) REFERENCES UCIS_DU_MODULE(moduleId));";
    private static final String CREATE_COVERGROUP_INSTANCES_TABLE = "CREATE TABLE UCIS_COVERGROUP_INSTANCE (\tcgInstanceId INTEGER PRIMARY KEY AUTOINCREMENT,\tname TEXT NOT NULL,\tcovergroupId INTEGER NOT NULL,\tcoverage REAL,   weight INTEGER,\tinstanceId INTEGER NOT NULL,\tFOREIGN KEY (instanceId) REFERENCES UCIS_INSTANCE(instanceId),\tFOREIGN KEY (covergroupId) REFERENCES UCIS_COVERGROUP(covergroupId));";
    private static final String CREATE_COVERPOINT_TABLE = "CREATE TABLE UCIS_COVERPOINT (\tcoverpointId INTEGER PRIMARY KEY AUTOINCREMENT,\tname TEXT NOT NULL,\texpression TEXT NOT NULL,\tisCross INTEGER, \tcovergroupId INTEGER NOT NULL,\tFOREIGN KEY (covergroupId) REFERENCES UCIS_COVERGROUP(covergroupId));";
    private static final String CREATE_COVERPOINT_INSTANCE_TABLE = "CREATE TABLE UCIS_COVERPOINT_INSTANCE (\tcpInstanceId INTEGER PRIMARY KEY AUTOINCREMENT,\tcoverpointId INTEGER NOT NULL,\tcoverage REAL,\tcgInstanceId INTEGER NOT NULL,\tFOREIGN KEY (cgInstanceId) REFERENCES UCIS_COVERGROUP_INSTANCE(cgInstanceId),\tFOREIGN KEY (coverpointId) REFERENCES UCIS_COVERPOINT(coverpointId));";
    private static final String CREATE_BIN_TABLE = "CREATE TABLE UCIS_BIN (\tbinInstanceId INTEGER PRIMARY KEY AUTOINCREMENT,\thitCount LONG,\tname TEXT,   type INTEGER,\tcpInstanceId INTEGER NOT NULL,\tFOREIGN KEY (cpInstanceId) REFERENCES UCIS_COVERPOINT_INSTANCE(cpInstanceId));";
    private String dbUrl;
    Map<IRfNamedElement, Integer> knownModules = new HashMap<IRfNamedElement, Integer>();
    Map<XNamedElement, Integer> knownInstances = new HashMap<XNamedElement, Integer>();
    Map<IRfNamedElement, Integer> knownCoverGroups = new HashMap<IRfNamedElement, Integer>();
    Map<IRfNamedElement, Integer> knownCoverPoints = new HashMap<IRfNamedElement, Integer>();
    Map<IRfNamedElement, Integer> knownBins = new HashMap<IRfNamedElement, Integer>();
    List<XCGroupValueHolder> cgInstances = new LinkedList<XCGroupValueHolder>();

    public UCISDBWriter(String dbPath) {
        this.dbUrl = DB_STRING + dbPath;
        File dbFile = new File(dbPath);
        try {
            Files.delete(dbFile.toPath());
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.createTables();
    }

    private void deepClean() {
        this.knownInstances.clear();
        this.knownCoverGroups.clear();
        this.knownModules.clear();
        this.knownInstances = null;
        this.knownCoverGroups = null;
        this.knownModules = null;
        this.cgInstances = null;
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.dbUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTables() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Connection conn = this.getConnection();
                try {
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute(CREATE_MODULE_TABLE);
                        stmt.execute(CREATE_INSTANCE_TABLE);
                        stmt.execute(CREATE_COVERGROUP_TABLE);
                        stmt.execute(CREATE_COVERGROUP_INSTANCES_TABLE);
                        stmt.execute(CREATE_COVERPOINT_TABLE);
                        stmt.execute(CREATE_COVERPOINT_INSTANCE_TABLE);
                        stmt.execute(CREATE_BIN_TABLE);
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            DVTLogger.INSTANCE.logError("Error creating table: " + e.getMessage());
        }
    }

    public void addCoverGroupDef(XCGroupValueHolder cgroupHolder) {
        Deque<XNamedElement> hierarchyPath = cgroupHolder.getHierarchyPath();
        this.insertAndGetInstanceId(hierarchyPath);
        IRfNamedElement cgNamedElement = cgroupHolder.getNamedElement();
        IRfNamedElement enclosingModule = cgroupHolder.getInstanceScope().getNamedElement();
        int moduleId = this.knownModules.get(enclosingModule);
        Integer cgDefId = this.knownCoverGroups.get(cgNamedElement);
        if (cgDefId != null) {
            return;
        }
        String cGroupName = cgroupHolder.getCompleteTypeName();
        cgDefId = this.insertCoverGroupSQL(cGroupName, moduleId, 0.0);
        this.knownCoverGroups.put(cgNamedElement, cgDefId);
        this.insertCoverPointsAndBins(cgroupHolder, cgDefId);
    }

    public void addCoverGroupInstance(XCGroupValueHolder cgroupHolder) {
        Deque<XNamedElement> hierarchyPath = cgroupHolder.getHierarchyPath();
        int instanceId = this.insertAndGetInstanceId(hierarchyPath);
        cgroupHolder.setInstanceIdUCIS(instanceId);
        this.cgInstances.add(cgroupHolder);
    }

    private void insertCrossBinCombination(List<XCBinValueHolder> currentCombination, XCBinCrossDefaultValueHolder crossDefaultBin, int cpId) {
        String crossBinName = DVTStringUtil.join(currentCombination.stream().map(bin -> {
            void binArray;
            void var2_1;
            XCBinArrayValueHolder xCBinArrayValueHolder;
            XCBinValueHolder xCBinValueHolder = bin;
            return xCBinValueHolder instanceof XCBinArrayValueHolder && (xCBinArrayValueHolder = (XCBinArrayValueHolder)xCBinValueHolder) == (XCBinArrayValueHolder)var2_1 ? binArray.getLastInternalBinHit().getName() : bin.getName();
        }).collect(Collectors.toList()), ",");
        crossBinName = "<" + crossBinName + ">";
        this.insertBinSQL(crossBinName, crossDefaultBin.getHitCountOfBin(crossBinName), XCBinValueHolder.BIN_TYPE.CROSS_BIN.getId(), cpId);
    }

    private void generateCrossCombinations(List<List<XCBinValueHolder>> crossItemsBins, int currentIndex, List<XCBinValueHolder> currentCombination, XCBinCrossDefaultValueHolder crossDefaultBin, int cpId) {
        if (currentIndex == crossItemsBins.size()) {
            this.insertCrossBinCombination(currentCombination, crossDefaultBin, cpId);
            return;
        }
        for (XCBinValueHolder binHolder : crossItemsBins.get(currentIndex)) {
            currentCombination.set(currentIndex, binHolder);
            this.generateCrossCombinations(crossItemsBins, currentIndex + 1, currentCombination, crossDefaultBin, cpId);
        }
    }

    public void writeCoverGroupInstances() {
        if (this.cgInstances == null) {
            return;
        }
        for (XCGroupValueHolder cgInstance : this.cgInstances) {
            int cgInstanceId = this.insertCoverGroupInstanceSQL(cgInstance.getInstanceKnownName(), this.knownCoverGroups.get(cgInstance.getNamedElement()), cgInstance.getInstanceIdUCIS(), cgInstance.getCoverage(), cgInstance.getWeight());
            for (XCPointValueHolder cPoint : cgInstance.getCpoints()) {
                if (cPoint.isArtificial()) continue;
                int cpInstanceId = this.insertCoverPointInstanceSQL(this.knownCoverPoints.get(cPoint.getNamedElement()), cgInstanceId, cPoint.getCoverage());
                cPoint.setCoverPointUCISId(cpInstanceId);
                for (XCBinValueHolder xCBinValueHolder : cPoint.getBinHolders(false, true)) {
                    if (!(xCBinValueHolder instanceof XCBinArrayValueHolder var9_11)) {
                        this.insertBinSQL(xCBinValueHolder.getName(), xCBinValueHolder.getHitCount(), xCBinValueHolder.getType(), cpInstanceId);
                        continue;
                    }
                    for (XCBinValueHolder internalBinHolder : binArrayHolder.getBins()) {
                        this.insertBinSQL(internalBinHolder.getName(), internalBinHolder.getHitCount(), internalBinHolder.getType(), cpInstanceId);
                    }
                }
                XCPointValueHolder xCPointValueHolder = cPoint;
                if (!(xCPointValueHolder instanceof XCPointCrossValueHolder) || (var7_9 = (XCPointCrossValueHolder)xCPointValueHolder) != (XCPointCrossValueHolder)xCPointValueHolder) continue;
                if (var7_9.isDefault()) {
                    this.generateCrossCombinations(var7_9.getCrossItemsBins(), 0, new ArrayList<Object>(Collections.nCopies(var7_9.getCrossItemsNo(), null)), var7_9.getAutomaticBinHolder(), cpInstanceId);
                    continue;
                }
                for (Map.Entry<String, Integer> entry : cPoint.getAutomaticBins().entrySet()) {
                    this.insertBinSQL(entry.getKey(), entry.getValue().intValue(), XCBinValueHolder.BIN_TYPE.CROSS_BIN.getId(), cpInstanceId);
                }
            }
        }
        this.deepClean();
    }

    private void insertCoverPointsAndBins(XCGroupValueHolder cgHolder, Integer cgDefId) {
        List<XCPointValueHolder> cpValueHolders = cgHolder.getCpoints();
        for (XCPointValueHolder cpValueHolder : cpValueHolders) {
            int cpId = this.insertCoverPointSQL(cpValueHolder.getName(), cpValueHolder.getExpressionText(), cpValueHolder instanceof XCPointCrossValueHolder, cgDefId);
            this.knownCoverPoints.put(cpValueHolder.getNamedElement(), cpId);
        }
    }

    private int insertAndGetInstanceId(Deque<XNamedElement> hierarchyPath) {
        int prevInstId = -1;
        StringBuilder currentPath = new StringBuilder("");
        for (XNamedElement currentInst : hierarchyPath) {
            String instanceName = currentInst.getHierarchyPath().lastSegment();
            currentPath.append("/").append(instanceName);
            if (this.knownInstances.containsKey(currentInst)) {
                prevInstId = this.knownInstances.get(currentInst);
                continue;
            }
            IRfNamedElement module = currentInst.getNamedElement();
            if (prevInstId == -1) {
                if (this.knownModules.containsKey(module)) continue;
                int moduleId = this.insertModuleSQL(instanceName);
                this.knownModules.put(module, moduleId);
                prevInstId = this.insertInstanceSQL(instanceName, currentPath.toString(), moduleId, -1);
                this.knownInstances.put(currentInst, prevInstId);
                continue;
            }
            Integer moduleId = this.knownModules.get(module);
            if (moduleId == null) {
                String moduleName = module.getName();
                moduleId = this.insertModuleSQL(moduleName);
                this.knownModules.put(module, moduleId);
            }
            prevInstId = this.insertInstanceSQL(instanceName, currentPath.toString(), moduleId, prevInstId);
            this.knownInstances.put(currentInst, prevInstId);
        }
        return prevInstId;
    }

    /*
     * Exception decompiling
     */
    public int insertModuleSQL(String moduleName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertInstanceSQL(String instanceName, String fullPath, int moduleId, int parentId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertCoverGroupSQL(String coverGroupName, int moduleId, double coverage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertCoverGroupInstanceSQL(String name, int coverGroupId, int instanceId, double coverage, int weight) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertCoverPointSQL(String name, String expression, boolean isCross, int coverGroupId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertCoverPointInstanceSQL(int coverPointId, int cgInstanceId, double coverage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int insertBinSQL(String name, long hitCount, int type, int coverPointId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

