/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;

public class AutobuildDisabledDialog
extends MessageDialog {
    public static final String PREFERENCE_PAGE_ID = "ro.amiq.dvt.ui.buildconfig.preferences.BCGeneralPage";
    public static final String INCREMENTAL_EXPLANATION = "When incremental build is disabled, DVT's advanced functionality is reduced: errors are not signaled as you type, autocomplete and hyperlinks are innaccurate and views content is incomplete.";

    private AutobuildDisabledDialog() {
        super(Utils.getActiveShell(), "Do you want to enable incremental build?", null, "Incremental build is disabled. Do you want to enable it?\n\nWhen incremental build is disabled, DVT's advanced functionality is reduced: errors are not signaled as you type, autocomplete and hyperlinks are innaccurate and views content is incomplete.\n\nYou can prevent this dialog from showing up again from the <a href=\"link\">DVT Build Configuration Preference Page</a>", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getQuestionImage();
        if (image == null || this.message == null) {
            return composite;
        }
        this.imageLabel = new Label(composite, 0);
        image.setBackground(this.imageLabel.getBackground());
        this.imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        Link link = new Link(composite, this.getMessageLabelStyle());
        link.setText(this.message);
        DVTUiUtils.setPlatformLinkColor((Link)link);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)AutobuildDisabledDialog.this.getShell(), (String)AutobuildDisabledDialog.PREFERENCE_PAGE_ID, null, null).open();
            }
        });
        return composite;
    }

    public static void show() {
        if (Display.getCurrent() == null) {
            DVTLogger.INSTANCE.logError("AutobuildDisabledDialog.show() should never be called on a non-UI thread");
            return;
        }
        int result = new AutobuildDisabledDialog().open();
        switch (result) {
            case 0: {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                if (preferences == null) {
                    return;
                }
                preferences.putBoolean("description.autobuilding", true);
                break;
            }
        }
    }
}

