/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTNotification;
import ro.amiq.dvt.ui.DVTPreferencePageInfoDialog;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AutomaticBuildDVTNotification
extends DVTNotification {
    public static final String UNBUILT_CHANGES_ID = "UnbuiltChanges";
    public static final String PERFORM_FULL_ELABORATION_ID = "PerformFullElaboration";
    private Map<String, Runnable> listeners = new HashMap<String, Runnable>();
    private String turnNotificationsOnText;
    private String changesText = "";
    private String doNotShowAgainText;
    private Composite notificationComposite;
    private Link changesLink;
    private int nofChangedFiles;

    public AutomaticBuildDVTNotification(IDVTNotificationsHost host, int style, String family) {
        super(host, style, family);
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        if (this.turnNotificationsOnText == null) {
            return;
        }
        if (this.doNotShowAgainText == null) {
            return;
        }
        this.notificationComposite = new Composite(parent, 4);
        GridLayout layout = new GridLayout(2, false);
        this.notificationComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.notificationComposite.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        Composite innerComposite = new Composite(this.notificationComposite, 16384);
        GridLayout secondLayout = new GridLayout(2, false);
        secondLayout.horizontalSpacing = 10;
        secondLayout.verticalSpacing = 0;
        secondLayout.marginHeight = 0;
        secondLayout.marginWidth = 0;
        innerComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        innerComposite.setLayout((Layout)secondLayout);
        this.addTurnOnLink(innerComposite);
        this.addChangesLink(innerComposite);
        this.addDoNotShowAgainLink(this.notificationComposite);
        this.addUnbuildChangesLinkListener();
    }

    private void addTurnOnLink(Composite innerComposite) {
        Link turnOnLink = new Link(innerComposite, 64);
        turnOnLink.setText(this.turnNotificationsOnText);
        DVTUiUtils.setPlatformLinkColor((Link)turnOnLink);
        DVTColorUtil.INSTANCE.setForeground((Control)turnOnLink, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"), true);
        GridData turnOnLinkData = new GridData(1, 0x1000000, true, false);
        turnOnLink.setLayoutData((Object)turnOnLinkData);
        turnOnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Runnable r = AutomaticBuildDVTNotification.this.listeners.get(e.text);
                if (r != null) {
                    r.run();
                }
                if (e.text.equals("turnAutomaticBuildOn")) {
                    AutomaticBuildDVTNotification.this.destroy();
                }
            }
        });
    }

    private void addChangesLink(Composite innerComposite) {
        this.changesLink = new Link(innerComposite, 4);
        this.changesLink.setText(this.changesText);
        DVTUiUtils.setPlatformLinkColor((Link)this.changesLink);
        DVTColorUtil.INSTANCE.setForeground((Control)this.changesLink, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"), true);
        GridData buildRecentChagesLinkData = new GridData(131072, 0x1000000, true, false);
        this.changesLink.setLayoutData((Object)buildRecentChagesLinkData);
    }

    private void addDoNotShowAgainLink(Composite notificationComposite) {
        Link doNotShowAgainLink = new Link(notificationComposite, 64);
        doNotShowAgainLink.setText(this.doNotShowAgainText);
        DVTUiUtils.setPlatformLinkColor((Link)doNotShowAgainLink);
        DVTColorUtil.INSTANCE.setForeground((Control)doNotShowAgainLink, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"), true);
        GridData doNotShowAgainLinkData = new GridData(0x1000008, 0x1000000, true, false);
        doNotShowAgainLink.setLayoutData((Object)doNotShowAgainLinkData);
        doNotShowAgainLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Runnable r = AutomaticBuildDVTNotification.this.listeners.get(e.text);
                if (r != null) {
                    r.run();
                }
                if (e.text.equals("doNotShowAgain")) {
                    AutomaticBuildDVTNotification.this.destroy();
                }
            }
        });
    }

    protected void addUnbuildChangesLinkListener() {
        if (this.changesLink == null) {
            return;
        }
        this.changesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!e.text.equals(AutomaticBuildDVTNotification.UNBUILT_CHANGES_ID)) {
                    return;
                }
                try {
                    IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
                    if (handlerService == null) {
                        return;
                    }
                    ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
                    if (commandService == null) {
                        return;
                    }
                    ParameterizedCommand buildProjectCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand("org.eclipse.ui.project.buildProject"), null);
                    if (buildProjectCommand == null) {
                        return;
                    }
                    handlerService.executeCommand(buildProjectCommand, null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException ex) {
                    DVTLogger.INSTANCE.logError(ex);
                }
            }
        });
    }

    public void updateUnbuildChangesLink(final int nofChangedFiles) {
        if (this.nofChangedFiles == nofChangedFiles) {
            return;
        }
        this.nofChangedFiles = nofChangedFiles;
        Utils.safeRunAsynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (AutomaticBuildDVTNotification.this.changesLink == null) {
                    return;
                }
                if (nofChangedFiles == -1) {
                    AutomaticBuildDVTNotification.this.changesLink.setText("<a href=\"UnbuiltChanges\"> The project was never built. Build it now? </a>");
                    AutomaticBuildDVTNotification.this.layout();
                    return;
                }
                if (nofChangedFiles == 0) {
                    AutomaticBuildDVTNotification.this.changesLink.setText("");
                    AutomaticBuildDVTNotification.this.layout();
                    return;
                }
                String unbuiltChangesText = "";
                unbuiltChangesText = nofChangedFiles > 50 ? "<a href=\"UnbuiltChanges\">Full build (more than 50 files changed)</a>" : "<a href=\"UnbuiltChanges\">Build " + nofChangedFiles + " changed " + DVTStringUtil.getGrammarFormOf("file", nofChangedFiles) + "</a>";
                AutomaticBuildDVTNotification.this.changesLink.setText(unbuiltChangesText);
                AutomaticBuildDVTNotification.this.layout();
            }
        });
    }

    public AutomaticBuildDVTNotification setTurnOnText(String text) {
        this.turnNotificationsOnText = text;
        return this;
    }

    public AutomaticBuildDVTNotification enableDoNotShowAgainLink() {
        this.doNotShowAgainText = "<a href=\"doNotShowAgain\">Don't show again</a>";
        this.setListener("doNotShowAgain", () -> {
            DVTPlugin.getDefault().getPreferenceStore().setValue("show.automatic.build.notifications", false);
            DVTPreferencePageInfoDialog.show(new DVTPreferencePageInfoDialog());
        });
        return this;
    }

    private void layout() {
        this.notificationComposite.layout();
    }

    public AutomaticBuildDVTNotification setListener(String href, Runnable r) {
        this.listeners.put(href, r);
        return this;
    }
}

