/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class BuildInterruptedDialog
extends MessageDialog {
    private IProject fProject;
    private boolean fIncremental;
    private String fFileName;

    private BuildInterruptedDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, IProject project, String fileName, boolean incremental) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.fProject = project;
        this.fFileName = fileName;
        this.fIncremental = incremental;
    }

    public static void openWarning(final IProject project, final String fileName, final boolean incremental) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildInterruptedDialog dialog = new BuildInterruptedDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), String.valueOf(incremental ? "Incremental build" : "Build") + " canceled for '" + project.getName() + "'!", null, this.getTimeoutMessage(project, incremental), 4, new String[]{IDialogConstants.OK_LABEL}, 0, project, fileName, incremental);
                dialog.open();
            }

            private String getTimeoutMessage(IProject project2, boolean incremental2) {
                return "\n" + (incremental2 ? "Incremental build" : "Build") + " process was interrupted due to timeout after " + (incremental2 ? BuildConfigManager.getIncrementalCompileTimeout(project2) : BuildConfigManager.getFileCompileTimeout(project2)) + " seconds for project '" + project2.getName() + "'!";
            }
        });
    }

    protected Control createCustomArea(Composite parent) {
        return this.createLinks(parent);
    }

    private Control createLinks(Composite parent) {
        final IFile currentBuildConfigFile = this.fProject.getFile(".dvt/" + BuildConfigManager.getActiveBuildConfigName(this.fProject) + ".build");
        try {
            currentBuildConfigFile.refreshLocal(0, null);
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new FillLayout(512));
        Text text = new Text(wrapper, 10);
        Link propertyPageLink = new Link(wrapper, 0);
        String directive = this.fIncremental ? IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT.toString() : IBuildConfigParserConstants.Directive.FILE_COMPILE_TIMEOUT.toString();
        String textMessage = "You can skip compile this file by adding the +dvt_skip_compile+" + this.fFileName + " directive or change the timeout threshold by adding or modifying the +" + directive + " directive in ";
        StringBuilder sb = DVTStringUtil.textWrap2(100, textMessage);
        text.setText(sb.toString());
        propertyPageLink.setText("<a href=\"\">" + currentBuildConfigFile.getProjectRelativePath() + "</a>");
        DVTUiUtils.setPlatformLinkColor((Link)propertyPageLink);
        text.setEditable(false);
        DVTColorUtil.INSTANCE.setBackground((Control)text, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
        Text extraInfoText = new Text(wrapper, 10);
        String extraInfoMessage = "Note that the +dvt_skip_compile directive is NOT global. It should either be specified in each relevant invocation or used in conjunction with +dvt_prepend_init in order to have effect for all invocations.";
        sb = DVTStringUtil.textWrap2(100, extraInfoMessage);
        extraInfoText.setText(sb.toString());
        DVTColorUtil.INSTANCE.setBackground((Control)extraInfoText, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
        propertyPageLink.setToolTipText("Open " + currentBuildConfigFile.getProjectRelativePath() + " file");
        if (currentBuildConfigFile.exists()) {
            propertyPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)currentBuildConfigFile);
                            }
                            catch (PartInitException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    });
                    BuildInterruptedDialog.this.close();
                }
            });
        }
        return propertyPageLink;
    }
}

