/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class DVTImageCache {
    private final HashMap<ImageDescriptor, Image> imageMap = new HashMap();

    public Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = this.imageMap.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            this.imageMap.put(imageDescriptor, image);
        }
        return image;
    }

    public List<ImageDescriptor> getImageDescriptors(Image image) {
        ArrayList<ImageDescriptor> matches = new ArrayList<ImageDescriptor>();
        Set<Map.Entry<ImageDescriptor, Image>> set = this.imageMap.entrySet();
        for (Map.Entry<ImageDescriptor, Image> entry : set) {
            if (!entry.getValue().equals((Object)image)) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    public List<Image> getCompositeImages() {
        ArrayList<Image> result = new ArrayList<Image>();
        Set<Map.Entry<ImageDescriptor, Image>> set = this.imageMap.entrySet();
        for (Map.Entry<ImageDescriptor, Image> entry : set) {
            ImageDescriptor key = entry.getKey();
            if (!(key instanceof DecorationOverlayIcon)) continue;
            result.add(this.imageMap.get(key));
        }
        return result;
    }
}

