/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.MouseTimeoutActionRunner;
import ro.amiq.dvt.ui.ButtonFactory;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class DVTNotification {
    private static final int NOTIFICATION_TIMEOUT = 6000;
    private static final int DELTA_T = 100;
    protected Composite fHostComposite;
    protected Composite fNotificationComposite;
    private boolean fDestroy;
    private boolean fHorizontal;
    private String fFamily;
    protected String fShowPreferenceKey;
    protected boolean fHasButtons = true;
    protected boolean fHasTimeout = true;

    public DVTNotification(IDVTNotificationsHost host, int style, String family) {
        this.fHorizontal = (style & 0x100) != 0;
        this.fHostComposite = host.getNotificationsHostComposite();
        this.fFamily = family;
    }

    public Composite getNotificationComposite() {
        return this.fNotificationComposite;
    }

    private boolean createControl() {
        if (this.fHostComposite == null || this.fHostComposite.isDisposed()) {
            return false;
        }
        if (this.fHostComposite.getData(this.fFamily) != null) {
            return false;
        }
        this.fHostComposite.setData(this.fFamily, (Object)this);
        this.fNotificationComposite = new Composite(this.fHostComposite, 2048);
        this.fNotificationComposite.setBackgroundMode(2);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fNotificationComposite, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fNotificationComposite, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
        this.fNotificationComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DVTNotification.this.fHostComposite.setData(DVTNotification.this.fFamily, null);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fNotificationComposite);
        if (this.fHasButtons) {
            GridLayoutFactory.fillDefaults().margins(3, 2).numColumns(this.fHorizontal ? 2 : 1).applyTo(this.fNotificationComposite);
        } else {
            GridLayoutFactory.fillDefaults().margins(3, 2).applyTo(this.fNotificationComposite);
        }
        Composite contentsComposite = new Composite(this.fNotificationComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, this.fHorizontal ? 0x1000000 : 4).applyTo((Control)contentsComposite);
        GridLayoutFactory.fillDefaults().applyTo(contentsComposite);
        this.createNotificationContents(contentsComposite);
        if (this.fHasButtons) {
            Composite buttonsComposite = new Composite(this.fNotificationComposite, 0);
            GridDataFactory.fillDefaults().grab(false, false).align(0x1000008, this.fHorizontal ? 0x1000000 : 1).applyTo((Control)buttonsComposite);
            buttonsComposite.setLayout((Layout)new RowLayout());
            this.createButtons(buttonsComposite);
        }
        ((GridData)this.fNotificationComposite.getLayoutData()).heightHint = 0;
        DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)this.fNotificationComposite, DVTColorUtil.INSTANCE.getBackground((Control)this.fNotificationComposite));
        DVTColorUtil.INSTANCE.setForegroundRecursive((Control)this.fNotificationComposite, DVTColorUtil.INSTANCE.getForeground((Control)this.fNotificationComposite));
        return true;
    }

    protected void createButtons(Composite buttonsComposite) {
        if (this.fShowPreferenceKey != null) {
            Button dontShowAgain = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
            dontShowAgain.setText("Don't show again");
            dontShowAgain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DVTNotification.this.fShowPreferenceKey != null) {
                        DVTPlugin.getDefault().getPreferenceStore().setValue(DVTNotification.this.fShowPreferenceKey, false);
                    }
                    DVTNotification.this.destroy();
                }
            });
        }
        Button dismiss = ButtonFactory.INSTANCE.create(buttonsComposite, 0, 0.75);
        dismiss.setText("Dismiss");
        dismiss.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTNotification.this.destroy();
            }
        });
    }

    public boolean create() {
        if (this.fShowPreferenceKey != null && !DVTPlugin.getDefault().getPreferenceStore().getBoolean(this.fShowPreferenceKey)) {
            return false;
        }
        if (!this.createControl()) {
            return false;
        }
        if (this.fHasTimeout) {
            new MouseTimeoutActionRunner((Control)this.fNotificationComposite, this.getNotificationTimeout(), () -> this.destroy()).start();
        }
        this.fDestroy = false;
        this.move();
        return true;
    }

    protected int getNotificationTimeout() {
        return 6000;
    }

    public void destroy() {
        this.fDestroy = true;
        this.move();
    }

    private void move() {
        int nextHint;
        int targetHint;
        if (this.fNotificationComposite == null || this.fNotificationComposite.isDisposed()) {
            return;
        }
        int hostWidth = this.fHostComposite.getBounds().width;
        int currentHint = ((GridData)this.fNotificationComposite.getLayoutData()).heightHint;
        int n = targetHint = this.fDestroy ? 0 : this.fNotificationComposite.computeSize((int)hostWidth, (int)-1).y;
        if (!this.fDestroy && currentHint == -1 || currentHint == targetHint) {
            if (this.fDestroy) {
                this.fNotificationComposite.dispose();
                this.fHostComposite.getParent().layout(true);
            }
            return;
        }
        int currentHeight = this.fNotificationComposite.getSize().y;
        if (this.fDestroy) {
            nextHint = currentHeight / 3 - 1;
            if (nextHint < 0) {
                nextHint = 0;
            }
        } else {
            nextHint = (currentHeight + 1) * 3;
            if (nextHint >= targetHint) {
                nextHint = targetHint;
            }
        }
        if (nextHint == currentHint) {
            nextHint = targetHint;
        }
        if (!this.fDestroy && nextHint == targetHint) {
            nextHint = -1;
        }
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(-1, nextHint).applyTo((Control)this.fNotificationComposite);
        this.fHostComposite.getParent().layout(true);
        Display.getCurrent().timerExec(100, new Runnable(){

            @Override
            public void run() {
                DVTNotification.this.move();
            }
        });
    }

    public DVTNotification setShowPreferenceKey(String prefKey) {
        this.fShowPreferenceKey = prefKey;
        return this;
    }

    public DVTNotification disableTimeout() {
        this.fHasTimeout = false;
        return this;
    }

    public DVTNotification disableButtons() {
        this.fHasButtons = false;
        return this;
    }

    protected abstract void createNotificationContents(Composite var1);
}

