/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class DVTSpinnerInputDialog
extends Dialog {
    private String fTitle;
    private String fMessage;
    private Integer fInputNumber;
    private int fMinValue;
    private int fMaxValue;
    private Spinner fSpinner;
    private Button fOkButton;

    public DVTSpinnerInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, int initialValue, int minValue, int maxValue) {
        super(parentShell);
        this.fTitle = dialogTitle;
        this.fMessage = dialogMessage;
        this.fInputNumber = initialValue;
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.fMessage != null) {
            Label label = new Label(composite, 64);
            label.setText(this.fMessage);
            GridData data = new GridData(1796);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.fSpinner = new Spinner(composite, 2052);
        this.fSpinner.setLayoutData((Object)new GridData(768));
        this.fSpinner.setSelection(this.fInputNumber.intValue());
        this.fSpinner.setEnabled(true);
        this.fSpinner.setMinimum(this.fMinValue);
        this.fSpinner.setMaximum(this.fMaxValue);
        DVTSpinnerInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        this.fInputNumber = buttonId == 0 ? Integer.valueOf(this.fSpinner.getSelection()) : null;
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fSpinner.setFocus();
    }

    public Integer getValue() {
        return this.fInputNumber;
    }
}

