/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DeprecatedBuildConfigurationDialog
extends Dialog {
    public static final String EDT_NATURE = "ro.amiq.edt.enature";
    public static final String VLOGDT_NATURE = "ro.amiq.vlogdt.VlogNature";
    public static final String VHDLDT_NATURE = "ro.amiq.vhdldt.VhdlNature";
    public static final String DVT_PROJECT_SETTINGS_DIR = ".dvt";
    public static final String DVT_EDT_DEFINES = ".dvt/.edt_defines";
    public static final String DVT_EDT_IGNORE_FILES = ".dvt/.edt_ignore_files";
    public static final String DVT_EDT_TEST_FILES = ".dvt/.edt_test_files";
    public static final String DVT_EDT_TOP_FILES = ".dvt/.edt_top_files";
    public static final String DVT_EDT_SPECMAN_PATH = ".dvt/.edt_specman_path";
    public static final String DVT_VLOG_DEFINES = ".dvt/.vlog_defines";
    public static final String DVT_VLOG_IGNORE_FILES = ".dvt/.vlog_ignore_files";
    public static final String DVT_VLOG_TOP_FILES = ".dvt/.vlog_top_files";
    public static final String DVT_VLOG_VMM_PROJECT = ".dvt/.vlog_vmm_project";
    public static final String DVT_VLOG_UVM_PROJECT = ".dvt/.vlog_uvm_project";
    public static final String DVT_VLOG_OVM_PROJECT = ".dvt/.vlog_ovm_project";
    public static final String DVT_VLOG_INC_DIR = ".dvt/.vlog_inc_dir";
    public static final String DVT_VHDL_IGNORE_FILES = ".dvt/.vhdl_ignore_files";
    public static final String DVT_VHDL_TOP_FILES = ".dvt/.vhdl_top_files";
    public static final Map<String, List<String>> CONFIG_FILES_PER_NATURE = new ImmutableMap.Builder().put((Object)"ro.amiq.edt.enature", Arrays.asList(".dvt/.edt_defines", ".dvt/.edt_ignore_files", ".dvt/.edt_test_files", ".dvt/.edt_top_files", ".dvt/.edt_specman_path")).put((Object)"ro.amiq.vlogdt.VlogNature", Arrays.asList(".dvt/.vlog_defines", ".dvt/.vlog_ignore_files", ".dvt/.vlog_top_files", ".dvt/.vlog_vmm_project", ".dvt/.vlog_uvm_project", ".dvt/.vlog_ovm_project", ".dvt/.vlog_inc_dir")).put((Object)"ro.amiq.vhdldt.VhdlNature", Arrays.asList(".dvt/.vhdl_ignore_files", ".dvt/.vhdl_top_files")).build();
    private static final String MESSAGE = "Project {0} ({1}) deprecated files: \n{2}";
    private static boolean fDisableForThisSession;
    private StyledText fMessagesStyledText;
    private Label fRedLabel;
    private Link fMessageLabel;
    private Text fScriptText;
    private Button fDontShowAgain;
    private Map<IProject, List<String>> fDeprecatedFilesMap;
    private static DeprecatedBuildConfigurationDialog fInstance;

    private DeprecatedBuildConfigurationDialog(Map<IProject, List<String>> deprecatedFilesMap) {
        super(DVTUiUtils.getActiveWorkbenchWindow().getShell());
        this.fDeprecatedFilesMap = deprecatedFilesMap;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Deprecated Project Configuration");
        newShell.setImage(newShell.getDisplay().getSystemImage(1));
        super.configureShell(newShell);
    }

    public static void setDisableForThisSession(boolean value) {
        fDisableForThisSession = value;
    }

    protected Control createDialogArea(Composite composite) {
        Composite wrapper = new Composite(composite, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        GridData wrapperData = new GridData(4, 4, true, true);
        wrapperData.widthHint = this.convertWidthInCharsToPixels(125);
        wrapperData.heightHint = this.convertHeightInCharsToPixels(25);
        wrapper.setLayoutData((Object)wrapperData);
        Image image = this.getShell().getDisplay().getSystemImage(1);
        Label imageLabel = new Label(wrapper, 0);
        imageLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        imageLabel.setImage(image);
        Composite rightWrapper = new Composite(wrapper, 0);
        rightWrapper.setLayout((Layout)new GridLayout(1, true));
        rightWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fMessageLabel = new Link(rightWrapper, 64);
        this.fMessageLabel.setText("The following projects use deprecated configuration files. You should use <a>.dvt/default.build</a> instead.\n");
        DVTUiUtils.setPlatformLinkColor((Link)this.fMessageLabel);
        this.fMessageLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fMessageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTUiUtils.openHelpPage((String)"Build_Configurations.html");
            }
        });
        this.fScriptText = new Text(rightWrapper, 66);
        this.fScriptText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fScriptText.setText("You can use the script $DVT_HOME/bin/dvt_migrate_config.sh to generate a .dvt/default.build file. Please consult the script help for details.");
        DVTColorUtil.INSTANCE.setBackground((Control)this.fScriptText, DVTColorUtil.INSTANCE.getBackground((Control)this.fScriptText.getParent()), true);
        this.fMessagesStyledText = new StyledText(rightWrapper, 2882);
        this.fMessagesStyledText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fMessagesStyledText.setEditable(false);
        StringBuilder text = new StringBuilder();
        for (Map.Entry<IProject, List<String>> entry : this.fDeprecatedFilesMap.entrySet()) {
            IProject project = entry.getKey();
            List<String> deprecatedFiles = entry.getValue();
            text.append(MessageFormat.format(MESSAGE, project.getName(), project.getLocation().toOSString(), DVTStringUtil.join(deprecatedFiles, "\n"))).append("\n\n");
        }
        this.fMessagesStyledText.setText(text.toString());
        this.fRedLabel = new Label(rightWrapper, 64);
        this.fRedLabel.setText("Starting with DVT 3.5 the deprecated configuration files are no longer supported.");
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRedLabel, DVTColorUtil.INSTANCE.getBackground((Control)rightWrapper));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fRedLabel, Display.getDefault().getSystemColor(3));
        FontData[] fD = this.fRedLabel.getFont().getFontData();
        fD[0].setStyle(1);
        this.fRedLabel.setFont(new Font((Device)this.getShell().getDisplay(), fD[0]));
        this.fRedLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fDontShowAgain = new Button(rightWrapper, 32);
        this.fDontShowAgain.setText("Don't show me this message again during this session");
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.fDontShowAgain != null && this.fDontShowAgain.getSelection()) {
            DeprecatedBuildConfigurationDialog.setDisableForThisSession(true);
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        fInstance = null;
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public static void runCheck() {
        IProject[] projects;
        if (fDisableForThisSession || fInstance != null) {
            return;
        }
        HashMap<IProject, List<String>> deprecatedFilesMap = new HashMap<IProject, List<String>>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && project.getLocation().toFile().exists() && !DeprecatedBuildConfigurationDialog.hasBuildConfig(project)) {
                try {
                    ArrayList<String> deprecatedFiles = new ArrayList<String>();
                    deprecatedFiles.addAll(DeprecatedBuildConfigurationDialog.getDeprecatedFilesInUse(project, EDT_NATURE));
                    deprecatedFiles.addAll(DeprecatedBuildConfigurationDialog.getDeprecatedFilesInUse(project, VLOGDT_NATURE));
                    deprecatedFiles.addAll(DeprecatedBuildConfigurationDialog.getDeprecatedFilesInUse(project, VHDLDT_NATURE));
                    if (!deprecatedFiles.isEmpty()) {
                        deprecatedFilesMap.put(project, deprecatedFiles);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            ++n2;
        }
        if (deprecatedFilesMap.isEmpty()) {
            return;
        }
        fInstance = new DeprecatedBuildConfigurationDialog(deprecatedFilesMap);
        Utils.getActiveShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                fInstance.open();
            }
        });
    }

    private static List<String> getDeprecatedFilesInUse(IProject project, String natureId) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        if (!project.hasNature(natureId)) {
            return result;
        }
        for (String configFile : CONFIG_FILES_PER_NATURE.get(natureId)) {
            if (!project.getLocation().append(configFile).toFile().exists()) continue;
            result.add(configFile);
        }
        return result;
    }

    private static boolean hasBuildConfig(IProject project) {
        File dotDVT = project.getLocation().append(DVT_PROJECT_SETTINGS_DIR).toFile();
        final AtomicBoolean hasBuildConfig = new AtomicBoolean();
        dotDVT.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File candidate = new File(dir, name);
                if (candidate.isDirectory()) {
                    return false;
                }
                if (candidate.getName().endsWith(".build") && candidate.isFile()) {
                    hasBuildConfig.set(true);
                    return false;
                }
                return true;
            }
        });
        return hasBuildConfig.get();
    }
}

