/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;

public class InvalidSettingsLocationDialog
extends MessageDialog {
    private static final String TITLE = "Invalid Common Settings Location";
    private static final String VALID_PATHS_MESSAGE = "Using the following locations for DVT_COMMON_SETTINGS:";
    private static final String INVALID_PATHS_MESSAGE = "The following paths set in the environment variable 'DVT_COMMON_SETTINGS' do not exist on the filesystem:";
    private static final String PREFERENCE_PAGE_MESSAGE = "You can prevent this dialog from showing up again from the <a href=\"link\">DVT Preference Page</a>";
    private static final String DONT_SHOW_AGAIN_MESSAGE = "Don't Show Again";
    private static final int MAX_HEIGHT = 500;

    private InvalidSettingsLocationDialog(int image, String dialogText) {
        super(Utils.getActiveShell(), TITLE, null, dialogText, image, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    protected Control createMessageArea(Composite parent) {
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(4, 128, true, false));
        outer.setLayout((Layout)new GridLayout(2, false));
        Label imageLabel = new Label(outer, 0);
        imageLabel.setImage(this.getImage());
        imageLabel.setLayoutData((Object)new GridData(1, 128, false, false));
        final ScrolledComposite scrolled = new ScrolledComposite(outer, 512);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, false));
        final Composite inner = new Composite((Composite)scrolled, 0);
        inner.setLayout((Layout)new GridLayout(1, false));
        Link messageLabel = new Link(inner, 64);
        final GridData msgGD = new GridData(4, 128, true, false);
        messageLabel.setLayoutData((Object)msgGD);
        messageLabel.setText(this.message);
        DVTUiUtils.setPlatformLinkColor((Link)messageLabel);
        messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvalidSettingsLocationDialog.this.close();
                PreferencesUtil.createPreferenceDialogOn((Shell)InvalidSettingsLocationDialog.this.getShell(), (String)"ro.amiq.dvt.ui.preferences.DVTPreferencePage", null, null).open();
            }
        });
        scrolled.setContent((Control)inner);
        scrolled.setMinSize(inner.computeSize(-1, -1));
        Point preferredSize = inner.computeSize(parent.getClientArea().width, -1);
        GridData gd = (GridData)scrolled.getLayoutData();
        if (preferredSize.y > 500) {
            gd.heightHint = 500;
            scrolled.setAlwaysShowScrollBars(true);
        } else {
            gd.heightHint = preferredSize.y;
            scrolled.setAlwaysShowScrollBars(false);
        }
        scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int availableWidth;
                msgGD.widthHint = availableWidth = scrolled.getClientArea().width;
                inner.layout(true, true);
                scrolled.setMinSize(inner.computeSize(availableWidth, -1));
            }
        });
        return outer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        Button checkbox = new Button(container, 32);
        checkbox.setText(DONT_SHOW_AGAIN_MESSAGE);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Button source = (Button)e.getSource();
                if (source == null) {
                    return;
                }
                DVTPlugin.getDefault().getPreferenceStore().setValue("common.settings.paths.check", !source.getSelection());
            }
        });
        return area;
    }

    public static void show(Set<String> validPaths, Set<String> invalidPaths) {
        if (Display.getCurrent() == null) {
            DVTLogger.INSTANCE.logError("InvalidSettingsLocationDialog.show() should never be called on a non-UI thread");
            return;
        }
        String dialogText = InvalidSettingsLocationDialog.createDialogMessage(validPaths, invalidPaths);
        int dialogImage = validPaths.isEmpty() ? 1 : 2;
        new InvalidSettingsLocationDialog(dialogImage, dialogText).open();
    }

    private static String createDialogMessage(Set<String> validPaths, Set<String> invalidPaths) {
        String invalidPathsText = String.join((CharSequence)System.lineSeparator(), invalidPaths);
        StringBuilder invalidMessage = new StringBuilder(INVALID_PATHS_MESSAGE);
        invalidMessage.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        invalidMessage.append(invalidPathsText);
        invalidMessage.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        invalidMessage.append(PREFERENCE_PAGE_MESSAGE);
        if (validPaths.isEmpty()) {
            return invalidMessage.toString();
        }
        String validPathsText = String.join((CharSequence)System.lineSeparator(), validPaths);
        StringBuilder fullMessage = new StringBuilder(VALID_PATHS_MESSAGE);
        fullMessage.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        fullMessage.append(validPathsText);
        fullMessage.append(String.valueOf(System.lineSeparator()) + System.lineSeparator());
        fullMessage.append((CharSequence)invalidMessage);
        return fullMessage.toString();
    }

    protected boolean isResizable() {
        return true;
    }
}

