/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public class LazyExpandTreeViewer
extends TreeViewer {
    private int fExpandToLevel;
    private boolean fExpandedState;
    private ExpandUpdateJob fExpandUpdateJob;
    private TreeItem[] fTreeItems;
    private List<TreeItem> fCustomItems;
    private Listener fExpandListener;

    public LazyExpandTreeViewer(Tree tree) {
        super(tree);
        this.setUseHashlookup(true);
        this.fExpandUpdateJob = new ExpandUpdateJob();
        this.fCustomItems = new ArrayList<TreeItem>();
        this.fExpandListener = new Listener(){

            public void handleEvent(Event event) {
                LazyExpandTreeViewer.this.fCustomItems.add((TreeItem)event.item);
            }
        };
        this.getTree().addListener(17, this.fExpandListener);
        this.getTree().addListener(18, this.fExpandListener);
    }

    public LazyExpandTreeViewer(Composite parent, int style) {
        super(parent, 0x10000000 | style);
        this.setUseHashlookup(true);
        this.fExpandUpdateJob = new ExpandUpdateJob();
        this.fCustomItems = new ArrayList<TreeItem>();
        this.fExpandListener = new Listener(){

            public void handleEvent(Event event) {
                LazyExpandTreeViewer.this.fCustomItems.add((TreeItem)event.item);
            }
        };
        this.getTree().addListener(17, this.fExpandListener);
        this.getTree().addListener(18, this.fExpandListener);
    }

    public LazyExpandTreeViewer(Composite parent) {
        super(parent);
        this.setUseHashlookup(true);
        this.fExpandUpdateJob = new ExpandUpdateJob();
        this.fCustomItems = new ArrayList<TreeItem>();
        this.fExpandListener = new Listener(){

            public void handleEvent(Event event) {
                LazyExpandTreeViewer.this.fCustomItems.add((TreeItem)event.item);
            }
        };
        this.getTree().addListener(17, this.fExpandListener);
        this.getTree().addListener(18, this.fExpandListener);
    }

    public void expandToLevel(int expandLevel) {
        if (expandLevel > 0) {
            this.fExpandToLevel = expandLevel - 1;
            this.fExpandedState = expandLevel > 1;
        } else {
            this.fExpandToLevel = expandLevel;
            this.fExpandedState = true;
        }
        this.fCustomItems.clear();
        this.internalExpandToLevel(this.fExpandToLevel, this.fTreeItems, this.fExpandedState, false);
    }

    private void internalExpandToLevel(int expandLevel, TreeItem[] items, boolean expanded, boolean ignoreFirstLevel) {
        if (items == null) {
            return;
        }
        if (expandLevel == 0) {
            return;
        }
        if (expandLevel > 0) {
            --expandLevel;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!item.isDisposed() && item.getData() != null) {
                if (!ignoreFirstLevel && item.getExpanded() != expanded && !this.fCustomItems.contains(item)) {
                    item.setExpanded(expanded);
                }
                this.internalExpandToLevel(expandLevel, item.getItems(), expanded, false);
            }
            ++n2;
        }
    }

    public void collapseAll() {
        this.fExpandToLevel = 0;
        this.fExpandedState = false;
        this.fCustomItems.clear();
        this.internalExpandToLevel(-1, this.fTreeItems, false, false);
    }

    public void setLazyInput(Object input) {
        this.fExpandToLevel = 0;
        this.fExpandedState = false;
        this.getTree().setRedraw(false);
        this.getTree().removeAll();
        this.fCustomItems.clear();
        super.setInput(input);
        if (input instanceof List) {
            this.getTree().setItemCount(((List)input).size());
        }
        this.fTreeItems = this.getTree().getItems();
        this.getTree().setRedraw(true);
        this.getTree().update();
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public void updateExpandState(int index) {
        this.fExpandUpdateJob.cancel();
        this.fExpandUpdateJob.schedule(50L);
    }

    class ExpandUpdateJob
    extends UIJob {
        public ExpandUpdateJob() {
            super("treeUpdateExpandState");
            this.setSystem(true);
            this.setPriority(50);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            LazyExpandTreeViewer.this.internalExpandToLevel(LazyExpandTreeViewer.this.fExpandToLevel, LazyExpandTreeViewer.this.fTreeItems, LazyExpandTreeViewer.this.fExpandedState, false);
            return Status.OK_STATUS;
        }
    }
}

