/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.IListChangedListener;
import ro.amiq.dvt.ui.IListConfiguratorInputProvider;

public class ListConfiguratorComposite
extends Composite {
    private List fList;
    private Composite fButtonBox;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private SelectionListener fSelectionListener;
    private IListConfiguratorInputProvider fProvider;
    private ArrayList<IListChangedListener> fListChangeListeners;
    private String fContentKind = "files";

    public ListConfiguratorComposite(Composite parent, int style, IListConfiguratorInputProvider provider) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        this.setLayout((Layout)layout);
        this.setFont(parent.getFont());
        this.doFillIntoGrid(this, layout.numColumns);
        this.fProvider = provider;
    }

    public void setItems(String[] items) {
        if (this.fList == null || items == null) {
            return;
        }
        this.fList.setItems(items);
        this.selectionChanged();
    }

    public String[] getItems() {
        if (this.fList == null) {
            return null;
        }
        return this.fList.getItems();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fList = this.getListControl(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = ListConfiguratorComposite.convertHorizontalDLUsToPixels((Control)this.fList, 5);
        this.fList.setLayoutData((Object)gd);
        this.fList.setFont(parent.getFont());
        this.fButtonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.fButtonBox.setLayoutData((Object)gd);
    }

    public List getListControl(Composite parent) {
        if (this.fList == null) {
            this.fList = new List(parent, 2818);
            this.fList.setFont(parent.getFont());
            this.fList.addSelectionListener(this.getSelectionListener());
            this.fList.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListConfiguratorComposite.this.fList = null;
                }
            });
        }
        return this.fList;
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.fButtonBox == null) {
            this.fButtonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fButtonBox.setLayout((Layout)layout);
            this.fButtonBox.setFont(parent.getFont());
            this.createButtons(this.fButtonBox);
            this.fButtonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListConfiguratorComposite.this.fAddButton = null;
                    ListConfiguratorComposite.this.fRemoveButton = null;
                    ListConfiguratorComposite.this.fUpButton = null;
                    ListConfiguratorComposite.this.fDownButton = null;
                    ListConfiguratorComposite.this.fButtonBox = null;
                }
            });
        }
        this.selectionChanged();
        return this.fButtonBox;
    }

    private void createButtons(Composite box) {
        this.fAddButton = this.createPushButton(box, "ListEditor.add");
        this.fRemoveButton = this.createPushButton(box, "ListEditor.remove");
        this.fUpButton = this.createPushButton(box, "ListEditor.up");
        this.fDownButton = this.createPushButton(box, "ListEditor.down");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = ListConfiguratorComposite.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.createSelectionListener();
        }
        return this.fSelectionListener;
    }

    public void createSelectionListener() {
        this.fSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ListConfiguratorComposite.this.fAddButton) {
                    ListConfiguratorComposite.this.addPressed();
                } else if (widget == ListConfiguratorComposite.this.fRemoveButton) {
                    ListConfiguratorComposite.this.removePressed();
                } else if (widget == ListConfiguratorComposite.this.fUpButton) {
                    ListConfiguratorComposite.this.upPressed();
                } else if (widget == ListConfiguratorComposite.this.fDownButton) {
                    ListConfiguratorComposite.this.downPressed();
                } else if (widget == ListConfiguratorComposite.this.fList) {
                    ListConfiguratorComposite.this.selectionChanged();
                }
            }
        };
    }

    public void addListChangeListener(IListChangedListener listener) {
        if (this.fListChangeListeners == null) {
            this.fListChangeListeners = new ArrayList();
        }
        this.fListChangeListeners.add(listener);
    }

    public void removeListChangeListener(IListChangedListener listener) {
        if (this.fListChangeListeners == null) {
            this.fListChangeListeners = new ArrayList();
        }
        this.fListChangeListeners.remove(listener);
    }

    private void addPressed() {
        if (this.fProvider == null) {
            return;
        }
        String[] input = this.fProvider.getNewInput();
        if (input == null) {
            return;
        }
        final StringBuilder message = new StringBuilder();
        int i = 0;
        while (i < input.length) {
            String inputItem = input[i];
            if (inputItem != null) {
                inputItem = inputItem.trim();
                boolean alreadyInList = false;
                int j = 0;
                while (j < this.fList.getItemCount()) {
                    String listItem = this.fList.getItem(j).trim();
                    if (listItem.equals(inputItem)) {
                        message.append("\t").append(inputItem).append("\n");
                        alreadyInList = true;
                    } else if (this.fContentKind.equals("variables")) {
                        listItem = listItem.indexOf("=") == -1 ? listItem : listItem.substring(0, listItem.indexOf("=")).trim();
                        String string = inputItem = inputItem.indexOf("=") == -1 ? inputItem : inputItem.substring(0, inputItem.indexOf("=")).trim();
                        if (listItem.equals(inputItem)) {
                            message.append("\t").append(inputItem).append("\n");
                            alreadyInList = true;
                        }
                    }
                    ++j;
                }
                if (!alreadyInList) {
                    this.fList.add(input[i], this.fList.getSelectionIndex() + 1);
                    this.notifyListChangeListeners(1);
                }
            }
            ++i;
        }
        this.selectionChanged();
        if (message.length() > 0) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Existing " + ListConfiguratorComposite.this.fContentKind + "!", null, "One or more " + ListConfiguratorComposite.this.fContentKind + " you are trying to add are already in the list! " + "These " + ListConfiguratorComposite.this.fContentKind + " are:\n" + message.toString(), 4, new String[]{"OK"}, 0);
                    dialog.open();
                }
            });
        }
    }

    private void removePressed() {
        int index = this.fList.getSelectionIndex();
        int selections = this.fList.getSelectionCount();
        while (selections > 0) {
            this.fList.remove(index);
            this.notifyListChangeListeners(2);
            this.selectionChanged();
            --selections;
            index = this.fList.getSelectionIndex();
        }
    }

    private void notifyListChangeListeners(int type) {
        if (this.fListChangeListeners == null) {
            return;
        }
        for (IListChangedListener listener : this.fListChangeListeners) {
            listener.notifyListChanged(type);
        }
    }

    private void upPressed() {
        this.swap(-1);
    }

    private void downPressed() {
        this.swap(1);
    }

    private void swap(int direction) {
        int[] indexes = this.fList.getSelectionIndices();
        int i = 0;
        while (i < indexes.length) {
            String selected = this.fList.getItem(indexes[i]);
            this.fList.remove(indexes[i]);
            indexes[i] = indexes[i] + direction;
            this.fList.add(selected, indexes[i]);
            ++i;
        }
        this.fList.select(indexes);
        this.selectionChanged();
    }

    private void selectionChanged() {
        int index = this.fList.getSelectionIndex();
        int size = this.fList.getItemCount();
        this.fRemoveButton.setEnabled(index >= 0);
        this.fUpButton.setEnabled(size > 1 && index > 0);
        this.fDownButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    public void setContentKind(String contentKind) {
        this.fContentKind = contentKind;
    }
}

