/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class MissingPrecompileCmdDialog
extends MessageDialog {
    private IProject project;

    private MissingPrecompileCmdDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, IProject project) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.project = project;
    }

    public static void openWarning(IProject project) {
        if (TestHelper.isTestMode() && !TestHelper.isSWTBotSuite()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MissingPrecompileCmdDialog dialog = new MissingPrecompileCmdDialog(shell, "Build precompiled database canceled for '" + project.getName() + "'!", null, "Build precompiled database commands not found!", 4, new String[]{IDialogConstants.OK_LABEL}, 0, project);
            dialog.open();
        });
    }

    protected Control createCustomArea(Composite parent) {
        return this.createLinks(parent);
    }

    private Control createLinks(Composite parent) {
        final IFile currentBuildConfigFile = this.project.getFile(".dvt/" + BuildConfigManager.getActiveBuildConfigName(this.project) + ".build");
        try {
            currentBuildConfigFile.refreshLocal(0, null);
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new FillLayout(512));
        Text text = new Text(wrapper, 10);
        Link propertyPageLink = new Link(wrapper, 0);
        String textMessage = "You can rebuild the precompiled databases by adding the following directive +dvt_precompiled_db_build_cmd=\"<external precompile database command>\" in ";
        StringBuilder sb = DVTStringUtil.textWrap2(100, textMessage);
        text.setText(sb.toString());
        propertyPageLink.setText("<a href=\"\">" + currentBuildConfigFile.getProjectRelativePath() + "</a> for each invocation you want to rebuild.");
        DVTUiUtils.setPlatformLinkColor((Link)propertyPageLink);
        text.setEditable(false);
        DVTColorUtil.INSTANCE.setBackground((Control)text, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
        propertyPageLink.setToolTipText("Open " + currentBuildConfigFile.getProjectRelativePath() + " file");
        if (currentBuildConfigFile.exists()) {
            propertyPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        try {
                            IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)currentBuildConfigFile);
                        }
                        catch (PartInitException e1) {
                            DVTLogger.INSTANCE.logError((Throwable)e1);
                        }
                    });
                    MissingPrecompileCmdDialog.this.close();
                }
            });
        }
        return propertyPageLink;
    }
}

