/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class PrecompiledDatabaseRebuildDialog
extends MessageDialog {
    String selectableMessage;
    String redBoldMessage;

    private PrecompiledDatabaseRebuildDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, String selectableText, String redBoldMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.selectableMessage = selectableText;
        this.redBoldMessage = redBoldMessage;
    }

    public static boolean openWarning(String title, String message) {
        return PrecompiledDatabaseRebuildDialog.openWarning(title, message, null);
    }

    public static boolean openWarning(String title, String message, String selectableText) {
        boolean[] isPrecompileDbAndBuild = new boolean[1];
        String redBoldMessage = null;
        if (message.contains("The existing precompiled database will be deleted.")) {
            redBoldMessage = "The existing precompiled database will be deleted.";
            message = message.replace("The existing precompiled database will be deleted.", "");
        }
        String finalMessage = message;
        String finalRedBoldMessage = redBoldMessage;
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            PrecompiledDatabaseRebuildDialog dialog = new PrecompiledDatabaseRebuildDialog(shell, title, null, finalMessage, selectableText, finalRedBoldMessage, 4, new String[]{"Rebuild Now", "Cancel"}, 0);
            if (dialog.open() == 0) {
                blArray[0] = true;
            }
        });
        return isPrecompileDbAndBuild[0];
    }

    protected Control createCustomArea(Composite parent) {
        if (this.selectableMessage == null && this.redBoldMessage == null) {
            return null;
        }
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new FillLayout());
        if (this.selectableMessage != null) {
            Text selectableText = new Text(mainComposite, 74);
            StringBuilder sb = DVTStringUtil.textWrap2(60, this.selectableMessage);
            selectableText.setText(sb.toString());
            DVTColorUtil.INSTANCE.setBackground((Control)selectableText, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
        }
        if (this.redBoldMessage != null) {
            StyledText styledText = new StyledText(mainComposite, 74);
            styledText.setText(this.redBoldMessage);
            DVTColorUtil.INSTANCE.setBackground((Control)styledText, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
            StyleRange boldStyle = new StyleRange();
            boldStyle.start = 0;
            boldStyle.length = this.redBoldMessage.length();
            boldStyle.fontStyle = 1;
            boldStyle.foreground = DVTColorUtil.INSTANCE.getColor(255, 0, 0);
            styledText.setStyleRange(boldStyle);
        }
        return mainComposite;
    }
}

