/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class RadioButtonSelectionDialog<E>
extends TrayDialog {
    private Map<Button, E> fButtons = new HashMap<Button, E>();
    private List<E> fElements;
    private E fDefaultSelection;
    private String fTitle;
    private String fMessage;
    private String fGroupText;
    private E fSelection;

    public RadioButtonSelectionDialog(String title, String message, String groupText, List<E> elements, E defaultSelection) {
        super(DVTUiUtils.getActiveWorkbenchShell());
        if (elements == null || elements.isEmpty() || defaultSelection == null) {
            throw new IllegalArgumentException();
        }
        this.fTitle = title;
        this.fMessage = message;
        this.fGroupText = groupText;
        this.fElements = elements;
        this.fDefaultSelection = defaultSelection;
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fTitle != null) {
            newShell.setText(this.fTitle);
        }
    }

    protected void okPressed() {
        for (Map.Entry<Button, E> entry : this.fButtons.entrySet()) {
            Button b = entry.getKey();
            if (!b.getSelection()) continue;
            this.fSelection = entry.getValue();
            break;
        }
        super.okPressed();
    }

    public E getSelection() {
        if (this.fSelection == null) {
            return this.fDefaultSelection;
        }
        return this.fSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(wrapper);
        Label label = null;
        if (this.fMessage != null) {
            label = new Label(wrapper, 64);
            label.setText(this.fMessage);
        }
        Group group = new Group(wrapper, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 128).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        if (this.fGroupText != null) {
            group.setText(this.fGroupText);
        }
        for (E element : this.fElements) {
            Button button = new Button((Composite)group, 16);
            button.setSelection(element == this.fDefaultSelection);
            button.setText(element.toString());
            this.fButtons.put(button, element);
        }
        return result;
    }
}

