/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTNotification;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ReadOnlyNotification
extends DVTNotification {
    private static final int BLINK_PERIOD = 300;
    private static final int BLINK_DUTY = 100;
    private static final int BLINK_DURATION = 1500;
    private static final String fDefaultMessage = "You are writing in a read-only area: ";
    private static final String fFamily = "ReadOnlyNotification";
    private Label readOnlyLabel;
    private Runnable fBlinker;
    private Composite host;
    private boolean destroyed;
    private long fBlinkStop;

    public ReadOnlyNotification(IDVTNotificationsHost host) {
        super(host, 256, fFamily);
        this.installBlinker();
        this.host = host.getNotificationsHostComposite();
    }

    @Override
    protected void createNotificationContents(Composite parent) {
        this.readOnlyLabel = new Label(parent, 0);
        this.readOnlyLabel.setText(fDefaultMessage);
        DVTColorUtil.INSTANCE.setForeground((Control)this.readOnlyLabel, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)this.readOnlyLabel);
    }

    @Override
    public boolean create() {
        boolean result = super.create();
        this.destroyed = false;
        return result;
    }

    @Override
    protected int getNotificationTimeout() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
    }

    public void setText(String text) {
        this.readOnlyLabel.setText(fDefaultMessage + text);
    }

    private void installBlinker() {
        this.fBlinker = new Runnable(){

            @Override
            public void run() {
                if (ReadOnlyNotification.this.readOnlyLabel == null || ReadOnlyNotification.this.readOnlyLabel.isDisposed()) {
                    return;
                }
                DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)ReadOnlyNotification.this.getNotificationComposite(), JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor"));
                DVTColorUtil.INSTANCE.setForeground((Control)ReadOnlyNotification.this.readOnlyLabel, DVTColorUtil.INSTANCE.getDefaultForeground((Control)ReadOnlyNotification.this.readOnlyLabel));
                Display.getDefault().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)ReadOnlyNotification.this.getNotificationComposite(), DVTUiUtils.COLOR_RED);
                        DVTColorUtil.INSTANCE.setForeground((Control)(this).ReadOnlyNotification.this.readOnlyLabel, DVTUiUtils.COLOR_BLACK);
                    }
                });
                if (ReadOnlyNotification.this.fBlinkStop > System.currentTimeMillis()) {
                    Display.getDefault().timerExec(300, ReadOnlyNotification.this.fBlinker);
                }
            }
        };
    }

    @Override
    public void destroy() {
        super.destroy();
        this.host.setData(fFamily, null);
        this.destroyed = true;
    }

    public void blink() {
        this.fBlinkStop = System.currentTimeMillis() + 1500L;
        this.fBlinker.run();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String getText() {
        return this.readOnlyLabel.getText();
    }
}

